import { formatDate } from '../../utils/utils';
import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import mixin from '../../utils/mixin';
import regeneratorRuntime from '../../lib/regenerator-runtime/runtime';
import request from '../../config/request';
import viewpage from '../../module/viewpage';

const ViewDataMixin = mixin(viewpage, [{
  components: {
    list: {
      component: list,
      options() {
        return {
          methods: {
            handleSendOrder(e) {
              request.sendOrder(this, [this.getTapItem(e)]);
            },
            handleCancelOrder(e) {
              request.cancelOrder(this, [this.getTapItem(e)]);
            }
          },
          pageId: -1
        };
      }
    }
  },
  customModifyItem(item) {
    item.__c58 = formatDate(item.__c58, 'yyyy-MM-dd hh:mm:ss');
  },
  updateRedux() {
    if (this.detailData.data) {
      this.coms.list.updateItems([{ items: [this.detailData.data] }]);
    }
  }
}]);

Page(getPage(ViewDataMixin));
