import editpage from '../../module/editpage';
import getPage from '../../module/page';
import mixin from '../../utils/mixin';

const OrderMessageMixin = mixin(editpage, [{
  excludes: [41, 119, 120, 123, 124, 125, 126, 127, 213, 214],
  uncheck: [119, 120],
  updateRedux({ user, detailData}) {
    if (user && this.detailData.data) {
      this.setColumn('__c119', { ID: user.UserId });
    }
  }
}]);

Page(getPage(OrderMessageMixin, {
  pageId: 206
}));
