import config from '../../config/config';
import editpage from '../../module/editpage';
import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import log from '../../utils/log';
import mixin from '../../utils/mixin';
import regeneratorRuntime from '../../lib/regenerator-runtime/runtime';

const PayMixin = mixin(editpage, [{
  fetchListOnEnter: false,
  components: {
    list
  },
  submit() {
    const queryparams = this.options.pay.split('&');
    const params = {};
    queryparams.forEach(p => {
      const s = p.split('=');
      if (s[0] === 'package') {
        params[s[0]] = `${s[1]}=${s[2]}`;
      } else {
        params[s[0]] = s[1];
      }
    });
    log('支付参数', params);

    wx.showLoading({
      title: '正在支付,请稍候...'
    });
    wx.requestPayment(Object.assign(params, {
      // paySign,
      success: (res) => {
        wx.hideLoading();
        this.emit('showToptip', this.page, { icon: 'cancel', text: '支付成功' });
        // {errMsg: "requestPayment:ok"}
        log(res);

        this.itemNav({
          redirect: true,
          pageId: 107,
          ID: this.options.data
        })
      },
      fail: (res)=> {
        wx.hideLoading();
        this.emit('showToptip', this.page, { icon: 'cancel', text: '支付失败,请重试' });
        log(res);
      }
    }));
  },
  onLoad() {
    const sections = [];

    sections.push(
      {
        ID: 6,
        type: 'list-item',
        checkType: 'radio',
        items: [
          {
            primaryText: '微信',
            url: '/images/wepay.png',
            checked: true
          }
        ].map((item) => Object.assign(item))
      });
    this.coms.list.updateItems(sections);
  }
}]);

Page(getPage(PayMixin, {
  pageId: 80003
}));
