import { fixImagePath, removeHtml } from '../../utils/utils';
import { list, searchbar } from '../../polaris/polaris';

import config from '../../config/config';
import { dateStr } from '../../utils/dateUtils';
import getPage from '../../module/page';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import request from '../../config/request';
import storage from '../../utils/storage';

const SearchMixin = mixin(listpage, [{
  fetchListOnEnter: false,
  data: {
    searchType: {
    },
    searchTypes: []
  },
  components: {
    searchbar: {
      component: searchbar,
      options() {
        return {
          searchInputChanged(value) {
            if (value.length > 0) {
              storage.getItem('searchHistory', (error, data)=>{
                let old = [];
                if (!error) {
                  old = data;
                }
                const oldIndex = old.findIndex(item => item === value);
                if (oldIndex >= 0) {
                  old.splice(oldIndex, 1);
                }
                old.unshift(value);
                old = old.slice(0, 10);
                storage.setItem('searchHistory', old, ()=>{
                  this.emit('reloadHistory', this.page);
                });
              }).catch(error=>{
              });
            }
          }
        }
      }
    },
    history: list,
    list: {
      component: list,
      options() {
        return {
          methods: {
            customModifyItem(item) {
              if (this.getOption('pageId') == 41) {
                item.section = {
                  ID: 0,
                  type: 'grid-card',
                  class: 'padder-half bg-white b-t padder-t'
                };
                item.primaryText = item.__c61;
                item.url = fixImagePath(item.__c65);
                item.price = item.__c64;
              } else if (this.getOption('pageId') == 94) {
                item.section = {
                  ID: 0,
                  type: 'list-image',
                  imageLeft: true,
                  class: 'b-t'
                };
                item.url = item.__c152.map(i => fixImagePath(i));
                item.primaryText = item.__c153;
                item.primaryClass= 'text-l-2 font-bold text-md2';
                item.secondaryText = `电话: ${item.__c148}`;
                item.secondaryClass = 'm-t-sm text-muted-d text-xs text-l-2';
                item.tertiaryText = `地址: ${item.__c304}`;
                item.tertiaryClass = 'm-t-half text-muted-d text-xs';
                item.imageWrap = 'padder-r w-35-b';
                item.imageClass = 'medium-height4';
              }
            }
          }
        };
      }
    }
  },
  methods: {
    handleClearHistory() {
      storage.setItem('searchHistory', [], ()=>{
        this.reloadHistory();
      });
    },
    searchTypeChange(e) {
      const searchTypes = this.getData().searchTypes;
      this.setData({
        searchType: searchTypes[e.detail.value]
      });
      this.updatePageInfo(searchTypes[e.detail.value]);
    }
  },
  reloadHistory() {
    storage.getItem('searchHistory', (error, data)=>{
      if (!error) {
        this.coms.history.updateItems([{
          ID: 0,
          type: 'grid-label',
          class: 'padder-sm',
          items: data.map(item=>({label: item})) }]);
      }
    }).catch(error=>{
    });
  },
  listTap(scope, indexs, item) {
    if (this.getChildEventScope(scope) === 'history') {
      this.coms.searchbar.handleSearchInputChanged({ detail: { value: item.label } });
    }
  },
  onLoad() {
    const searchTypes = Object.keys(config.router).filter(key => config.router[key].search).sort(key => config.router[key].order).map(key => ({ pageId: key, label: config.router[key].title }));
    this.setData({
      searchTypes,
      searchType: searchTypes[0]
    });
    this.updatePageInfo(searchTypes[0]);
    this.reloadHistory();
    this.on('list-tap', this.listTap);
    this.on('reloadHistory', this.reloadHistory);
  }
}]);

Page(getPage(SearchMixin));
