import { createUpdate, fakeDel } from '../../utils/request';

import editpage from '../../module/editpage';
import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import log from '../../utils/log';
import mixin from '../../utils/mixin';

const SettleMixin = mixin(editpage, [{
  components: {
    list: {
      component: list,
      options() {
        return {
          methods: {
            customFixLinkLsc(column, item, lsc) {
              if (column.ID === 182 && this.location) {
                lsc.push({patternId:159,pTypeId:24,val1:`${this.location.min},${this.location.max}`,operation:6});
              }
            }
          }
        }
      }
    }
  },
  reduxState: ['params'],
  theParams: {},
  updateRedux({ setting, params }) {
    if (this.theParams !== params && params.type === 'cart' && this.detailData.data) {
      this.theParams = params;

      const items = params.data.map(item => ({
        key: 108,
        section: {
          ID: 1,
          type: 'list-goods',
          header: {
            type: 'header2',
            title: '门店'
          },
          class: 'm-t-sm',
          footer: {
            columns: [
              {
                ID: 182,
                eid: '__c182',
                editType: 'link',
                primaryText: '预约门店',
                joinPage: {
                  ID: 94
                },
                join: {
                  joinCategoryId: 13,
                  joinPatternId: 142,
                  viewPatternId: 153
                },
                alpha: false
              },
              {
                ID: 1781,
                eid: '__c1781',
                editType: 'date',
                primaryText: '预约时间'
              },
              {
                ID: 178,
                eid: '__c178',
                editType: 'textarea',
                primaryText: '买家留言',
                property: {
                  placeholder: '（非必填）给商家留言'
                }
              }
            ],
            type: 'footer3',
            primaryText: '共件商品',
            secondaryText: '小计:',
            tertiaryText: '',
            class: 'bg-white'
          }
        },
        primaryText: item.primaryText,
        price: item.price,
        url: item.url,
        number: item.number,
        __c193: item.__c193,
        secondaryText: item.secondaryText,
        __c318: item.__c318,
        __c319: item.__c319,
        __c187: item.__c187,
        __c188: item.__c188,
        __c189: item.__c189
      }));
      const oldData = [{}];
      let totalAmt = 0;
      let totalCnt = 0;
      this.coms.list.appendData(items, oldData, (newData, item, gindex, iindex)=>{
        newData[`items[${gindex}].amt`] || (newData[`items[${gindex}].amt`] = 0);
        newData[`items[${gindex}].qty`] || (newData[`items[${gindex}].qty`] = 0);

        newData[`items[${gindex}].qty`] += item.number;
        newData[`items[${gindex}].amt`] += item.price * item.number;

        const amt = newData[`items[${gindex}].amt`];
        const qty = newData[`items[${gindex}].qty`];
        newData[`items[${gindex}].footer.primaryText`] = `共${qty}件商品`;
        newData[`items[${gindex}].footer.tertiaryText`] = `¥${amt}`;

        totalCnt += item.number;
        totalAmt += item.price * item.number;
      });

      this.setColumn('__c173', totalAmt);
      this.setColumn('__c181', totalAmt); // 折后金额
      // __c174 运费
      this.coms.footer.setData({
        submit: {
          id: 'submit',
          label: '提交订单'
        },
        info: {
          amt: totalAmt
        }
      });

      this.coms.list.appendData([{
        section: {
          ID: 2,
          unsubmit: true,
          class: 'm-t-sm',
          header: {
            columns: [
              {
                ID: 1782,
                eid: '__c1782',
                type: 'edit-check',
                primaryText: '匿名'
              },
            ]
          }
        },
      }], oldData);
    }
    if (setting && this.detailData.data) {
      setting.defaultAddress && this.updateAddress(setting.defaultAddress);
    }
  },
  updateAddress(value) {
    this.setColumn('__c163', value.__c210); // 省份
    this.setColumn('__c164', value.__c211); // 城市
    this.setColumn('__c165', value.__c212); // 具体地址
    this.setColumn('__c166', value.__c214); // 邮编
    this.setColumn('__c167', value.__c216); // 邮件
    this.setColumn('__c168', value.__c209); // 电话
    this.setColumn('__c169', value.__c208); // 姓名

    this.coms.list.setData({
      primaryText: `收货人：${value.__c208}`,
      secondaryText: value.__c209,
      tertiaryText: `收货地址：${value.__c212}`,
    }, 'items[0].items[0]');
  },
  customSetColumn(columns, column, value) {
    if (column === 'chooseAddress') {
      value = value[0];
      this.redux.configSetting({ defaultAddress: value });
    }
  },
  listTap(scope, indexs, item) {
    if (this.getChildEventScope(scope) === 'list') {
      if (indexs[0] === 0) {
        this.emit('showLinkPanel', this.page, { column: 'chooseAddress' }, 132, null, null, null, 'radio', false);
      }
    }
  },
  onLoad() {
    this.on('list-tap', this.listTap);
    const newData = [];
    newData.push({
      ID: 0,
      type: 'list-item',
      unsubmit: true,
      items: [
        {
          icon: 'icon-location-pin',
          primaryText: '收货人：',
          tertiaryText: '收货地址：'
        }
      ]
    });
    this.coms.list.updateItems(newData);
    wx.getLocation({
      type: 'gcj02', //返回可以用于wx.openLocation的经纬度//
      success: (res) => {
        this.coms.list.location = { primaryText: '我的位置', min: res.longitude, max: res.latitude };
      },
      fail(error) {
        log(error);
      }
    });
  },
  afterUpdate(ret) {
    log('提交返回结果', ret);
    this.itemNav({
      pageId: 80003,
      redirect: true,
      params: {
        data: ret[0].data,
        pay: ret[0].message
      }
    });
    // wx.navigateBack();
  }
}]);

Page(getPage(SettleMixin, {
  pageId: 100
}));
