import { fixImagePath, formatDate, removeHtml } from '../../utils/utils';

import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import mixin from '../../utils/mixin';
import regeneratorRuntime from '../../lib/regenerator-runtime/runtime';
import request from '../../config/request';
import viewpage from '../../module/viewpage';

const ViewDataMixin = mixin(viewpage, [
    {
        components: {
            list
        },
        updateButtons() {
            return [
                {
                    id: 'like',
                    label: '膜拜',
                    icon: 'fa fa-thumbs-o-up'
                },
                {
                    id: 'dislike',
                    label: '无视',
                    icon: 'fa fa-thumbs-o-down'
                }
            ];
        },
        afterDetailFetched() {
            const item = this.detailData.data;
            item.__c86 = removeHtml(item.__c86);

            const section = [];

            section.push({
                ID: 0,
                type: 'swiper',
                items: item.__c82.map((i) => ({ url: fixImagePath(i.FilePath) }))
            });

            section.push({
                ID: 1,
                type: 'list-dealer-header',
                class: 'padder-t-xs bg-white',
                itemClass: 'padder-b-md b-b',
                items: [
                    {
                        primaryText: item.__c81.XingMing,
                        secondaryText: '210条',
                        tertiaryText: '婚礼策划',
                        quartusText: '关注 690'
                    }
                ]
            });

            const detail = [
                {
                    content: item.__c86
                }
            ];
            detail.push(...item.__c82.map((i) => ({ url: fixImagePath(i.FilePath) })));
            section.push({
                ID: 3,
                type: 'image-full',
                header: {
                    type: 'header2',
                    title: '主题内容',
                    class: 'b-b bg-white',
                    decorate: true
                },
                class: 'm-t-sm padder-b bg-white',
                itemClass: 'padder padder-t',
                items: detail
            });

            this.coms.list.updateItems(section);
        }
    }
]);

Page(getPage(ViewDataMixin));
