import { fixImagePath, formatDate, removeHtml } from '../../utils/utils';

import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import request from '../../config/request';

const ShowMixin = mixin(listpage, [{
  components: {
    list: {
      component: list,
      options() {
        return {
          customModifyItem(item) {
            item.section = {
              ID: 0,
              class: 'b-t',
              tipClass: 'text-sm m-r-n'
            };
            Object.assign(item, {
              parts: [
                {
                  type: 'image-grid',
                  avatar: 'https://file3.bizsaas.com/files/2028/2017721/c263204f-d5de-45b6-a39c-cee4845b75f9.JPG',
                  name: item.__c81.XingMing,
                  des:  formatDate(item.__c85, 'yyyy-MM-dd hh:mm'),
                  url: item.__c82.map(i => fixImagePath(i.FilePath)),
                  primaryText: removeHtml(item.__c86)
                },
                {
                  type: 'tips-bar',
                  class: 'b-t m-b-sm',
                  tips: [
                    {
                      icon: 'icon-eye',
                      label: 22
                    },
                    {
                      icon: 'icon-speech',
                      label: 22
                    },
                    {
                      icon: 'icon-star',
                      label: 22
                    }
                  ]
                }
              ]
            });
          }
        }
      }
    }
  }
}]);

Page(getPage(ShowMixin, {
  pageId: 48
}));
