import { fixImagePath, removeHtml } from '../../utils/utils';
import { list, tab } from '../../polaris/polaris';

import { dateStr } from '../../utils/dateUtils';
import fetchListMixin from '../../module/fetchListMixin';
// import filterMixin from '../../module/filterMixin';
import getPage from '../../module/page';
import mixin from '../../utils/mixin';
import request from '../../config/request';
import viewpage from '../../module/viewpage';

const SquareMixin = mixin(viewpage, [fetchListMixin, {
  components: {
    list: {
      component: list,
      options() {
        return {
          customModifyItem(item) {
            item.section = {
              ID: 0,
              type: 'list-image'
            };
            if (this.getOption('pageId') === 49) {
              Object.assign(item, {
                primaryText: removeHtml(item.__c86),
                url: item.__c82.map(i =>  i.FilePath),
                secondaryText: `${item.__c81 && item.__c81.XingMing} ${dateStr(item.__c85)}`,
                secondaryClass: 'm-t text-muted text-xs text-l-2',
                like: item.__c83,
                dislike: item.__c84,
                imageWrap: 'col-xs-4 no-padder',
                imageClass: 'medium-height padder-l',
                // primaryClass: 'font-bold'
              });
            }
          },
          useFetch: false
        };
      }
    },
    tab
  },
  fetchDetail(type) {
    if (this.getOption('useFetch') === false) {
      return;
    }

    request.fetchSubject(this, (data)=>{
      this.subjects = data.data;
      this.filterSubject(type || 606);
    });
  },
  onLoad() {
    const types = [
      {
        title: '推荐',
        key: 'recommend',
        type: 606,
        pageId: 49,
        lsc: { patternId: 87, pTypeId: 2, operation: 1, val1: 606 }
      },
      {
        title: '活动',
        key: 'activity',
        type: 607,
        pageId: 49,
        lsc: { patternId: 87, pTypeId: 2, operation: 1, val1: 607 }
      },
      {
        title: '创意',
        key: 'inovation',
        type: 608,
        pageId: 49,
        lsc: { patternId: 87, pTypeId: 2, operation: 1, val1: 608 }
      },
      {
        title: '求助',
        key: 'help',
        type: 609,
        pageId: 49,
        lsc: { patternId: 87, pTypeId: 2, operation: 1, val1: 609 }
      },
      {
        title: '广告',
        key: 'advertisement',
        type: 610,
        pageId: 49,
        lsc: { patternId: 87, pTypeId: 2, operation: 1, val1: 610 }
      },
      {
        title: '其他',
        key: 'other',
        type: 611,
        pageId: 49,
        lsc: { patternId: 87, pTypeId: 2, operation: 1, val1: 611 }
      },
    ];
    this.coms.tab.setData({
      list: types,
      selectedId: 0,
      scroll: false
    });
    this.on('tabChanged', this.tabChanged);
  },
  filterSubject(type) {
    const subjects = this.subjects[1].filter(i => i.__c87.ID === type);

    const section = [];

    if (subjects.length > 0)
    {
      section.push({
        ID: 0,
        type: 'swiper',
        sizeClass: 'height-large-wide2',
        items: this.subjects[0].map(i => ({ url: fixImagePath(i.__c127.FilePath)}))
      });

      section.push({
        ID: 1,
        type: 'grid-card2',
        class: 'padder-b bg-white',
        bodyClass: 'padder-half padder-t',
        header: {
          type: 'header2',
          decorate: true,
          title: '热门秀',
          subTitle: '更多',
          subClass: 'text-muted-d text-xs2',
          subIcon2: 'fa fa-angle-right',
          class: 'b-b bg-white',
          subButton: {
            pageId: 49
          }
        },
        items: subjects.map(i => ({
          url:  i.__c82[0].FilePath ,
          primaryText: removeHtml(i.__c86),
          avatar: 'https://file3.bizsaas.com/files/2028/2017721/c263204f-d5de-45b6-a39c-cee4845b75f9.JPG', //i.__c81
          user: i.__c81.XingMing,
          pageId: 54,
          ID: i.ID
        }))
      });
    }

    this.coms.list.updateItems(section);
  },
  tabChanged(scope, item, selected, toggle) {
    if (this.getChildEventScope(scope) === 'tab') {
      if (item.type === 606) {
        this.useFetch = true;
        this.coms.list.options.pageId = 0;
        this.coms.list.useFetch = false;
        this.fetchDetail(item.type);
      } else {
        this.useFetch = false;
        this.coms.list.useFetch = true;
        this.updatePageInfo(item);
        this.coms.list.refresh();
      }
    }
  }
}]);

Page(getPage(SquareMixin));
