import { formatDate, removeHtml } from '../../utils/utils';

import getPage from '../../module/page';
import { filtab, list } from '../../polaris/polaris';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import request from '../../config/request';
import fetchListMixin from '../../module/fetchListMixin';

const SubscribeMixin = mixin(listpage, [
  fetchListMixin,{
    data: {
       topUrl:'https://file8.mvcx.net/files/2028/201794/c5bedbe7-303e-47a3-8199-1705e4e807ac.jpg'
    },

    reduxState: [  'filter' ],
    currentColumns:[],
    updateRedux({ filter }) {
        const pageId = this.getOption('pageId');
        const theFilter = filter[pageId];


        if (theFilter && theFilter.display) {

           const currentColumns = theFilter.pageConfig.columns.columns;
           this.currentColumns = currentColumns;





        }
    },
  components: {
    filtab: {
                  component: filtab,
                  options() {
                      return {
                          refreshColumns: true
                      };
                  }
    },
    list: {
      component: list,
      options() {

        const that = this;


        return {
          customModifyItem(item) {

             const currentColumns = that.currentColumns;

             let key = {};
             const includePTypeIds =[2,3,4,5,6,7,12,13];
             const keys = currentColumns.filter(column => includePTypeIds.indexOf(column.pTypeId)>=0   );
             for(let ii = 0 ; ii < keys.length && ii < 10; ii ++) {
                  let v = item[keys[ii].eid];
                 switch (keys[ii].pTypeId) {
                   case 6:
                      v = formatDate(v, 'yyyy-MM-dd');
                     break;
                   case 7:
                      v = v?removeHtml(v):'';
                      v = v.length>30?v.substr(0,30):v;
                      break;
                   case 12:
                      v = v?v.XingMing:'';
                       break;
                   case 2:
                   case 13:
                       v = v?v.statusName:'';
                      break;
                   default:

                 }
               key[ii] = ii < 2 ? v : keys[ii].primaryText + " : " + v ;
             }

             const attachmentColumn = currentColumns.find(x => x.pTypeId==11);

             item.section = {
               ID: 0,
               type:'list-item-n',
               itemClass:'',
               class: ''
             };

             if (attachmentColumn){
               Object.assign(item, {
                  url: [item['__c'+attachmentColumn.ID] && item['__c'+attachmentColumn.ID].FilePath?item['__c'+attachmentColumn.ID].FilePath:'/images/loading.png'],
               });
             }

             Object.assign(item, {
         //      url: [item.__c81.FilePath],
                   decorate: true,
                   primaryText:  key[0] ,
                   primaryClass:'text-lg  flex text-l-1',
                   secondaryText: key[1],
                   secondaryClass: 'text-sm m-t-sm  text-l-1 padder-l',
                   primaryText1: key[2],
                   primaryClass1: 'padder-l-sm w-50-b text-sm m-t-sm  text-l-1',
                   secondaryText1: key[3],
                   secondaryClass1: 'w-50-b text-sm m-t-sm  text-l-1 padder-l',
                   primaryText2: key[4],
                   primaryClass2: 'padder-l-sm w-50-b text-sm m-t-sm  text-l-1',
                   secondaryText2: key[5],
                   secondaryClass2: 'w-50-b text-sm m-t-sm  text-l-1 padder-l',
                   primaryText3: key[6],
                   primaryClass3: 'padder-l-sm w-50-b text-sm m-t-sm  text-l-1',
                   secondaryText3: key[7],
                   secondaryClass3: 'w-50-b text-sm m-t-sm  text-l-1 padder-l',
                   primaryText4: key[8],
                   primaryClass4: 'padder-l-sm w-50-b text-sm m-t-sm  text-l-1',
                   secondaryText4: key[9],
                   secondaryClass4: 'w-50-b text-sm m-t-sm  text-l-1 padder-l',
                   pageId:48,
             });

          }
        };
      }
    }
  },
  onLoad() {

    const sections =[];



    // sections.push({
    //   ID: 's6',
    //   type: 'swiper',
    //   decorate: true,
    //   sizeClass: 'height-large-wide-half',
    //   fullMask: true,
    //   textClass: 'bg-black-opacity-lt',
    //   items: [ { url: 'https://file8.mvcx.net/files/2028/201794/c5bedbe7-303e-47a3-8199-1705e4e807ac.jpg'}]
    // });

   //     this.coms.list2.updateItems(sections);

    //  this.coms.list.refresh();









  }
}]);

Page(getPage(SubscribeMixin, {
  pageId: 43
}));
