import commonPage from '../../module/commonPage';
import getPage from '../../module/page';
import log from '../../utils/log';
import config from '../../config/config';
import displayColumnMixin from '../../module/displayColumnMixin';
import fetchDetailMixin from '../../module/fetchDetailMixin';
import filterMixin from '../../module/filterMixin';
import initFilter from '../../module/initFilter'
import mixin from '../../utils/mixin';
import redux from '../../redux/index'
import {updateFilter} from '../../redux/filter'
import { list, comment, tab } from '../../polaris/polaris';
import { formatDate,removeHtml, fixImagePath } from '../../utils/utils';
import request from '../../config/request';

const ViewDataMixin = mixin(commonPage, [fetchDetailMixin, filterMixin, displayColumnMixin, {
  fetchOnEnter: true,
  reduxState: [ 'join', 'page' ],
  canComment: true,
  refreshColumns: true, //设置后this.detailData内容不一样
  components: {
    list: {
      component: list,
    },
    comment: {
      component: comment,
      options() {
        return {
            sendComment: this.sendComment.bind(this)
        };
      }
    }
  },
  methods: {
    handleEditItem() {
      const editPageId = this.getOption('editPageId');
      const view = this.getOption('editView') || (config.router[editPageId] || {}).router || '/pages/editdata/index';
      this.navigateTo(view, {
        pageId: editPageId,
        itemId: this.getOption('itemId')
      });
    },
    moreButtonClicked(button) {
      if (button.id === 'edit') {
        this.handleEditItem();
      } else if (button.id && button.id.indexOf && button.id.indexOf('work') === 0) {
        if (button.data.statusMap.length === 0) {
          this.emit('showToptip', this.page, { text: '没有可用流程' });
        } else {
          this.emit('showFollow', this.page, null, button.data.statusMap.map(i => ({ label: i.primaryText, id: `flow${i.ID}`, columnID: button.data.ID, data: i, workflow: button.data })));
        }
      } else if (button.id && button.id.indexOf && button.id.indexOf('flow') === 0) {
        this.emit('req', this.page, button.workflow.pageType === 3 ? 'updateStatus' : 'updateWorkflow', {
          cateId: button.workflow.categoryId,
          ids: this.getOption('itemId'),
          listPageId: button.workflow.listPageId,
          pageId: button.workflow.pageId,
          patternId: button.workflow.ID,
          statusId: button.data.ID
        }, (ret) => {
          this.emit('refresh_data');
          this.emit('showToptip', this.page, { icon: 'warn', text: ret.message || '已更新'});
        });
      } else if (button.id === 'pinglun') {
        this.emit('showComment', this.page);
      }
    }
  },
  onFirstShow() {
    if (this.fetchOnEnter && (!this.mustLogin || this.isLogged())) {
      this.fetchDetail(this.refreshColumns);
    }
  },
  onLoad() {
    // 和react-native保持一致，下拉不刷新明细页面
    // this.on('onPullDownRefresh', this.handleRefreshDetailEvent);
    this.on('refresh_data', this.handleRefreshDetailEvent);
    this.on('tabChanged', this.tabChanged);
  },
  handleRefreshDetailEvent(scope, idColumn, updateData, deleteData) {
    if (idColumn) {
      const pageId = this.getOption('pageId');
      const router = config.router[pageId] || {};
      const myIdColumn = router.idColumn;
      if (myIdColumn === idColumn) {
        if (updateData) {
          const item = this.getData().item;
          let newItem = Object.assign({}, item, updateData[0]);
          this.customModifyItem && this.customModifyItem(newItem);
          newItem && this.setData(newItem, 'item');
        } else {

          if (this.isShowed) {
            this.fetchDetail(this.refreshColumns);
          } else {
            this.firstShow = true;
          }
        }
      }
    } else {
      if (this.isShowed) {
        this.fetchDetail(this.refreshColumns);
      } else {
        this.firstShow = true;
      }
    }
  },
  tab: { tabType: 1, index: 1 },
  showMainBody1: true,
  propsToStateCompose: [
    {
      props: ['filter'],
      transform(nextProps, preProps, newState) {
        const theFilter = nextProps.filter[this.getOption('pageId')];

       if (theFilter && theFilter.pageConfig && theFilter.pageConfig.page){
               dd.setNavigationBar({
                title: theFilter.pageConfig.page.UIname,
          //      backgroundColor: config.primaryColor,
                success() {
                },
                fail() {
                },
              });
        }






        if (theFilter && theFilter.workflow) {
          this.workflow = theFilter.workflow;
          this.emit('refresh_footer', this.page);
        }
      }
    }
  ],
  workflowButtons() {
    return this.workflow.map(w => ({ label: w.primaryText, id: `work${w.ID}`, data: w }))
  },
  updateButtons() {
    let buttons = [];
    const editPageId = this.getOption('editPageId');
    if (editPageId && !this.getOption('noEditPage')) {
      buttons.push({
        id: 'edit',
        label: '编辑',
        icon: 'icon-pencil'
      });
    }
    if (this.canComment && this.getComment()) {
      buttons.push({
        id: 'pinglun',
        icon: 'icon-pencil',
        iconClass:'text-gray text-xlg'
      });
    }
    this.workflowButton(buttons);
    return buttons;
  },
  workflowButton(buttons) {
    if (this.workflow && this.workflow.length > 0) {
      buttons.push({
        id: 'more',
        icon: 'fa fa-ellipsis-h',
        iconClass:'text-gray text-xlg',
        dropDown:true,
        dropDownMenu: this.workflowButtons()
      });
    }
  },
  tabChanged(scope, item, selected, toggle, index) {
    if (/list\.coms\.\d\.tab/.test(this.getChildEventScope(scope)) && !toggle) {
      this.tab = { tabType: item.tabType, index };
      this.afterDetailFetched();
    }
  },
  allImages(){
    let list1 = [];
    let list2 = [];
    let imgList =[];
    const imgReg = /(jpg|jpeg|png|bmp|gif)$/ig;


    const ks = Object.keys(this.detailData.data);

    ks.forEach((i)=>{
      if (i.indexOf('_Files')>0){
         this.detailData.data[i].forEach((j)=>{

             imgList.push({
               url: fixImagePath(j.FilePath),
               FilePath: fixImagePath(j.FilePath).replace('file11.mvcx.net','file5.mvcx.net/jyrb'),
               Filename: j.Filename,
               columnTxt: '',
               isImage :  (/(jpg|jpeg|png|bmp|gif)$/ig).test(j.FilePath)
             })
         })
      }
    });

    return imgList;
    //console.log(imgList);




    console.log(this.detailData.data);
    console.log( this.columns);

    if (this.columns) {
      const pages = this.columns.filter(p => p.editType == 'attachment' && this.detailData.data[p.eid] && this.detailData.data[p.eid][0].FilePath !== undefined)
      list1 = pages.map((page,index)=>{
          return{
            url: fixImagePath(this.detailData.data[page.eid][0].FilePath),
            Filename: this.detailData.data[page.eid][0].Filename,
            columnTxt: page.primaryText,
            isImage : imgReg.test(this.detailData.data[page.eid][0].FilePath)
          }
      })
    }


    let column = this.columns.filter(c=>c.editType == "attachments")

    if (column.length>0) {
      column.forEach((c, i) => {
        this.detailData.data['__c'+c.ID].forEach((att, j) => {
           console.log(att);
           list1.push({
                  url: fixImagePath(att.FilePath),
                  FilePath: fixImagePath(att.FilePath).replace('file11.mvcx.net','file5.mvcx.net/jyrb'),
                  Filename: att.Filename,
                  columnTxt: '其他内容',
                  isImage : (/(\.jpg|\.jpeg|\.png|\.bmp|\.gif)$/ig).test(att.FilePath)
            })
        });
      });


      // list2 = this.detailData.data['__c'+column[0].ID].map(i=>Object.assign({
      //       url: fixImagePath(i.FilePath),
      //       fileName: i.Filename,
      //       columnTxt: '其他内容',
      //       fp :i.FilePath,
      //       isImage : (/(\.jpg|\.jpeg|\.png|\.bmp|\.gif)$/ig).test(i.FilePath)
      // },i))


    }
    let items = list1.concat(list2)
    if (items.length>0) {
      return items
    }else{
      return []
    }
  },
  mainBody1(){



    return {
      ID: 1,
      class: '',
      type: 'swiper',
      decorate:false,
      fullMask:false,
      items: this.allImages()
    }
  },
  mainBody2(){
    const item = this.detailData.data;
    // let key = {}
    // const keys = this.columns.filter(column => column.editType !== 'textarea' && item[column.eid] && (item[column.eid].statusName || typeof item[column.eid] === 'string'));
    // for(let ii = 0 ; ii < keys.length && ii < 10; ii ++) {
    //   key[ii] = ii < 2 ? (removeHtml(item[keys[ii].eid+'___Display']) || '未确认') : keys[ii].primaryText + " : " + (removeHtml(item[keys[ii].eid+'___Display']) || '未填');
    // }


    this.topPatIds = [];

    console.log(this);


    let key = {};
    const includePTypeIds =[2,3,4,5,6,12,13];
    const keys = this.filter.display.filter(column => includePTypeIds.indexOf(column.pTypeId)>=0   );

    for(let ii = 0 ; ii < keys.length && ii < 10; ii ++) {
         let v = item[keys[ii].eid];
         let displayV =  item[keys[ii].eid+'___Display'];
         this.topPatIds.push(keys[ii].ID);
        switch (keys[ii].pTypeId) {
          case 6:
             v = formatDate(v, 'yyyy-MM-dd');
            break;
          case 7:
             v = v?removeHtml(v):'';
             v = v.length>30?v.substr(0,30):v;
             break;
          case 12:
              v = displayV;
              break;
          case 2:
          case 13:
               v = displayV;
             break;
          default:

        }
      key[ii] = ii < 2 ? v : keys[ii].primaryText + " : " + v ;
    }
    for(let i=0;i<10;i++){
      if (key[i] && key[i].indexOf('undefined')>=0) key[i] = key[i].replace(/undefined/ig,'');
    }

    console.log(key);

    // console.log('mainBody2', this.detailData.data , this.columns);
    return {
      ID: 2,
      type:'list-item-n',
      itemClass:'padder-l-0 bg-main',
      items:[
        {
          decorate: true,
          primaryText: key[0] ,
          primaryClass:'text-lg text-white flex text-l-1',
          secondaryText: key[1],
          secondaryClass: 'text-sm m-t-sm text-white text-l-1 padder-l',
          primaryText1: key[2],
          primaryClass1: 'padder-l-sm w-50-b text-sm m-t-sm text-white text-l-1',
          secondaryText1: key[3],
          secondaryClass1: 'w-50-b text-sm m-t-sm text-white text-l-1 padder-l',
          primaryText2: key[4],
          primaryClass2: 'padder-l-sm w-50-b text-sm m-t-sm text-white text-l-1',
          secondaryText2: key[5],
          secondaryClass2: 'w-50-b text-sm m-t-sm text-white text-l-1 padder-l',
          primaryText3: key[6],
          primaryClass3: 'padder-l-sm w-50-b text-sm m-t-sm text-white text-l-1',
          secondaryText3: key[7],
          secondaryClass3: 'w-50-b text-sm m-t-sm text-white text-l-1 padder-l',
          primaryText4: key[8],
          primaryClass4: 'padder-l-sm w-50-b text-sm m-t-sm text-white text-l-1',
          secondaryText4: key[9],
          secondaryClass4: 'w-50-b text-sm m-t-sm text-white text-l-1 padder-l'
        }
      ]
    }
  },
  mainBody3(){

    console.log( this.allImages().filter(x=>x.isImage));
    console.log( this.allImages().filter(x=>!x.isImage));




    let column = this.columns.filter(c=>c.editType  == "textarea")
    if (column.length === 0 && this.allImages().length === 0) {
      return { items: [] };
    }else{
      return {
        ID: 3,
        type: 'view-text-pulldown',
        class: 'bg-white m-t-sm m-b-sm',
        bodyClass:'w-full',
        contentClass:'',
        header:{
          type: 'header2',
          itemClass:'w-full justify-center',
          // icon2:'fa fa-arrow-circle-o-right text-base',
          title: `${column.length>0?column[0].primaryText:'备注'}`,
          titleClass : 'text-md',
          class: 'bg-white w-full padder-t padder',
        },
        items: [{
          content: column.length > 0 && this.detailData.data['__c'+column[0].ID]?removeHtml(this.detailData.data['__c'+column[0].ID]):'未填写备注',
          contentClass:'text-base',
          images:  this.allImages().filter(x=>x.isImage),
          files :  this.allImages().filter(x=>!x.isImage),
          showImages: 1
        }]
      }
    }
  },
  mainBody4() {



    return false;

    if (this.detailData.data.related && this.detailData.data.related.length > 0) {
      const top_imgs_11 = this.detailData.data.related.map(r => {
        const subPage = this.filter && this.filter.pageConfig && this.filter.pageConfig.subPages.find(s => s.ID === r.pageId);
        const title = subPage && subPage.UIname || '其他信息';
        return {
          noNav: r.list.length === 0,
          primaryText: r.list.length || '0',
          secondaryText: title,
          itemType: 'scroll-h',
          sizeClass: '',
          primaryClass: 'text-sm text-center',
          secondaryClass:'text-sm m-t-xs text-center',
          router: '/pages/viewsub/index',
          params: {
            title,
            pageId: r.pageId,
            items: [{ items: r.list }]
          }
        };
      });

      return {
        ID: 4,
        type: 'scroll-h',
        columnCount: top_imgs_11.length < 4 ? top_imgs_11.length : 4,
        imageUp: true,
        itemClass: 'bg-white padder-v-sm',
        fullMask: true,
        items: top_imgs_11,
        footer: {
          class: 'b-b'
        }
      };
    }
  },
  getComment(){
    const join = this.redux.join && this.redux.join.data.filter(j=>j.joinCategoryId == this.getOption('categoryId') && j.categoryId == config.comment.categoryId);
    if (join && join.length > 0) {
      return join[0].baseId;
    } else {
      return 0;
    }
  },
  getTabHeader() {
    return [
      {
        title: '跟进记录',
        key: 'genjinjilu',
        tabType: 0
      }, {
        title: '详细信息',
        key: 'info',
        tabType: 1
      },
      {
        title: '日志',
        key: 'rizhi',
        tabType: 2
      }
    ];
  },
  tabTopInfo() {
    const emptySection = { items: [] };

    console.log('tabTopInfo');
    console.log(this.showMainBody1);

    const top = [
      this.mainBody2() || emptySection,
      this.mainBody4() || emptySection,
      this.mainBody3() || emptySection
    ];

    for (let ii = top.length - 1; ii >= 0; ii --) {
      if (top[ii] !== emptySection) {
        top[ii].footer = {
          class: 'm-b-sm'
        };
        break;
      }
    }
    console.log(top);

    return top;
  },
  tabInfo0() {
    console.log('tabInfo0');
    const section = this.tabTopInfo();
    if (this.getComment() !== 0) {
      this.emit('req', this.page, 'search2o', {
        cid: 38,
        id: 341,
        lsc: [{ patternId:this.getComment(), pTypeId:23, operation:1, val1:this.detailData.data.server_identity}],
        iindex: 1,
        isize: 100
      }, (res) => {
        let list = res.data.length>0 ? res.data.map(i=>({
      //      url: '../images/header1.png' ,
            imageClass:'img-30-30 rounded2',
            primaryText:i[config.comment.user].XingMing,
            primaryClass:'text-md flex',
            secondaryText:formatDate(i[config.comment.date],'yy-MM-dd hh:mm'),
            secondaryClass:'text-gray',
            tertiaryText:removeHtml(i[config.comment.comment]),
            tertiaryClass:'text-base m-t-sm',
            tertiaryLine: 5,
          })): [
          {
            primaryText:'暂无跟进记录',
            secondaryText:'',
            tertiaryText:'',
          }
        ];
        section.push({
          ID: 1,
          type: 'list-item',
          key: 'tab',
          header: {
            type: 'tablist',
            selectedId: this.tab.index,
            itemClass: 'bg-white',
            class: 'b-b',
            lineClass: 'line-50 b-b-2x b-blue',
            list: this.getTabHeader()
          },
          items: list,
        });
        this.coms.list.updateItems(section);
      });
    }else{
      const items = [{
          primaryText:'暂无跟进记录',
          secondaryText:'',
          tertiaryText:'',
        }];
      section.push({
        ID: 1,
        type: 'list-item',
        key: 'tab',
        header: {
          type: 'tablist',
          selectedId: this.tab.index,
          itemClass: 'bg-white',
          class: 'b-b',
          lineClass: 'line-50 b-b-2x b-blue',
          list: this.getTabHeader()
        },
        items,
      });
      this.coms.list.updateItems(section);
    }
  },
  tabInfo1() {
    console.log('tabInfo1');
    const section = this.tabTopInfo();
    const includePTypeIds =[2,3,4,5,6,7,13];

    const mainPatIds = this.filter.display.map((x)=> x.ID);

    let subColumns = [];
    if (this.filter.pageConfig && this.filter.pageConfig.columns && this.filter.pageConfig.columns.columns )
    {
        this.filter.pageConfig.columns.columns.forEach((x)=>{
           if (mainPatIds.indexOf(x.ID)<0){
              subColumns.push(x);
           }
        });
    }

    subColumns = subColumns.sort(function(a,b){ return a.eorder - b.eorder });

    console.log(subColumns);
    let items =[];



    if (this.detailData.data.related && this.detailData.data.related.length > 0) {

            items =    this.detailData.data.related[0].list.map((item,i)=>{
            let key = {};
            let v7 ='';

            const keys = subColumns.filter(column => includePTypeIds.indexOf(column.pTypeId)>=0   );
            for(let ii = 0 ; ii < keys.length && ii < 10; ii ++) {
                 let v = item[keys[ii].eid];

                switch (keys[ii].pTypeId) {
                  case 6:
                     v = formatDate(v, 'yyyy-MM-dd');
                    break;
                  case 7:
                     v7 = v?removeHtml(v):'';
                     break;
                  case 12:
                      v = v.XingMing;
                      break;
                  case 2:
                  case 13:
                       v = v?v.statusName:'';
                     break;
                  default:

                }
             if (keys[ii].pTypeId!=7)
              key[ii] = ii < 2 ? v : keys[ii].primaryText + " : " + v ;
            }

            for(let i=0;i<10 && i<keys.length;i++){

             if (key[i] && key[i].toString().indexOf('undefined')>=0) key[i] = key[i].toString().replace(/undefined/ig,'');
             if (key[i] && key[i].toString().indexOf('null')>=0) key[i] = key[i].toString().replace(/null/ig,'');
            }
            return  {
              decorate: true,
              primaryText: key[0] ,
              primaryClass:'text-lg  flex text-l-1',
              secondaryText: key[1],
              secondaryClass: 'text-sm m-t-sm  text-l-1 padder-l',
              primaryText1: key[2],
              primaryClass1: 'padder-l-sm w-50-b text-sm m-t-sm  text-l-1',
              secondaryText1: key[3],
              secondaryClass1: 'w-50-b text-sm m-t-sm  text-l-1 padder-l',
              primaryText2: key[4],
              primaryClass2: 'padder-l-sm w-50-b text-sm m-t-sm  text-l-1',
              secondaryText2: key[5],
              secondaryClass2: 'w-50-b text-sm m-t-sm  text-l-1 padder-l',
              primaryText3: key[6],
              primaryClass3: 'padder-l-sm w-50-b text-sm m-t-sm  text-l-1',
              secondaryText3: key[7],
              secondaryClass3: 'w-50-b text-sm m-t-sm  text-l-1 padder-l',
              primaryText4:  v7?v7:key[8],
              primaryClass4: v7?'flex text-l-3 m-t-sm padder-l-sm':'padder-l-sm w-50-b text-sm m-t-sm  text-l-1',
              secondaryText4: v7?'':key[9],
              secondaryClass4:  v7?'':'w-50-b text-sm m-t-sm  text-l-1 padder-l'
            }



          });

          console.log(items);

    }



    section.push ({
      ID: 1,
      key: 'tab',
      type:'list-item-n',
      itemClass:'padder-l-0 ',
      header: {
        type: 'tablist',
        selectedId: this.tab.index,
        itemClass: 'bg-white',
        class: 'b-b',
        lineClass: 'line-50 b-b-2x b-blue',
        list: this.getTabHeader()
      },
      items: items ,
      pageId: '',
      fullMask: true,
      refreshColumns:true,
    });

    console.log(this.topPatIds);

    const restColumns =
   this.filter.display.filter(column => includePTypeIds.indexOf(column.pTypeId)>=0 && column.pTypeId!=7
    && this.topPatIds.indexOf(column.ID)<0  );

    section.push ({
      ID: 5,
      key: 'tab',
      class:'m-t-sm',
      // header: {
      //   type: 'tablist',
      //   selectedId: this.tab.index,
      //   itemClass: 'bg-white',
      //   class: 'b-b',
      //   lineClass: 'line-50 b-b-2x b-blue',
      //   list: this.getTabHeader()
      // },
      items:  restColumns.map((column, i) => Object.assign({
        type: 'view-text',
        column: column,
        class: i === 0 ? 'm-t-none' : ''
      }, this.detailData.data)) ,
      pageId: '',
      fullMask: true,
      refreshColumns:true,
    });










    this.coms.list.updateItems(section);
  },
  tabInfo2() {
    console.log('tabInfo2');
    const section = this.tabTopInfo();
    let reg = /;/;
    const tab2 = () => {
       console.log(this.log);
      let items = this.log.map((i,idx)=>({
        ID:idx,
        url: '../../images/application.png' ,
        imageClass:'img-30-30 rounded2',
        primaryText: i.LoggerName +' , ' + formatDate(i.LogTime,'MM-dd hh:mm') + ' ' + i.LogTxt,
        primaryTextClass:'text-md',
        primaryText2: formatDate(i.LogTime,'MM-dd hh:mm'),
        primaryClass2:'m-t-sm text-xs',
        primaryLine1:15,
        secondaryClass2:'flex padder-l-xs',
        secondaryText2: '',
        noIcon:true,
        class2:'items-start',
      }));
      section.push({
        ID: 1,
        type: 'list-item',
        key: 'tab',
        header: {
          type: 'tablist',
          selectedId: this.tab.index,
          itemClass: 'bg-white',
          class: 'b-b',
          lineClass: 'line-50 b-b-2x b-blue',
          list: this.getTabHeader()
        },
        items
      });
      this.coms.list.updateItems(section);
    };

    this.emit('req', this.page, 'dataLog', {
      categoryId: this.getOption('categoryId'),
      itemId: this.getOption('itemId')
    }, (ret) => {
      this.log = ret.sort(function(a,b){
        if (a.LogTime>b.LogTime) {    return -1;      }
        if (a.LogTime < b.LogTime) {     return 1;  }
        return 0;
      });
      tab2();
    });
  },
  afterDetailFetched() {
     console.log(this.tab.tabType);
    this[`tabInfo${this.tab.tabType}`]();
  },
  sendComment(comment) {
    let obj_comment = { [config.comment.comment]: comment }
    obj_comment['__c'+this.getComment()] = this.getData().item.server_identity
    request.comment(this, obj_comment);
  },
}]);



Page(getPage(ViewDataMixin));
