import Button from '../button/button';
import mixin from '../../utils/mixin';
import switchVisibleByTouchDirectionMixin from '../../module/switchVisibleByTouchDirectionMixin';

export default mixin(Button, [switchVisibleByTouchDirectionMixin,
  {
    data: {
      icon: 'fa fa-angle-left',
      className: 'pos-fix bottom-md left-md',
      visible: false
    },
    defaultShowCss: 'fadeInLeft',
    defaultHideCss: 'fadeOutLeft',
    callback() {
      wx.navigateBack();
    },
    onLoad(options) {
      this.hasMorePage = getCurrentPages().length > 1;
      this.setData({
        visible: this.hasMorePage
      });
      if (!this.hasMorePage) {
        this.useTouchDirection = false;
      }
    }
  }
]);
