import { confirmFilter, updateFilter, updateSingleFilter, updateSort } from '../../redux/filter';

import Tab from '../tab/tab';
import filterMixin from '../../module/filterMixin';
import log from '../../utils/log';
import mixin from '../../utils/mixin';
import config from '../../config/config';

export default mixin(Tab, [
    filterMixin,
    {
        data: {
            visible: false
        },
        filter: {},
        reduxDispatch: { confirmFilter, updateSort },
        updateRedux({ filter }) {
            const theFilter = filter[this.getOption('pageId')];
            const configValue = config.router[this.getOption('pageId')];
            const filtConfig = configValue && configValue.filtab2;


            if (!filtConfig) {
                return;
            }
            if (theFilter && theFilter !== this.filter) {
                this.filter = theFilter;
                const list = [];
                // if (this.filter.filtable) {
                //   for (let ii = 0; ii < this.filter.filtable.length && ii < 2; ii += 1) {
                //     list.push(Object.assign({ type: 'extra', toggle: true, title: this.filter.filtable[ii].primaryText, index: ii }));
                //   }
                // }
                // log(filter)
                // const data = this.getData();

                filtConfig.forEach((c) => {
                    // 过滤
                    if (c.type === 0 && c.ids && c.ids.length > 0) {
                        const filtable =
                            this.filter.filtable &&
                            this.filter.filtable.filter((f) => c.ids.findIndex((id) => id === f.ID) >= 0);
                        if (filtable) {
                            let filted;
                            if (this.filter.filter) {
                                const filtedColumn = filtable.find(
                                    (f) => this.filter.filter[f.ID] && this.filter.filter[f.ID].length
                                );
                                if (filtedColumn) {
                                    filted = this.filter.filter[filtedColumn.ID][0];
                                }
                            }
                            if (filtable.length === 1) {
                                list.push({
                                    type: 'more2',
                                    title: filted ? filted.primaryText : filtable[0].primaryText,
                                    icon: 'fa fa-angle-down',
                                    iconSelected: 'fa fa-angle-up',
                                    titleClass: filted ? 'text-primary' : '',
                                    toggle: true,
                                    filtable
                                });
                            } else if (filtable.length) {
                                list.push({
                                    type: 'more2',
                                    title: filted ? filted.primaryText : c.label || '筛选',
                                    icon: 'fa fa-angle-down',
                                    iconSelected: 'fa fa-angle-up',
                                    titleClass: filted ? 'text-primary' : '',
                                    toggle: true,
                                    filtable
                                });
                            }
                        }
                    } else if (c.type === 1 && c.ids && c.ids.length > 0) {
                        const filtable =
                            this.filter.filtable &&
                            this.filter.filtable.filter((f) => c.ids.findIndex((id) => id === f.ID) >= 0);
                        if (filtable) {
                            let filted;
                            if (this.filter.filter) {
                                const filtedColumn = filtable.find(
                                    (f) => this.filter.filter[f.ID] && this.filter.filter[f.ID].length
                                );
                                if (filtedColumn) {
                                    filted = this.filter.filter[filtedColumn.ID][0];
                                }
                            }
                            if (filtable.length === 1) {
                                list.push({
                                    type: 'more',
                                    title: filted ? filted.primaryText : filtable[0].primaryText,
                                    icon: 'fa fa-angle-down',
                                    iconSelected: 'fa fa-angle-up',
                                    titleClass: filted ? 'text-primary' : '',
                                    toggle: true,
                                    filtable
                                });
                            } else if (filtable.length) {
                                list.push({
                                    type: 'more',
                                    title: filted ? filted.primaryText : c.label || '筛选',
                                    icon: 'fa fa-angle-down',
                                    iconSelected: 'fa fa-angle-up',
                                    titleClass: filted ? 'text-primary' : '',
                                    toggle: true,
                                    filtable
                                });
                            }
                        }
                    } else if (c.type === 2) {
                        let sortable = this.filter.sortable;
                        if (sortable) {
                            if (c.ids && c.ids.length > 0) {
                                sortable = sortable.filter((f) => c.ids.findIndex((id) => id === f.ID) >= 0);
                            }
                            const sort = this.filter.sort && this.filter.sort.length && this.filter.sort[0];
                            if (sortable.length > 0) {
                                list.push({
                                    type: 'sort',
                                    title: sort ? sort.primaryText : '排序',
                                    titleClass: sort ? 'text-primary' : '',
                                    icon: 'fa fa-angle-down',
                                    iconSelected: 'fa fa-angle-up',
                                    toggle: true,
                                    sortable
                                });
                            }
                        }
                    }
                });
                // const sort = this.filter.sort && this.filter.sort.length > 0 ? this.filter.sort[0] : null;

                // let hasSort = this.filter.sortable && this.filter.sortable.filter((item) => !item.tab).length > 0;
                // if (hasSort) {
                //     let label = '排序';

                //     if (sort && !sort.tab) {
                //         label = sort.primaryText;
                //         this.setData({
                //             selectedId: 0
                //         });
                //     }

                //     list.push(
                //         Object.assign({
                //             id: 'sort',
                //             type: 'sort',
                //             title: label,
                //             icon: 'fa fa-angle-down',
                //             iconSelected: 'fa fa-angle-down'
                //         })
                //     );
                // }

                // const sortable = this.filter.sortable && this.filter.sortable.filter((item) => item.tab);
                // if (sortable && sortable.length > 0) {
                //     sortable.forEach((item, index) => {
                //         let icon = 'fa fa-sort';
                //         if (item.tab === 'down') {
                //             icon = 'fa fa-sort-desc';
                //         } else if (item.tab === 'up') {
                //             icon = 'fa fa-sort-asc';
                //         }
                //         list.push(
                //             Object.assign(
                //                 { id: index, type: 'ssort', title: item.primaryText, icon, iconSelected: icon },
                //                 item
                //             )
                //         );

                //         if (sort && sort.ID === item.ID) {
                //             this.setData({
                //                 selectedId: hasSort ? index + 1 : index
                //             });
                //         }
                //     });
                // }

                // const filters =
                //     (this.filter.filtable &&
                //         this.filter.filtable.filter(
                //             (f) => f.force || (f.pTypeId !== 3 && f.pTypeId !== 4 && f.pTypeId !== 5 && f.pTypeId !== 7)
                //         )) ||
                //     [];

                // let tabFilter;
                // const filtable = filters
                //     .map((item, index) => Object.assign({}, item, { index }))
                //     .filter((item) => item.tab);
                // if (filtable && filtable.length > 0) {
                //     filtable.forEach((item, index) => {
                //         list.push(
                //             Object.assign(
                //                 {
                //                     id: `f${index}`,
                //                     type: 'filter',
                //                     title: item.primaryText,
                //                     icon: 'fa fa-angle-down',
                //                     iconSelected: 'fa fa-angle-up',
                //                     toggle: true
                //                 },
                //                 item
                //             )
                //         );
                //     });
                // }
                // tabFilter = filtable;

                // if (list.length < 2) {
                //     const appendCount = 2 - list.length;
                //     const filtable = filters
                //         .map((item, index) => Object.assign({}, item, { index }))
                //         .filter((item) => !item.tab);
                //     for (let ii = 0; ii < appendCount && ii < filtable.length; ii += 1) {
                //         const item = filtable[ii];
                //         list.push(
                //             Object.assign(
                //                 {
                //                     id: `ff${ii}`,
                //                     type: 'filter',
                //                     title: item.primaryText,
                //                     icon: 'fa fa-angle-down',
                //                     iconSelected: 'fa fa-angle-up',
                //                     toggle: true
                //                 },
                //                 item
                //             )
                //         );
                //     }

                //     tabFilter = tabFilter.concat(filtable.slice(0, appendCount));
                // }

                // if (this.filter.filtable && this.filter.filtable.length > 0) {
                //     list.push(
                //         Object.assign({
                //             id: 'more',
                //             type: 'more',
                //             title: '筛选',
                //             icon: 'fa fa-filter',
                //             toggle: true,
                //             tabFilter
                //         })
                //     );
                // }

             

                this.setData({
                    list
                });

                if (list.length < 1) {
                    this.setHidden();
                } else {
                    this.setVisible();
                }
            }
        },
        tabChanged(scope, item, selected, toggle, index) {
            if (this.scope === scope) {
                if (index === -1) {
                    return;
                }
                if (selected && item) {
                    if (item.type === 'ssort') {
                        if (toggle) {
                            if (item.tab === 'updown') {
                                const sort =
                                    this.filter.sort && this.filter.sort.length > 0 ? this.filter.sort[0] : null;
                                this.redux.updateSort({
                                    pageId: this.getOption('pageId'),
                                    items: [Object.assign({ orderBy: sort.orderBy === 1 ? 2 : 1 }, item)]
                                });
                                this.redux.confirmFilter({ pageId: this.getOption('pageId') });
                            }
                        } else {
                            let orderBy = 1;
                            if (item.tab === 'down') {
                                orderBy = 2;
                            }
                            this.redux.updateSort({
                                pageId: this.getOption('pageId'),
                                items: [Object.assign({ orderBy }, item)]
                            });
                            this.redux.confirmFilter({ pageId: this.getOption('pageId') });
                        }
                    } else {
                        this.current = item;
                        this.emit('filtManager', this.page, item);
                    }
                } else {
                    this.emit('hidePanel', this.page);
                }
            }
        },
        hideFileManager() {
            if (this.current && !this.current.deselect) {
                this.setData({
                    selectedId: -1
                });
            }
        },
        onLoad(options) {
            this.on('tabChanged', this.tabChanged);
            this.on('panelHidden', this.hideFileManager);
        }
    }
]);
