import Component from '../../components/component';
import mixin from '../../utils/mixin';

export default mixin(Component, [
  {
    data: {
      visible: false,
      buttons: []
    },
    defaultShowCss(){
      if (this.isUp) {
        return {
          main: 'zoomInUp',
          back: 'fadeIn'
        };
      } else {
        return {
          main: 'zoomInDown',
          back: 'fadeIn'
        };
      }
    },
    defaultHideCss() {
      if (this.isUp) {
        return {
          main: 'zoomOutDown',
          back: 'fadeIn'
        };
      } else {
        return {
          main: 'zoomOutUp',
          back: 'fadeIn'
        };
      }
    },
    methods: {
      handleOutTap(e) {
        this.setHidden();
      },
      handleButtonClicked(e) {
        const button = e.currentTarget.dataset.button;
        this.emit('buttonClick', this.page, button, this.params.item, this.params.gindex, this.params.index);

        this.setHidden();
      }
    },
    handleShow(scope, params, buttons, desScope) {
      this.params = params || {};
      // this.isUp = param.e.changedTouches[0].clientY > this.windowHeight /2;
      this.desScope = desScope;
      this.setData({
        // style: this.isUp ? `bottom: ${this.windowHeight - param.e.changedTouches[0].clientY - 12}px` : `top: ${param.e.changedTouches[0].clientY + 20}px;`,
        buttons
      });
      this.setVisible();
    },
    onLoad() {
      dd.getSystemInfo({
        success: (res) => {
          this.windowHeight = res.windowHeight;
        }
      });
      this.on('showFollow', this.handleShow);
    }
  }
]);
