import Component from '../../components/component';
import config from '../../config/config';
import mixin from '../../utils/mixin';
import switchVisibleByTouchDirectionMixin from '../../module/switchVisibleByTouchDirectionMixin';

export default mixin(Component, [
    switchVisibleByTouchDirectionMixin,
    {
        data: {
            bigButtons: [],
            smallButtons: [],
            buttons: [],
            extendModeButtons: [],
            extendMode: false,
            comment: ''
        },
        defaultShowCss: 'fadeInUp',
        defaultHideCss: 'fadeOutDown',
        methods: {
            handleUpdateComment(e) {
                setTimeout(() => {
                    const data = this.getData();
                    if (data.comment) {
                        this.sendComment && this.sendComment(data.comment);
                        this.setData({
                            comment: ''
                        });
                    }
                }, 20);
            },
            handleComment(e) {
                console.log(e.detail.value);
                this.setData({
                    comment: e.detail.value
                });
            },
            handleButtonClicked(e) {
                const button = e.currentTarget.dataset.button;

                
                if (button && button.disabled) {
                    return;
                }
                if (button.dropDownMenu) {
                    console.log(button);
                     dd.showActionSheet({
                        itemList: button.dropDownMenu.map((i) => i.label),
                        cancelButtonText: '取消', //取消按钮文本
                        items: button.dropDownMenu.map((i) => i.label),
                        success: (res) => {
                            this.handleButtonClicked({
                                currentTarget: {
                                    dataset: {
                                        button: button.dropDownMenu[res.index]
                                    }
                                }
                            });
                        }
                    });
                    return;
                }
                this.emit('buttonClick', this.page, button, this.dataset);
                if (button.extend) {
                    this.switchExtendMode(true, button);
                    if (this.extendModeButtons) {
                        this.setData({
                            extendModeButtons: this.extendModeButtons(button)
                        });
                    }
                } else if (button.autoQuiteExtend) {
                    this.switchExtendMode(false);
                } else {
                    this.switchExtendMode();
                }
            },
            handleBack() {

               console.log(config);

                if (this.getOption('fromShare') && config.router.frontpage) {
                    this.itemNav(config.router.frontpage);
                } else {
                    dd.navigateBack();
                }
            },
            handleExitExtendMode() {
                this.emit('buttonClick', this.page, this.currentButton, this.dataset);
                this.switchExtendMode(false);
            },
            footUp() {
                this.setVisible();
            }
        },
        switchExtendMode(extendMode, button) {
            if (!this.redux || !this.redux.setting) {
                return;
            }
            const buttons = this.updateButtons && this.updateButtons();

            console.log(buttons)

            const data = this.getData();
            if (typeof extendMode === 'undefined' || data.extendMode === extendMode) {
                if (data.extendMode) {
                    const extendModeButtons = this.extendModeButtons && this.extendModeButtons(this.currentButton);
                    this.setData({
                        buttons,
                        extendModeButtons
                    });
                } else {
                    this.setData({
                        buttons
                    });
                }
            } else {
                this.currentButton = button;
                const extendModeButtons = extendMode && this.extendModeButtons && this.extendModeButtons(button);
                this.setData({
                    animateButtons: 'fadeOutDown'
                });
                this.setDelayData({
                    animateButtons: 'fadeInUp',
                    extendMode,
                    buttons,
                    extendModeButtons
                });
            }
        },
        onRefreshFoorter(scope) {
            this.switchExtendMode();
        },
        onLoad() {
            this.setData({
                hasMorePage:
                    getCurrentPages().length > 1 || (this.getOption('fromShare') && config.router.frontpage) || false
            });
            this.on('refresh_footer', this.onRefreshFoorter);
        },
        onReady() {
            this.switchExtendMode(false);
        }
    }
]);
