import config from '../../config/config';
import fetchListMixin from '../../module/fetchListMixin';
import initFilter from '../../module/initFilter';
import list from '../list/list';
import mixin from '../../utils/mixin';
import panelpicker from '../panelpicker/panelpicker';
import searchbar from '../searchbar/searchbar';
import { updateFilter } from '../../redux/filter';
import log, { mark } from '../../utils/log';

export default mixin(panelpicker, [{
  reduxDispatch: { updateFilter },
  reduxState: ['lsc'],
  methods: {
    handleScrollToLower(e) {
      this.coms.list.fetchMore();
    },
    handleAdd(e) {
      this.emit('showQuickAdd', this.page, this.pageId, this.item);
    }
  },
  components: {
    list: {
      component: list,
      options() {
        return {
          data: {
            itemType: 'list-item'
          },
          deselectable: true,
          pageId: -1,
          customModifyItem: (item) => {
            const pageInfo = config.router[this.getOption('pageId')];
            if (pageInfo && pageInfo.columnsMap) {
              if (typeof pageInfo.columnsMap === 'function') {

              } else {
                const keys = Object.keys(pageInfo.columnsMap);
                keys.forEach(key => {
                  const value = item[pageInfo.columnsMap[key]];
                  item[key] = value && value.statusName ? value.statusName : value;
                });
              }
            }
          }
        };
      }
    },
    searchbar: {
      component: searchbar,
      options() {
        return {
          data: {
            hasBack: true
          },
          realBack: this.hide.bind(this)
        }
      }
    }
  },
  updateRedux({ lsc }) {
    const pageId = this.coms.list.getOption('pageId');
    const theLsc = lsc[pageId];
    if (theLsc && theLsc.lsc && theLsc !== this.lsc) {
      log('当前查询条件', pageId, theLsc);
      this.lsc = theLsc;
      if (this.lsc.error) {
        this.emit('showToptip', this.page, { icon: 'cancel', text: '刷新搜索条件失败' });
      } else {
        this.coms.list.updateLsc(this.lsc.lsc);
        this.coms.list.refresh();
      }
    }
  },
  refresh() {
    this.coms.list.refresh();
  },
  onLoad(options) {
    this.on('showLinkPanel', this.showLinkPanel);
    this.on('quickAddReturn', this.refresh);
  },
  showPanelPicker(scope, checkType, items) {
  },
  showLinkPanel(scope, key, pageId, categoryId, displayCol, param, checkType, alpha) {
    this.returnScope = scope;
    const pageInfo = config.router[pageId];
    initFilter(this.redux.updateFilter, pageId);
    this.key = key;
    this.pageId = pageId;
    this.coms.list.pageId = pageId;
    this.coms.list.categoryId = categoryId || pageInfo.categoryId;
    this.coms.list.displayCol = displayCol || pageInfo.displayCol;
    this.coms.searchbar.pageId = pageId;
    this.coms.searchbar.setData({
      searchInput: ''
    });
    this.coms.list.updateLsc([]);
    this.coms.list.setCheckType(checkType);
    this.setData({
      checkType: this.coms.list.checkType,
      categoryId: categoryId || pageInfo.categoryId
    });
    this.coms.list.alpha = alpha;
    param || (param = {});
    const lsc = param.lsc || [];
    this.coms.list.setFixedLsc(lsc);
    this.coms.list.refresh();

    this.item = param.item;
    if (config.router[pageId]) {
      const quickAdd = config.router[pageId].quickAdd;
      if (quickAdd === true || param.item && param.item[quickAdd] && param.item[quickAdd].server_identity ) {
        this.setData({
          quickAdd: true
        });
      } else {
        this.setData({
          quickAdd: false
        });
      }
    } else {
      this.setData({
        quickAdd: false
      });
    }

    this.show();
  }
}]);
