import Component from '../../components/component';
import checkableMixin from '../../module/checkableMixin';
import editColumnMixin from '../../module/editColumnMixin';
import fetchMixin from '../../module/fetchMixin';
import imageScaleMixin from '../../module/imageScaleMixin';
import mixin from '../../utils/mixin';

export default mixin(Component, [
    checkableMixin,
    fetchMixin,
    editColumnMixin,
    imageScaleMixin,
    {
        data: {
            animateItemCss: 'fadeIn'
        },
        reduxState: [ 'cuser','filter' ],
        updateRedux({ cuser , filter }) {


        },
        onLoad() {
            this.on('buttonClick', this.handleButtonEvent);
        },
        handleButtonEvent(scope, button, item, gindex, index) {
            if (button === 'pulldown' || button === 'showAll') {
                this.updateCurrentEditData(gindex, index, null, {
                    pulldown: !this.getCurrentEditData(gindex, index).pulldown,
                    showAll: !this.getCurrentEditData(gindex, index).pulldown
                });
            }
        },
        methods: {
            handleTap(e) {
                const { index, gindex, router, item } = e.currentTarget.dataset;
                if (router) {
                    this.itemNav({
                        router
                    });
                } else {
                    if (typeof index === 'undefined') {
                        this.emit(
                            'buttonClick',
                            this.page,
                            item || this.getCurrentEditData(gindex, index),
                            null,
                            gindex,
                            index
                        );
                        return;
                    }
                    const oitem = this.getCurrentEditData(gindex, index);
                    this.emit('list-tap', this.page, [ gindex, index ], oitem);
                    if (this.checkType !== '') {
                        return;
                    }
                    if (!this.itemNav(item || oitem)) {
                        // 不符合跳转规则，触发按钮事件
                        this.emit('buttonClick', this.page, item || oitem, null, gindex, index);
                    }
                }
            },
            handleMoreTap(e) {
                if (this.moreButtons) {
                    const item = this.getTapItem(e);
                    this.emit('showFollow', this.page, { e, item }, this.moreButtons);
                }
            },
            tagTap(e) {
                const { tag } = e.currentTarget.dataset;
                console.log(tag);
                this.setData({
                    currentTag: tag.id || tag
                });
            },
            showPage(e) {
                const { index, gindex } = e.currentTarget.dataset;
                const data = this.getData();
                const item = data.items[gindex].items[index];
                wx.navigateTo({
                    url: item.routertxt
                });
            },
            preview(e) {
                const data = this.getData();
                const { index, gindex } = e.currentTarget.dataset;
                const column = data.items[gindex].items;
                console.log(column);
                wx.previewImage({
                    current: column[index].url.replace(/\/100/gi, ''),
                    urls: column.map((item) => item.url.replace(/\/100/gi, ''))
                });
            }
        }
    }
]);
