import Component from '../../components/component';
import mixin from '../../utils/mixin';
import authdialog from '../authdialog/authdialog';

export default mixin(Component, [
    {
        components: {
            authdialog
        },
        data: {
            visible: false,
            text: '请稍候...'
        },
        count: 0,
        showLoading(scope, msg) {
            if (this.count <= 0) {
                this.count = 1;
                this.setData({
                    text: msg || '请稍候...'
                });
                // this.setVisible();
                dd.showLoading({
                    title: msg || '请稍候...'
                });
                dd.showNavigationBarLoading();
            } else {
                this.count += 1;
            }
        },
        hideLoading(scope, msg, isModal) {
            this.count -= 1;
            if (this.count === 0 || msg) {
                this.count = 0;
                // this.setHidden();
                dd.hideLoading();
                dd.hideNavigationBarLoading();
                if (msg) {
                    if (isModal) {
                        dd.showModal({
                            title: '提示',
                            content: msg,
                            showCancel: false
                        });
                    } else {
                        this.emit('showToptip', this.page, { icon: 'cancel', text: msg });
                    }
                }
            }
        },
        onLoad(options) {
            this.on('showLoading', this.showLoading);
            this.on('hideLoading', this.hideLoading);
        }
    }
]);
