import Component from '../components/component';
import mixin from '../utils/mixin';

export default mixin(Component, [
    {
        data: {
            visible: false,
            class: ''
        },
        position: 'right',
        anchor: null,
        autoSize: true,
        defaultShowCss() {
            if (this.position === 'right') {
                return {
                    main: 'fadeInRight',
                    back: 'fadeIn'
                };
            } else if (this.position === 'top') {
                return {
                    main: 'fadeInTop',
                    back: 'fadeIn'
                };
            }
        },
        defaultHideCss() {
            if (this.position === 'right') {
                return {
                    main: 'fadeOutRight',
                    back: 'fadeOut'
                };
            } else if (this.position === 'top') {
                return {
                    main: 'fadeOutTop',
                    back: 'fadeOut'
                };
            }
        },
        methods: {
            handleOutTap(e) {
                this.hide();
            },
            handleCancel(e) {
                this.hide();
            }
        },
        show() {
            this.setVisible() && this.emit('panelShown', this.page);
        },
        hide() {
            this.setHidden() && this.emit('panelHidden', this.page);
        },
        onLoad(options) {
            this.on('hidePanel', this.hide);
            wx.getSystemInfo({
                success: (res) => {
                    const rpx2px = res.windowWidth / 750.0;
                    this.setData({
                        topViewHeight: 600 * rpx2px,
                        scrollHeight: res.windowHeight,
                        footHeight: 100 * rpx2px,
                        headHeight: 90 * rpx2px,
                        footHeight2: 88 * rpx2px
                    });
                }
            });
        }
    }
]);
