import Component from '../../components/component';
import list from '../list/list';
import mixin from '../../utils/mixin';
import puresearchbar from '../searchbar/puresearchbar';

export default mixin(Component, [
  {
    components: {
      searchbar: {
        component: puresearchbar,
        options() {
          return {
            realBack: this.handleOutTap.bind(this),
            searchInputChanged: this.filterList.bind(this)
          };
        }
      },
      list: {
        component: list,
        options() {
          return {
            data: {
              itemType: 'list-item'
            },
            deselectable: true,
            pageId: -1
          };
        }
      }
    },
    filterList(value) {
      if (!this.orgListData) {
        this.orgListData = this.coms.list.getData().items;
      }


      if (value) {
        const newData = [];
        this.orgListData.forEach((gitem, gindex) => {
          const newG = Object.assign({}, gitem);
          newG.items = [];

          gitem.items && gitem.items.forEach((item, index) => {
            if (item.primaryText.indexOf(value) >= 0) {
              newG.items.push(item);
            }
          });
          if (newG.items.length > 0) {
            newData.push(newG);
          }
        });
        this.coms.list.setData({
          items: newData
        });
      } else {
        this.coms.list.setData({
          items: this.orgListData
        });
      }
    },
    data: {
      visible: false
    },
    position: 'right',
    defaultShowCss() {
      if (this.position === 'right') {
        return {
          main: 'fadeInRight',
          back: 'fadeIn'
        }
      }
    },
    defaultHideCss() {
      if (this.position === 'right') {
        return {
          main: 'fadeOutRight',
          back: 'fadeOut'
        }
      }
    },
    key: '',
    returnScope: '',
    selected: [],
    methods: {
      handleOutTap(e) {
        this.hide();
        this.emit('panelPickerCancel', this.page, this.returnScope);
      },
      handleConfirm(e) {
        this.hide();
        this.emit('panelPickerReturn', this.page, this.returnScope, this.key, this.selected);
      },
      handleCancel(e) {
        this.hide();
        this.emit('panelPickerCancel', this.page, this.returnScope);
      }
    },
    show() {
      this.setVisible() && this.emit('panelShown', this.page);
    },
    hide() {
      this.setHidden() && this.emit('panelHidden', this.page);
    },
    checkableTap(scope, items) {
      const childScope = this.getChildEventScope(scope);

      if (childScope === 'list') {
        this.selected = items;
        if (this.coms.list.checkType === 'radio') {
          this.handleConfirm();
        }
      }
    },
    listTap(scope, indexs, item) {

    },
    showPanelPicker(scope, key, checkType, alpha, items) {
      this.key = key;
      this.coms.list.setCheckType(checkType);
      this.setData({
        checkType
      });
      this.coms.list.alpha = alpha;
      this.coms.list.updateItems(items);
      this.returnScope = scope;
      this.orgListData = null;
      this.coms.searchbar.setData({
        searchInput: ''
      });
      this.show();
    },
    onLoad(options) {
      this.on('checkable-tap', this.checkableTap);
      this.on('list-tap', this.listTap);
      this.on('showPanelPicker', this.showPanelPicker);
      this.on('hidePanel', this.hide);
      dd.getSystemInfo({
        success:  (res)=> {
          const rpx2px = res.windowWidth / 750.0;
          this.setData({
            scrollHeight: res.windowHeight,
            footHeight: 100 * rpx2px,
            headHeight: 90 * rpx2px,
            footHeight2: 88 * rpx2px
          });
        }
      });
    }
  }
]);
