import Component from '../../components/component';
import mixin from '../../utils/mixin';

export default mixin(Component, [
  {
    data: {
      pullingIcon: 'icon-arrow-down',
      pullingText: '下拉刷新',
      refreshingIcon: 'icon-refresher',
      refreshingText: '正在刷新',
      pullingIcon2: 'icon-arrow-down',
      pullingText2: '上拉获取更多',
      refreshingIcon2: 'icon-refresher',
      refreshingText2: '正在刷新',
      disablePullingRotation: false
    },
    distance: 30,
    activated: false,
    lastTime: 0,
    isRefresh: undefined,
    hasLoadMore: true,
    requestAnimationFrame(callback) {
      let currTime = new Date().getTime();
      let timeToCall = Math.max(0, 16 - (currTime - this.lastTime));
      let timeout = setTimeout(() => {
        callback.bind(this)(currTime + timeToCall);
      }, timeToCall);
      this.lastTime = currTime + timeToCall;
      return timeout;
    },
    cancelAnimationFrame(timeout) {
      clearTimeout(timeout);
    },
    onLoad() {
      this.on('refreshEnd', this.finishPullToRefresh);
    },
    /**
     * 返回下拉刷新的方法
     */
    getRefresherMethods() {
      // 默认样式
      const defaultStyle = 'transition: transform .4s; transform: translate3d(0px, 0px, 0px) scale(1);';

      // 显示
      const activate = () => {
        const className = this.isRefresh ? 'className' : 'className2';
        this.setData({
          style: defaultStyle,
          [className]: 'visible'
        });
      };

      // 隐藏
      const deactivate = () => {
        if (this.activated) this.activated = false;
        const className = this.isRefresh ? 'className' : 'className2';
        this.setData({
          style: defaultStyle,
          [className]: 'hidden'
        });
      };

      // 正在刷新
      const refreshing = () => {
        const className = this.isRefresh ? 'className' : 'className2';
        const data = {
          style: `transition: transform .4s; transform: translate3d(0, ${this.isRefresh ? 50 : -50}px, 0) scale(1);`,
          [className]: 'active refreshing'
        };
        // this.isRefresh && (data.style = 'transition: transform .4s; transform: translate3d(0, 50px, 0) scale(1);');
        this.setData(data);
      };

      // 刷新后隐藏动画
      const tail = () => {
        const className = this.isRefresh ? 'className' : 'className2';
        this.setData({
          [className]: 'active refreshing refreshing-tail'
        });
      };

      // 正在下拉
      const move = (diffY) => {
        const className = this.isRefresh ? 'className' : 'className2';
        diffY = Math.abs(diffY);
        const data = {
          [className]: diffY < this.distance ? 'visible' : 'active'
        };
        this.isRefresh && (data.style = `transition-duration: 0s; transform: translate3d(0, ${diffY}px, 0) scale(1);`);
        this.setData(data);
      };

      return {
        activate,
        deactivate,
        refreshing,
        tail,
        move,
      };
    },

    /**
     * 判断是否正在刷新
     */
    refreshing() {
      const refresher = this.getData();
      const className = (this.isRefresh ? refresher.className : refresher.className2) || '';
      return className.indexOf('refreshing') !== -1;
    },

    /**
     * 获取触摸点坐标
     */
    getTouchPosition(e) {
      return {
        x: e.changedTouches[0].pageX,
        y: e.changedTouches[0].pageY,
      };
    },

    /**
     * 下拉刷新完成后的函数
     */
    finishPullToRefresh(scope, loaded) {
      this.loaded = loaded;
      const methods = this.getRefresherMethods();
      setTimeout(() => {
        this.requestAnimationFrame(methods.tail);
        setTimeout(() => {
          methods.deactivate();
          this.isRefresh = undefined;
        }, 200);
      }, 200);
    },

    /**
     * 手指触摸动作开始
     */
    touchstart(e) {
      if (this.refreshing()) return !1;

      const methods = this.getRefresherMethods();
      const p = this.getTouchPosition(e);

      this.start = p;
      this.diffX = this.diffY = 0;
    },

    /**
     * 手指触摸后移动
     */
    touchmove(e) {
      // const { clientX, clientY, pageX, pageY } = e.changedTouches[0];
      // const { offsetLeft, offsetTop } = e.currentTarget;

      const p = this.getTouchPosition(e);

      const diffX = p.x - this.start.x;
      const diffY = p.y - this.start.y;

      this.onScrollUp && this.onScrollUp(diffY > 0);

      if (!this.start || this.refreshing()) return !1;

      const methods = this.getRefresherMethods();
      // const p = this.getTouchPosition(e);

      this.diffX = diffX;
      this.diffY = diffY;

      if (this.diffY === 0) return !1;
      if (typeof this.isRefresh === 'undefined') {
        if (this.diffY < 0 && (this.loaded || !this.hasLoadMore)) {
          return !1;
        }
        this.isRefresh = this.diffY > 0;
        methods.activate();
      }
      if (this.isRefresh) {
        this.loaded = false;
        this.diffY = Math.pow(this.diffY, 0.8);
      } else {
        this.diffY = -Math.pow(-this.diffY, 0.8);
      }

      if (!this.activated && Math.abs(this.diffY) > this.distance) {
        this.activated = !0;
        typeof this.onPulling === 'function' && this.onPulling();
      } else if (this.activated && Math.abs(this.diffY) < this.distance) {
        this.activated = !1;
      }

      methods.move(this.diffY);
    },

    /**
     * 	手指触摸动作结束
     */
    touchend(e) {
      const methods = this.getRefresherMethods();

      this.start = !1;

      if (typeof this.isRefresh === 'undefined' || this.refreshing()) return !1;
      methods.deactivate();

      if (Math.abs(this.diffY) >= this.distance) {
        methods.refreshing();
        if (this.isRefresh) {
          typeof this.onRefresh === 'function' && this.onRefresh();
        } else {
          typeof this.onLoadMore === 'function' && this.onLoadMore();
        }
      } else {
        this.isRefresh = undefined;
      }
    },
  }
]);
