import Component from '../../components/component';
import mixin from '../../utils/mixin';

export default mixin(Component, [{
  data: {
    canvasCircle: 'canvasCircle',
    text: '',
  },
  process: 0.0,
  radius: 20,
  lineWidth: 2,
  bgColor: '',
  color: '#333333',
  autoRun: 0,
  displayText: true,
  reverse: false,
  methods: {
    handleTap() {
      this.callback && this.callback();
    }
  },
  updateProcess() {
    if (!this.visible) {
      return;
    }
    const radius = this.radius + this.lineWidth;
    const size = radius * 2;
    this.setData({
      size
    })

    this.cxt_arc.clearRect(0, 0, size, size);
    if (this.data.bgColor) {
      this.cxt_arc.setLineWidth(this.lineWidth);
      this.cxt_arc.setStrokeStyle(this.bgColor);
      this.cxt_arc.setLineCap('round');
      this.cxt_arc.beginPath();//开始一个新的路径
      this.cxt_arc.arc( radius , radius, this.radius, 0, 2*Math.PI, false);//设置一个原点(106,106)，半径为100的圆的路径到当前路径
      this.cxt_arc.stroke();//对当前路径进行描边
    }

    this.cxt_arc.setLineWidth(this.lineWidth);
    this.cxt_arc.setStrokeStyle(this.color);
    this.cxt_arc.setLineCap('round');
    this.cxt_arc.beginPath();//开始一个新的路径
    this.cxt_arc.arc( radius , radius, this.radius, - Math.PI * 1 / 2, 2*Math.PI* this.process - Math.PI * 1 / 2 , this.reverse);
    this.cxt_arc.stroke();//对当前路径进行描边

    this.cxt_arc.draw();
  },
  onUnload() {
    this.delayEnter && clearInterval(this.delayEnter);
  },
  onHide() {
    this.delayEnter && clearInterval(this.delayEnter);
    this.delayEnter = null;
  },
  onShow() {
    if (this.autoRun) {
      this.delay = this.autoRun;
      this.reverse = false;
      this.process = 1;
      this.delayEnter = setInterval(() => {
        this.delay -= 200;
        this.process = this.delay / this.autoRun;
        if (this.delay <= 0) {
          if (this.reverse) {
            this.process = 1;
          } else {
            this.process = 0;
          }
          this.delay = this.autoRun;
          this.reverse = !this.reverse;
        }

        this.displayText && this.setData({
          text: Math.ceil(this.delay / 1000)
        });
        this.updateProcess();
      }, 200);
    }
  },
  onReady() {
    this.cxt_arc = dd.createCanvasContext(this.data.canvasCircle);
    this.updateProcess();
  }
}]);
