import Component from '../../components/component';
import mixin from '../../utils/mixin';

export default mixin(Component, [
  {
    data: {
      min: undefined,
      max: undefined,
      step: 1,
      value: 0,
      disabled: !0,
      className: undefined,
    },
    longpress: false,
    methods: {
      updateValues(value, noTrigger) {
        const xnumber = this.getData()

        // 最小值
        if (xnumber.min && value < xnumber.min) {
          value = xnumber.min
        }

        // 最大值
        if (xnumber.max && value > xnumber.max) {
          value = xnumber.max
        }

        // 更新数值，判断最小或最大值禁用sub或add按钮
        this.setData({
          value: value,
          disabledMin: typeof xnumber.min === `undefined` ? !1 : value <= xnumber.min,
          disabledMax: typeof xnumber.max === `undefined` ? !1 : value >= xnumber.max,
        })

        !noTrigger && typeof this.callback === `function` && this.callback(value)
      },
        /**
         * 数字计算函数
         */
      calculation(type, meta) {
        const xnumber = this.getData()

        if (type === `add`) {
          if (xnumber.disabledMax) return !1
          this.updateValues(xnumber.value + xnumber.step)
        }

        if (type === `sub`) {
          if (xnumber.disabledMin) return !1
          this.updateValues(xnumber.value - xnumber.step)
        }

        if (this.longpress && meta) {
          this.timeout = setTimeout(() => this.calculation(type, meta), 100)
        }
      },
      /**
       * 当键盘输入时，触发 input 事件
       */
      catchinput(e) {
        if (this.timeout) clearTimeout(this.timeout)
        this.timeout = setTimeout(() => {
          this.updateValues(Number(e.detail.value) || 0)
        }, 300)
      },
      /**
       * 手指触摸动作开始
       */
      catchtouchstart(e) {
        this.startTime = e.timeStamp
      },
      /**
       * 	手指触摸动作结束
       */
      catchtouchend(e) {
        this.endTime = e.timeStamp
        if (this.timeout) {
          clearTimeout(this.timeout)
        }
      },
      /**
       * 手指触摸动作被打断，如来电提醒，弹窗
       */
      touchcancel(e) {
        this.endTime = e.timeStamp
        if (this.timeout) {
          clearTimeout(this.timeout)
        }
      },
      /**
       * 手指触摸后，超过350ms再离开
       */
      catchlongtap(e) {
        const type = e.currentTarget.dataset.type
        if (this.longpress) {
          this.calculation(type, !0)
        }
      },
      /**
       * 手指触摸后马上离开
       */
      catchtap(e) {
        const type = e.currentTarget.dataset.type
        const timeDiff = this.endTime  - this.startTime < 350
        if (!this.longpress || this.longpress && timeDiff) {
          this.calculation(type, !1)
        }
      },
    },
    onLoad() {
      const data = this.getData();
      this.updateValues(data.value);
    }
  }
]);
