import * as StartupActions from './startup';

import { applyMiddleware, compose, createStore } from '../lib/redux/lib/index';

// import { persistStore, autoRehydrate } from 'redux-persist';
import autoRehydrate from '../lib/redux-persist/lib/autoRehydrate';
import config from '../config/config';
import { createLogger } from '../lib/redux-logger';
import createSagaMiddleware from '../lib/redux-saga/lib/internal/middleware';
import persistStore from '../lib/redux-persist/lib/persistStore';
import reduxPersist from './redux-persist';

/**
 * 创建store
 * @param rootReducer
 * @param rootSaga
 * @returns {*}
 */
export default function (rootReducer, rootSaga) {
  const middleware = [];
  const enhancers = [];

  // saga中间件
  const sagaMiddleware = createSagaMiddleware();
  middleware.push(sagaMiddleware);

  // log中间件
  const SAGA_LOGGING_BLACKLIST = ['EFFECT_TRIGGERED', 'EFFECT_RESOLVED', 'EFFECT_REJECTED'];
  if (config.redux) {
    const logger = createLogger({
      predicate: (getState, { type }) => SAGA_LOGGING_BLACKLIST.indexOf(type) === -1
    });
    middleware.push(logger);
  }
  // 合并中间件
  enhancers.push(applyMiddleware(...middleware));

  // persist rehydrate
  enhancers.push(autoRehydrate());

  const store = createStore(rootReducer, compose(...enhancers));

  // persist



//  persistStore(store, reduxPersist, () => {});




  // kick off root saga
  sagaMiddleware.run(rootSaga);

  return store;
}
