import createAction from '../lib/redux-actions/lib/createAction';
import handleActions from '../lib/redux-actions/lib/handleActions';
import immutable from '../lib/seamless-immutable/src/seamless-immutable';

export const INIT_FILTER = 'INIT_FILTER';
export const INIT_FILTER_FAILURE = 'INIT_FILTER_FAILURE';
export const UPDATE_FILTER = 'UPDATE_FILTER';
export const CONFIRM_FILTER = 'CONFIRM_FILTER';
export const CONFIRM_FILTER_FAILURE = 'CONFIRM_FILTER_FAILURE';
export const UPDATE_SINGLE_FILTER = 'UPDATE_SINGLE_FILTER';
export const UPDATE_SORT = 'UPDATE_SORT';
export const RESET_FILTER = 'RESET_FILTER';

export const initFilter = createAction(INIT_FILTER);
export const resetFilter = createAction(RESET_FILTER);
export const initFilterFailure = createAction(INIT_FILTER_FAILURE);
export const updateFilter = createAction(UPDATE_FILTER);
export const confirmFilter = createAction(CONFIRM_FILTER);
export const confirmFilterFailure = createAction(CONFIRM_FILTER_FAILURE);
export const updateSingleFilter = createAction(UPDATE_SINGLE_FILTER);
export const updateSort = createAction(UPDATE_SORT);

export const INITIAL_STATE = immutable(
    {
        // pageId: 0,
        // selected: 0,
        // searchText: '',
        // filtable: [],
        // sortable: [],
        // sort: [],
        // filter: {},
        // orgFilter: {},
        // error: null
    }
);

export default handleActions(
    {
        [UPDATE_FILTER]: (state, { payload }) => {
            if (!state[payload.pageId]) {
                state = state.merge({ [payload.pageId]: { sort: [], searchText: '', filter: {}, orgFilter: {} } });
            }
            if (payload.filtable && state[payload.pageId].filtable) {
                payload.filtable.forEach((item) => {
               

                    if (!item.statusMap) {
                        const org = state[payload.pageId].filtable.find((f) => f.ID === item.ID);
                        if (org) {
                            item.statusMap = org.statusMap;
                        }
                    }
                });
            }
            // if (payload.filter && state[payload.pageId].filtable) {
            //   for (let ii = 0; ii < state[payload.pageId].filtable.length; ii += 1) {
            //     const items = payload.filter[ii];
            //     state[payload.pageId].filtable[ii].statusMap && (state = state.setIn([payload.pageId, 'filtable', ii, 'statusMap'], state[payload.pageId].filtable[ii].statusMap.map((item) => {
            //       const checked = items && items.findIndex(aa => aa.ID === item.ID) > -1;
            //       return Object.assign({}, item, { checked });
            //     })));
            //   }
            // }
            return state.merge({ [payload.pageId]: state[payload.pageId].merge([{ error: null }, payload]) });
        },
        [CONFIRM_FILTER_FAILURE]: (state, { payload }) => {
            return state.merge({ [payload.pageId]: state[payload.pageId].merge(payload) });
        },
        [INIT_FILTER_FAILURE]: (state, { payload }) => {
            return state.merge({ [payload.pageId]: state[payload.pageId].merge(payload) });
        },
        [UPDATE_SINGLE_FILTER]: (state, { payload }) => {


            if (payload.items.length > 0) {
                state = state.setIn([payload.pageId, 'filter', payload.columnID], payload.items);
            } else {
                state = state.merge({
                    [payload.pageId]: state[payload.pageId].merge({
                        filter: state[payload.pageId].filter.without(payload.columnID)
                    })
                });
            }
            state = state.set('searchText', '');

            return state;
        },
        [UPDATE_SORT]: (state, { payload }) => {
            state = state.setIn(
                [payload.pageId, 'sortable'],
                state[payload.pageId].sortable.map((item) => {
                    const payloadIndex = payload.items.findIndex((aa) => aa.ID === item.ID);
                    if (payloadIndex > -1) {
                        return Object.assign({}, item, {
                            checked: true,
                            icon: payload.items[payloadIndex].icon,
                            orderBy: payload.items[payloadIndex].orderBy
                        });
                    } else {
                        return Object.assign({}, item, { orderBy: 0, checked: false });
                    }
                })
            );
            state = state.setIn([payload.pageId, 'sort'], payload.items);
            return state;
        },
        [RESET_FILTER]: () => INITIAL_STATE
    },
    INITIAL_STATE
);
