import createAction from '../lib/redux-actions/lib/createAction';
import handleActions from '../lib/redux-actions/lib/handleActions';
import immutable from '../lib/seamless-immutable/src/seamless-immutable';

export const FETCH_LIST = 'FETCH_LIST';
export const FETCH_LIST_SUCCESS = 'FETCH_LIST_SUCCESS';
export const FETCH_LIST_FAILURE = 'FETCH_LIST_FAILURE';

export const fetchList = createAction(FETCH_LIST);
export const fetchListSuccess = createAction(FETCH_LIST_SUCCESS);
export const fetchListFailure = createAction(FETCH_LIST_FAILURE);
// 初始state
export const INITIAL_STATE = immutable({
  // pageId: 0,
  // fetching: false,
  // error: null,
  // index: 0,
  // data: []
});

export default handleActions({
  [FETCH_LIST]: (state, { payload }) => state.merge({ [payload.pageId]: { fetching: true, error: null, index: payload.index, data: null } }),
  [FETCH_LIST_SUCCESS]: (state, { payload }) => {
    if (state[payload.pageId]) {
      return state.set(payload.pageId, state[payload.pageId].merge({ fetching: false, error: null, data: payload.data, index: payload.index, categoryId: payload.categoryId }));
    }
    return state;
  },
  [FETCH_LIST_FAILURE]: (state, { payload }) => state.set(payload.pageId, state[payload.pageId].merge({ fetching: false, error: payload.error, index: payload.index }))
}, INITIAL_STATE);
