import createAction from '../lib/redux-actions/lib/createAction';
import handleActions from '../lib/redux-actions/lib/handleActions';
import immutable from '../lib/seamless-immutable/src/seamless-immutable';

export const STARTUP = 'STARTUP';
export const STARTED = 'STARTED';

export const startup = createAction(STARTUP);
export const started = createAction(STARTED);

export const INITIAL_STATE = immutable({
  started: false
});

export default handleActions({
  [STARTED]: (state) => {
    state = state.merge({ started: true });
    return state;
  }
}, INITIAL_STATE);
