import { CATEGORY, category } from '../redux/allcategory';
import { CUSER, cuser } from '../redux/alluser';
import { DEPARTMENT, department } from '../redux/alldepartment';
import { ELEMENT, element } from '../redux/allelement';
import { EVENT, event } from '../redux/allevent';
import { GROUP, group } from '../redux/allgroup';
import { JOIN, join } from '../redux/alljoin';
import { MENU, menu } from '../redux/allmenu';
import { NAVIGATE, navigate } from '../redux/allnavigate';
import { PAGE, page } from '../redux/allpage';
import { PATTERN, pattern } from '../redux/allpattern';
import { STATUS, status } from '../redux/allstatus';
import { STATUSMAP, statusMap } from '../redux/allstatusmap';
import { TAG, tag } from '../redux/alltag';
import { USERELEMENT, userElement } from '../redux/alluserelement';
import { WORKFLOW, workflow } from '../redux/allworkflow';
import { call, put } from '../lib/redux-saga/lib/internal/io';

import { cache } from '../utils/request';
import log from '../utils/log';
import regeneratorRuntime from "../lib/regenerator-runtime/runtime";
import storage from '../utils/storage';

const configs = {
  // // [CATEGORY]: category,
  // // DEPARTMENT: department,
  // [ELEMENT]: element,
  // // EVENT: event,
  // // GROUP: group,
  [JOIN]: join,
  [MENU]: menu,
  // // NAVIGATE: navigate,
  [PAGE]: page,
  // [PATTERN]: pattern,
  // [STATUS]: status,
  [STATUSMAP]: statusMap,
  // // TAG: tag,
  [CUSER]: cuser,
  // //USERELEMENT: userElement,
  [WORKFLOW]: workflow
};

function findConfig(list, name) {
  return list.find(item => item.cacheName.toLowerCase() === name.toLowerCase());
}

function* checkCache(key, remoteCache, forceUpdate) {
  const cacheTimeKey = `cacheTime:${key}`;
  let remoteConfig = { cacheTime: '' };
  if (!forceUpdate) {
    let localCacheTime = '';
    try {
      localCacheTime = yield call(storage.getItem, cacheTimeKey);
    } catch (error) {
      log('checkCache error', error);
    }
    const checkKey = key === STATUSMAP ? STATUS : key;
    remoteConfig = findConfig(remoteCache, checkKey);
    if (!remoteConfig) {
      remoteConfig = { cacheTime: '' };
      forceUpdate = true;
    } else {
      forceUpdate = remoteConfig.cacheTime !== localCacheTime;
    }
  }

  if (forceUpdate) {
    const remoteData = yield call(cache, key, '2013-01-01');
    if (remoteData.add) {
      yield call(storage.setItem, key, remoteData.add);
    } else {
      yield call(storage.removeItem, key);
    }
    if (remoteConfig.cacheTime) {
      yield call(storage.setItem, cacheTimeKey, remoteConfig.cacheTime);
    }
    return remoteData.add;
  }
  let data = [];
  try {
    data = yield call(storage.getItem, key);
  } catch (error) {
    log('checkCache error', error);
  }
  return data;
}

export default function* configSaga(action) {
  try {
    let cacheTime = getApp().cacheTime;
    if (!cacheTime) {
      cacheTime = yield call(cache, 'cacheTime', '2013-01-01');
      cacheTime = cacheTime.add ? cacheTime.add : [];
    }

    // const cacheToken = yield call(storage.getItem, 'cacheToken');
    const forceUpdate = false; // cacheToken === null || cacheToken !== action.payload;
    let keys = Object.keys(configs);
    if (action.keys) {
      keys = action.keys;
    }
    for (let index in keys) {
      const key = keys[index];
      const value = configs[key];
      const data = yield checkCache(key, cacheTime, forceUpdate);
      if (data)
        yield put(value(data));
    }
    // yield call(storage.setItem, 'cacheToken', action.payload);
  } catch (error) {
    log('configSaga error', error);
    // yield put(loginFailure(error));
  }
}
