import { call, put, select } from '../lib/redux-saga/lib/internal/io';
import { fetchDetailFailure, fetchDetailSuccess } from '../redux/detail';

import { detail2 } from '../utils/request';
import globalConfigs from './globalConfigs';
import log from '../utils/log';
import pageConfigs from './pageConfigs';
import { refreshItemDisplay } from '../utils/utils';
//import regeneratorRuntime from '../lib/regenerator-runtime/runtime';

export default function* detailSaga(action) {
    const { pageId, itemId, forEdit, customModifyItem, server_identity } = action.payload;
    try {
        // const configs = yield* globalConfigs();
        // if (configs) {
        //   const pageConfig = yield* pageConfigs({ payload: { pageId } });
        let item = {};
        let data = {
            related: []
        };
        if (itemId || itemId === 0 || server_identity) {
            data = yield detail2(pageId, itemId, server_identity);
            item = data.data;
            if (Array.isArray(item)) {
                item = {};
            }
        }
        if (forEdit) {
            const configs = yield* globalConfigs();
            if (configs) {
                const pageConfig = yield* pageConfigs({
                    payload: {
                        pageId
                    }
                });
                // console.log(
                //     'detailSaga',
                //     configs,
                //     pageConfig.columns.columns,
                //     configs.cuser.data,
                //     configs.department.data,
                //     pageConfig.columns.statusMap,
                //     item
                // );
                yield refreshItemDisplay(
                    pageConfig.columns.columns,
                    {
                        users: configs.cuser.data,
                        departments: configs.department.data,
                        statusMap: pageConfig.columns.statusMap
                    },
                    item,
                    'ord',
                    forEdit
                );
            } else {
                yield put(
                    fetchDetailFailure({
                        pageId,
                        error: new Error('刷新配置信息失败'),
                        itemId
                    })
                );
                return;
            }
        }
        // yield refreshItemDisplay(pageConfig.columns.columns, configs.cuser.data, item, 'ord', forEdit);
        // if (!forEdit) {
        //   for (let ii = 0; ii < data.related.length; ii += 1) {
        //     const related = data.related[ii];
        //     const relatedPage = yield pageConfigs({ payload: { pageId: related.pageId } });
        //     if (relatedPage.columns.columns.length > 0) {
        //       for (let jj = 0; jj < related.list.length; jj += 1) {
        //         const dataItem = related.list[jj];
        //         yield refreshItemDisplay(relatedPage.columns.columns, configs.cuser.data, dataItem, 'ord', forEdit);
        //       }
        //     }
        //   }
        // }
        item.related = data.related;

        customModifyItem && customModifyItem(item);

        yield put(
            fetchDetailSuccess({
                pageId,
                data: item,
                itemId
            })
        );
        // } else {
        //   yield put(fetchDetailFailure({ pageId, error: new Error('刷新配置信息失败'), itemId }));
        // }
    } catch (error) {
        log('detailSaga error', error);
        yield put(
            fetchDetailFailure({
                pageId,
                error,
                itemId
            })
        );
    }
}
