import { confirmFilterFailure, initFilterFailure, updateFilter } from '../redux/filter';
import { put, select } from '../lib/redux-saga/lib/internal/io';

import config from '../config/config';
import globalConfigs from './globalConfigs';
import log from '../utils/log';
import pageConfigs from './pageConfigs';
//import regeneratorRuntime from '../lib/regenerator-runtime/runtime';
import { updateLsc } from '../redux/lsc';
import { parseFilter } from '../utils/utils';

const getState = (state) => ({ filter: state.filter });

export function* initFilterSaga(action) {

  console.log('initFilterSaga' );



    const { pageId, selected } = action.payload;
    const { filter } = yield select(getState);
    const noMap =
        filter[pageId] &&
        !filter[pageId].refreshed &&
        filter[pageId].filtable &&
        filter[pageId].filtable.find((item) => !item.statusMap);
    log('initFilterSaga noMap', pageId, noMap, filter[pageId]);
    if (!filter[pageId] || !filter[pageId].filtable || filter[pageId].filtable.length === 0 || noMap) {
        try {
            const configs = yield* globalConfigs();

            // mark('initFilterSaga', 'globalConfigs');
            if (configs) {
                const pageConfig = yield* pageConfigs({ payload: { pageId } });

                // mark('initFilterSaga', 'pageConfigs');

                log('initFilterSaga pageConfig', pageConfig);
                const payload = parseFilter(
                    pageConfig,
                    {
                        cuser: configs.cuser.data,
                        department: configs.department && configs.department.data ? configs.department.data : [],
                        selected
                    },
                    filter[pageId]
                );

                  console.log('initFilterSaga', payload);
                // mark('initFilterSaga', 'initFilterSagaEnd');

                yield put(updateFilter(payload));
            } else {
                yield put(initFilterFailure({ pageId, error: new Error('刷新配置信息失败') }));
            }
        } catch (error) {
            log('initFilterSaga error', error);
            yield put(initFilterFailure({ pageId, error: new Error('刷新配置信息失败') }));
        }
    } else {
        yield put(updateFilter({ pageId }));
    }
}

export function* confirmFilterSaga(action) {
    const { pageId } = action.payload;
    try {
        const { filter } = yield select(getState);
        const lsc = [];
        if (filter[pageId].searchText) {
            if (filter[pageId].searchable) {
                filter[pageId].searchable.forEach((item, index) => {
                    let operation = 16;
                    if (lsc.length === 0) {
                        operation = 6;
                    }
                    lsc.push({
                        patternId: item.ID,
                        pTypeId: item.pTypeId,
                        val1: filter[pageId].searchText,
                        operation,
                        findex: index + 1
                    });
                });
            } else {
                const configs = yield globalConfigs();
                if (configs) {
                    const pageConfig = yield pageConfigs({ payload: { pageId } });
                    const { columns, searchable } = pageConfig.columns;
                    searchable.forEach((item, index) => {
                        const column = columns[item.index];
                        let operation = 16;
                        if (lsc.length === 0) {
                            operation = 6;
                        }
                        lsc.push({
                            patternId: column.ID,
                            pTypeId: column.pTypeId,
                            val1: filter[pageId].searchText,
                            operation,
                            findex: index + 1
                        });
                    });
                } else {
                    yield put(confirmFilterFailure({ pageId, error: new Error('刷新配置信息失败') }));
                }
            }
        } else {
            for (let key in filter[pageId].filter) {
                let selected = filter[pageId].filter[key];
                const column = filter[pageId].filtable.find((c) => c.ID == key);
                if (column.pTypeId === 4 || column.pTypeId == 6) {
                    if (typeof selected[0].min !== 'undefined') {
                        lsc.push({
                            patternId: column.ID,
                            pTypeId: column.pTypeId,
                            operation: 7,
                            val1: selected[0].min
                        });
                    }
                    if (typeof selected[0].max !== 'undefined') {
                        lsc.push({
                            patternId: column.ID,
                            pTypeId: column.pTypeId,
                            operation: 2,
                            val1: selected[0].max
                        });
                    }
                } else if (column.pTypeId === 5 || column.pTypeId == 7) {
                    if (typeof selected[0].min !== 'undefined') {
                        lsc.push({
                            patternId: column.ID,
                            pTypeId: column.pTypeId,
                            operation: 6,
                            val1: selected[0].min
                        });
                    }
                } else if (column.pTypeId == 24) {
                    lsc.push({
                        patternId: column.ID,
                        pTypeId: column.pTypeId,
                        operation: 1,
                        val1: `${selected[0].min},${selected[0].max}`
                    });
                } else if (column.multi) {
                    selected = selected.filter((aa) => aa.ID);
                    selected.length > 0 &&
                        lsc.push({
                            patternId: column.ID,
                            pTypeId: column.pTypeId,
                            operation: 5,
                            val1: selected.map((aa) => aa.ID).join(',')
                        });
                } else {
                    selected = selected.filter((aa) => aa.ID);
                    selected.length > 0 &&
                        lsc.push({ patternId: column.ID, pTypeId: column.pTypeId, operation: 1, val1: selected[0].ID });
                }
            }
            yield put(updateFilter({ pageId, orgFilter: filter[pageId].filter }));
        }
        if (filter[pageId].sort) {
            for (let ii = 0; ii < filter[pageId].sort.length; ii += 1) {
                const sortConfig = filter[pageId].sort[ii];
                const sort = lsc.find((item) => item.patternId === sortConfig.ID);
                const orderBy = typeof sortConfig.orderBy !== 'undefined' ? sortConfig.orderBy : 1;
                if (sort) {
                    sort.orderBy = orderBy;
                } else {
                    lsc.push({ patternId: sortConfig.ID, pTypeId: sortConfig.pTypeId, orderBy: orderBy ,
                      operation:1, val1:''
                    });
                    //2021-02-05修改
                }
            }
        }
        yield put(
            updateLsc({
                pageId,
                lsc
            })
        );
    } catch (error) {
        log('confirmFilterSaga', error);
        yield put(confirmFilterFailure({ pageId, error }));
    }
}
