import { CUSER, cuser } from '../redux/alluser';
import { JOIN, join } from '../redux/alljoin';
import { PAGE, page } from '../redux/allpage';
import { CATEGORY, category } from '../redux/category';
import { STATUSMAP, statusMap } from '../redux/allstatusmap';
import { WORKFLOW, workflow } from '../redux/allworkflow';
import { DEPARTMENT, department } from '../redux/alldepartment';
import { CONFIGURATION, configuration } from '../redux/configuration';
import { call, put, select } from '../lib/redux-saga/lib/internal/io';
import { tryStrToJson } from '../utils/utils';
import { cache2 } from '../utils/request';
import config from '../config/config';
import log from '../utils/log';
//import regeneratorRuntime from '../lib/regenerator-runtime/runtime';

const configs = {
  [CATEGORY]: category,
  [DEPARTMENT]: department,
  // [ELEMENT]: element,
  // // EVENT: event,
  // // GROUP: group,
  [JOIN]: join,
  // [MENU]: menu,
  // // NAVIGATE: navigate,
  [PAGE]: page,
  // [PATTERN]: pattern,
  // [STATUS]: status,
  [STATUSMAP]: statusMap,
  // // TAG: tag,
  [CUSER]: cuser,
  // //USERELEMENT: userElement,
  [WORKFLOW]: workflow,
  [CONFIGURATION]: configuration
};

const getState = state => ({ join: state.join,
  category: state.category,
  page: state.page,
  statusMap: state.map,
  cuser: state.cuser,
  workflow: state.workflow,
  department: state.department
});

export function* getCacheTime() {
  let cacheTime = getApp().cacheTime;



  if (!cacheTime) {
    cacheTime = yield call(cache2, 'cacheTime', '2013-01-01');
    if (cacheTime.cachetime && cacheTime.cachetime.length > 0) {
      cacheTime = cacheTime.cachetime[0].cacheTime;
    } else {
      cacheTime = '';
    }



    getApp().cacheTime = cacheTime;
  }
  return cacheTime;
}

export default function* globalConfigSaga() {
  try {




    let cacheTime = yield* getCacheTime();



    const localData = yield select(getState);







    let localCacheTime = localData.page.cacheTime;





    let remoteData = {};
    if (cacheTime !== localCacheTime) {
      remoteData = yield call(cache2, 'page', '2013-01-01');
      let keys = Object.keys(configs);
      const newData = {};
      for (let ii = 0; ii < keys.length; ii += 1) {
        const key = keys[ii];
        const dataKey = key.toLowerCase();
        const value = configs[key];
        let data = dataKey === 'cuser' ? remoteData[dataKey].map(item => Object.assign({ primaryText: item.XingMing, ID: item.UserId }, item)) : remoteData[dataKey];
        if (dataKey === 'department') {
          data = remoteData[dataKey].map(item => Object.assign({ primaryText: item.departmentName }, item));
        } else if (dataKey === 'page') {
          data = remoteData[dataKey].map(item => {
            const pageProperty = tryStrToJson(item.pageProperty) || {};
            return Object.assign({}, item, { pageProperty })
          });
        }
        if (data) {

          // if (data.length>5){
          //    data = data.slice(0,5);
          // }
          // console.log(JSON.stringify(data).length);

          data = { cacheTime, data };
          newData[dataKey] = data;
          yield put(value(data));
        }
      }
      return newData;
    }

    return localData;
  } catch (error) {
    log('globalConfigSaga error', error);
    // yield put(loginFailure(error));
  }
}
