import { fetchListFailure, fetchListSuccess } from '../redux/list';

import globalConfigs from './globalConfigs';
import log from '../utils/log';
import pageConfigs from './pageConfigs';
import { put } from '../lib/redux-saga/lib/internal/io';
import { refreshItemDisplay } from '../utils/utils';
//import regeneratorRuntime from '../lib/regenerator-runtime/runtime';
import { search2 } from '../utils/request';

export default function* listSaga(action) {
  let { categoryId, pageId, lsc, index, fetchSize, customModifyItem, displayCol } = action.payload;
  try {
     // const configs = yield* globalConfigs();
     // if (configs) {
     //   const pageConfig = yield* pageConfigs({ payload: { pageId } });
     // }
    //   categoryId || (categoryId = (pageConfig.page ? pageConfig.page.categoryId : 0));
    console.log(categoryId, pageId, lsc, index, fetchSize);
    const data = yield search2(categoryId, pageId, lsc, index, fetchSize);
    const items = data.data;
    if (items) {
      let ii = 0;
      while (ii < items.length) {
        const item = items[ii];

        const related = data.relatedData[ii];
        if (related) {
          items[ii].related = [related];
        } else {
          items[ii].related = [];
        }

        if (customModifyItem) {
          customModifyItem(item);
        }
        if (displayCol) {
          items[ii] = Object.assign({ server_identity: item.server_identity, primaryText: item[displayCol] }, item);
        } else {
          // yield refreshItemDisplay(pageConfig.columns.columns, configs.cuser.data, item);
        }

        // const relatedPage = yield pageConfigs({ payload: { pageId: related.pageId } });
        // if (relatedPage.columns.columns.length > 0) {
        //   for (let jj = 0; jj < related.list.length; jj += 1) {
        //     const dataItem = related.list[jj];
        //     yield refreshItemDisplay(relatedPage.columns.columns, configs.cuser.data, dataItem);
        //   }
        // }

        ii += 1;
      }
      yield put(fetchListSuccess({
        pageId, data: items, index, categoryId
      }));
    } else {
      yield put(fetchListFailure({ pageId, error: new Error('返回列表数据错误'), index }));
    }
    // } else {
    //   yield put(fetchListFailure({ pageId, error: new Error('刷新配置信息失败'), index }));
    // }
  } catch (error) {
    log('fetchListFailure', error);
    yield put(fetchListFailure({ pageId, error, index }));
  }
}
