import { FETCH_PREVIOUS_MESSAGE, SIG_CLEAR_UNREAD, SIG_FETCH_USERS, SIG_SEND_MESSAGE, connectSignalrError, connectSignalrSuccess, signalrError, signalrMsg, signalrPreMsg, signalrStateChanged, signalrUserOffline, signalrUserOnline, signalrUsers } from '../redux/signalr';
import { call, fork, put, select, take } from '../lib/redux-saga/lib/internal/io';

import config from '../config/config'
import { eventChannel } from '../lib/redux-saga/lib/internal/channel';
import log from '../utils/log';
//import regeneratorRuntime from '../lib/regenerator-runtime/runtime';
import signalr from '../lib/signalr/index';
import user from '../redux/user'

function* watchMessageEventChannel(onMessage, callback) {
  const chan = eventChannel(emitter => {
    onMessage(function(){
      const args = [].slice.call(arguments, 0);
      emitter(args);
    });
    return () => {
      // hubProxy.close().then(() => console.log('logout'));
    };
  });
  while (true) {
    const message = yield take(chan);
    yield put(callback(message));
  }
}

let hubProxy;

export default function* signalrSaga() {
  if (!hubProxy) {
    try {
      const connection = signalr.hubConnection(config.wsRoot, {
        useDefaultPath: false,
        logging: true
      });

      hubProxy = connection.createHubProxy(config.hubProxy);

      yield fork(watchMessageEventChannel, call=>hubProxy.on('getOnlineUsers', call), signalrUsers);
      yield fork(watchMessageEventChannel, call=>hubProxy.on('broadcastMessage', call), signalrMsg);
      yield fork(watchMessageEventChannel, call=>hubProxy.on('getPreviousMessage', call), signalrPreMsg);
      yield fork(watchMessageEventChannel, call=>hubProxy.on('join', call), signalrUserOnline);
      yield fork(watchMessageEventChannel, call=>hubProxy.on('leave', call), signalrUserOffline);
      yield fork(watchMessageEventChannel, call=>hubProxy.on('error', call), signalrError);

      yield fork(watchMessageEventChannel, call=>connection.error(call), signalrError);

      const cookieKey = config.cookie;
      const header = {};
      if (getApp().cookie) {
        header.Cookie = `${cookieKey}=${getApp().cookie}`;
      }

      yield fork(watchMessageEventChannel, call=>connection.stateChanged(call), (message) => {
        if (message[0].newState === 4) {
          setTimeout(function() {
            connection.start({ jsonp: true, header, transport:['webSockets'] });
          }, 15000); // Re-start connection after 15 seconds
        }
        return signalrStateChanged(message);
      });

      hubProxy.server = {
        Send: function (userId, message) {
          return hubProxy.invoke('Send', userId, message);
        },
        GetOnlineUsers: function () {
          return hubProxy.invoke('GetOnlineUsers');
        },
        Read: function (userId) {
          return hubProxy.invoke('Read', userId);
        },
        GetPreviousMessage: function(toUser, pageIndex, pageSize,time) {
          return hubProxy.invoke('GetPreviousMessage', toUser, pageIndex, pageSize,time);
        }
      };

      // connect
      yield call(connection.start, { jsonp: true, header, transport:['webSockets']});
      log('Now connected, connection ID=' + connection.id);

      // yield put(connectSignalrSuccess());

      // hubProxy.server.GetOnlineUsers();
      // hubProxy.server.Send('43ae61bf-abcc-4eab-9f12-00addef4433b', 'buzhidao');
      // hubProxy.server.GetPreviousMessage('43ae61bf-abcc-4eab-9f12-00addef4433b', 1, 10);
    } catch (error) {
      log('signalrSaga error', error);
      yield put(connectSignalrError(error));
    }
  }
}

const getState = state => ({ signalr: state.signalr});

export function* signalrOpSaga(action) {
  if (hubProxy) {
    try {
      if (action.type === SIG_FETCH_USERS) {
        yield call(hubProxy.server.GetOnlineUsers);
      } else if (action.type === SIG_SEND_MESSAGE) {
        // console.log(action);
        yield call(hubProxy.server.Send, action.payload.userId, action.payload.message);
      }  else if (action.type === SIG_CLEAR_UNREAD) {
        // console.log(action);
        yield call(hubProxy.server.Read, action.payload.userId);
      } else if (action.type === FETCH_PREVIOUS_MESSAGE) {
        const localData = yield select(getState);
        const userMessages = localData.signalr.messages[action.payload.userId] || {};
        log(action.payload.userId, userMessages.pageIndex ? userMessages.pageIndex + 1 : 1, config.fetchSize , localData.signalr.connectedWhen);
        yield call(hubProxy.server.GetPreviousMessage, action.payload.userId, userMessages.pageIndex ? userMessages.pageIndex + 1 : 1, config.fetchSize , localData.signalr.connectedWhen);
      }
    }catch (error) {
      yield put(signalrError(error));
    }
  } else {
    yield put(signalrError({code: -1, message: '没有连接到服务器'}));
  }
}
