import isString from '../lib/lodash/isString';

export function dateStr(date) { //获取js 时间戳
  if (!date) {
    return '';
  }

  if (isString(date)) {
    date = date.replace(' ', 'T');
    date = new Date(date);
  }
  let time = new Date().getTime(); // 去掉 js 时间戳后三位，与时间戳保持一致
  time = parseInt((time - date.getTime()) / 1000, 10); // 存储转换值
  let s;
  if (time <= 0) {
    var y = date.getFullYear();
    var m = date.getMonth() + 1;
    var d = date.getDate();
    return y + "-" + m + "-" + d;
  }

  // if (time < 600) { //十分钟内
  //   return '刚刚';
  // } else if (time < 3600) { //超过十分钟少于1小时
  //   s = Math.floor(time / 60);
  //   return s + "分钟前";
  // } else if (time < 86400) {
  //   //超过1小时少于24小时
  //   s = Math.floor(time / 60 / 60);
  //   return s + "小时前";
  // } else if (time < 2592000) {
  //   //超过1天少于30天内
  //   s = Math.floor(time / 86400);
  //   return s + "天前";
  // } else if (time < 15552000) {
  //   //超过30天少于180天内
  //   s = Math.floor(time / 2592000);
  //   return s + "月前";
  // } else {
    //超过3天
    return date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate();
  // }
}

// 对Date的扩展，将 Date 转化为指定格式的String
// 月(M)、日(d)、小时(h)、分(m)、秒(s)、季度(q) 可以用 1-2 个占位符，
// 年(y)可以用 1-4 个占位符，毫秒(S)只能用 1 个占位符(是 1-3 位的数字)
// 例子：
// (new Date()).Format("yyyy-MM-dd hh:mm:ss.S") ==> 2006-07-02 08:09:04.423
// (new Date()).Format("yyyy-M-d h:m:s.S")      ==> 2006-7-2 8:9:4.18
export function formatDate(date, fmt) {
  if (!date) {
    return '';
  }
  if (isString(date)) {
    date = date.replace(' ', 'T');
    date = new Date(date);
  }
  var o = {
    "M+": date.getMonth() + 1, //月份
    "d+": date.getDate(), //日
    "h+": date.getHours(), //小时
    "m+": date.getMinutes(), //分
    "s+": date.getSeconds(), //秒
    "q+": Math.floor((date.getMonth() + 3) / 3), //季度
    "S": date.getMilliseconds() //毫秒
  };
  if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (date.getFullYear() + "").substr(4 - RegExp.$1.length));
  for (var k in o)
    if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
  return fmt;
}

var now = new Date(); //当前日期
var nowDayOfWeek = now.getDay(); //今天本周的第几天
var nowDay = now.getDate(); //当前日
var nowMonth = now.getMonth(); //当前月
var nowYear = now.getYear(); //当前年
nowYear += (nowYear < 2000) ? 1900 : 0; //
var lastMonthDate = new Date(); //上月日期
lastMonthDate.setDate(1);
lastMonthDate.setMonth(lastMonthDate.getMonth()-1);
var lastYear = lastMonthDate.getYear();
var lastMonth = lastMonthDate.getMonth();

// 获得某月的天数
function getMonthDays(myMonth){
  var monthStartDate = new Date(nowYear, myMonth, 1);
  var monthEndDate = new Date(nowYear, myMonth + 1, 1);
  var days = (monthEndDate - monthStartDate) / (1000 * 60 * 60 * 24);
  return days;
}

// 获得本季度的开端月份
function getQuarterStartMonth() {
  var quarterStartMonth = 0;
  if (nowMonth < 3) {
    quarterStartMonth = 0;
  }
  if (2 < nowMonth && nowMonth < 6) {
    quarterStartMonth = 3;
  }
  if (5 < nowMonth && nowMonth < 9) {
    quarterStartMonth = 6;
  }
  if (nowMonth > 8) {
    quarterStartMonth = 9;
  }
  return quarterStartMonth;
}

// 获得本周的开端日期
export function getWeekStartDate() {
  var weekStartDate = new Date(nowYear, nowMonth, nowDay - nowDayOfWeek);
  return weekStartDate;
}

// 获得本周的停止日期
export function getWeekEndDate() {
  var weekEndDate = new Date(nowYear, nowMonth, nowDay + (6 - nowDayOfWeek));
  return weekEndDate;
}

//当前天数加1
export function getTomorrow() {
  var tomorrow = new Date(nowYear, nowMonth, nowDay + 1);
  return tomorrow;
}

export function getDiffDay(diff) {
  var diffday = new Date(nowYear, nowMonth, nowDay + diff);
  return diffday;
}

// 获得本月的开端日期
export function getMonthStartDate() {
  var monthStartDate = new Date(nowYear, nowMonth, 1);
  return monthStartDate;
}

// 获得本月的停止日期
export function getMonthEndDate() {
  var monthEndDate = new Date(nowYear, nowMonth, getMonthDays(nowMonth));
  return monthEndDate;
}

// 获得上月开端时候
export function getLastMonthStartDate() {
  var lastMonthStartDate = new Date(nowYear, lastMonth, 1);
  return lastMonthStartDate;
}

// 获得上月停止时候
export function getLastMonthEndDate() {
  var lastMonthEndDate = new Date(nowYear, lastMonth, getMonthDays(lastMonth));
  return lastMonthEndDate;
}

// 获得本季度的开端日期
export function getQuarterStartDate() {
  var quarterStartDate = new Date(nowYear, getQuarterStartMonth(), 1);
  return quarterStartDate;
}

// 或的本季度的停止日期
export function getQuarterEndDate() {
  var quarterEndMonth = getQuarterStartMonth() + 2;
  var quarterStartDate = new Date(nowYear, quarterEndMonth, getMonthDays(quarterEndMonth));
  return quarterStartDate;
}
