var slice = function(array, start, end) {
    return array.slice(start, end);
};

var indexOf = function(str, search) {
    if (!str) {
        return -1;
    }
    // console.log('indexOf', str, search ,str.indexOf(search));
    return str.indexOf(search);
};

var getCom = function(coms, column, gindex, index) {
    // console.log('getCom', coms, column, gindex, index);
    if (!coms) {
        // console.log('getCom5555555');
        return null;
    }
    if (gindex || gindex === 0) {
        if (!coms['' + gindex]) {
            return null;
        }
        if (index || index === 0) {
            if (!coms['' + gindex]['' + index]) {
                return null;
            }
            // console.log('getCom2', gindex, index);
            return coms['' + gindex]['' + index][column.eid || column];
        } else {
            // console.log('getCom3', coms[''+gindex][column.eid || column]);
            return coms['' + gindex][column.eid || column];
        }
    } else {
        // console.log('getCom4', gindex, index);
        return coms[column.eid || column];
    }
};

var defaultLayoutGrid = [ { flex: 1, sections: [ 1 ] }, { flex: 1, sections: [ 1, 1 ] } ];

var oddSections = function(layoutGrid) {
    if (!layoutGrid) {
        layoutGrid = defaultLayoutGrid;
    }
    var total = 0;
    for (var ii = 0; ii < layoutGrid.length; ii++) {
        var section = layoutGrid[ii];
        if (section.sections) {
            total += oddSections(section.sections);
        } else {
            total++;
        }
    }
    console.log('oddSections', total);
    return total;
};

var oddArray = function(layoutGrid, items) {
    if (!layoutGrid) {
        layoutGrid = defaultLayoutGrid;
    }
    if (items && items.length > 0) {
        var count = Math.ceil(1.0 * items.length / oddSections(layoutGrid));
        return makeIndexArray(0, count);
    } else {
        return [];
    }
};

var makeIndexArray = function(startIned, endIndex) {
    var arr = [];
    for (var ii = startIned; ii < endIndex; ii++) {
        arr.push(ii);
    }
    return arr;
};

var linkChainDisplay = function(item, column) {
    var display = item[column.eid + '___Display'];
    if (column.linkChain) {
        display = '';
        for (var ii = 0; ii < column.linkChain.length; ii++) {
            var c = column.linkChain[ii];
            if (display) {
                display = display + ' ';
            }
            if (item[c.eid + '___Display']) {
                display = display + item[c.eid + '___Display'];
            }
        }
    }
    return display || (column.property && column.property.placeholder) || '\t';
};

var print = function(val) {
    console.log('print', typeof val === 'object' ? JSON.stringify(val, null, '\t') : val);
    return val;
};

var isString = function(val) {
    return val && val.slice && 'String' === val.slice().constructor;
};

var isArray = function(val) {
    return val && val.slice && 'Array' === val.slice().constructor;
};

var isNumber = function(val) {
    return val === 0 || (val && 'Number' === val.constructor);
};

var fixDate = function(date) {
    if (isString(date)) {
        date = date.replace(' ', 'T');
        if (date.indexOf(':') >= 0 && date.indexOf('+08:00') < 0) {
            date = date + '+08:00';
        }
        date = getDate(date);
    }
    return date;
};

var formatDate = function(date, fmt) {
    if (!date) {
        return '';
    }
    date = fixDate(date);
    var o = [
        'M+', //月份
        'd+', //日
        'h+', //小时
        'm+', //分
        's+', //秒
        'q+', //季度
        'S' //毫秒
    ];
    var d = [
        date.getMonth() + 1, //月份
        date.getDate(), //日
        date.getHours(), //小时
        date.getMinutes(), //分
        date.getSeconds(), //秒
        Math.floor((date.getMonth() + 3) / 3), //季度
        date.getMilliseconds() //毫秒
    ];
    var reg = getRegExp('(y+)', '');
    var test = reg.exec(fmt);
    if (test) {
        fmt = fmt.replace(test[0], (date.getFullYear() + '').substring(4 - test[0].length));
    }
    for (var ii = 0; ii < o.length; ii++) {
        var oo = o[ii];
        var dd = d[ii];
        var rr = getRegExp(oo, '');
        var tt = rr.exec(fmt);
        if (tt) {
            fmt = fmt.replace(tt[0], tt[0].length === 1 ? dd : ('00' + dd).substring(('' + dd).length));
        }
    }
    return fmt;
};

var fixArray = function(value) {
    value === 0 || value || (value = '');
    if (!(isArray(value) || isString(value) || isNumber(value))) {
        return [ value ];
    }
    return value;
};

var vDi = function(attr) {
    return function(v) {
        return v[attr];
    };
};

var itemValueByColumn = function(column, item) {
    var display = column && item[column.eid + '___Display'];
    if (!display && column && item[column.eid]) {
        var value = item[column.eid];
        console.log(column.editType);
        if (column.editType === 'date') {
            var property = column.property || {};
            var format = property.type === 'datetime' ? 'yyyy-MM-dd hh:mm:ss' : 'yyyy-MM-dd';
            display = formatDate(value, format);
        } else if (column.editType === 'switch') {
            display = value ? '是' : '否';
        } else if (column.editType === 'status' || column.editType === 'mstatus') {
            display = fixArray(value).map(vDi('statusName')).join(',');
        } else if (column.editType === 'user' || column.editType === 'users') {
            display = fixArray(value).map(vDi('XingMing')).join(',');
        } else if (column.editType === 'department') {
            display = fixArray(value).map(vDi('departmentName')).join(',');
        } else if (column.editType === 'link') {
            var join = column.join;
            if (!column.join || typeof value !== 'object') {
                return '';
            }
            var displayCol = '__c' + join.viewPatternId;
            display = fixArray(value).map(vDi(displayCol)).join(',');
        } else if (column.editType === 'location') {
            if (isString(value)) {
                value = JSON.parse(value);
            }
            if (value && value.address) {
                display = value.address;
            }
        } else if (column.editType === 'attachments' || column.editType === 'attachment') {
            display = '';
        } else if (column.editType === 'textarea') {
            // removeHtml
            display = value;
        } else {
            display = (value || '') + '';
        }
    }
    // console.log(display, column && column.editType, 'dddddd');
    if (!display || display === 'undefined' || display === 'null') {
        display = '';
    }
    return display;
};

var getColumnWidth = function(columnWidth, columnCount, aaa) {
    if (columnWidth) {
        return 'width:' + 100 * columnWidth + '%;';
    } else if (columnCount) {
        return 'width:' + 100 / columnCount + '%;';
    }
    return '';
};

var isUndefined = function(val) {
    return typeof val === 'undefined';
};

var rateValue = function(value) {
    var _val = value.toString().split('.');
    var sliceValue = _val.length === 1 ? [ _val[0], 0 ] : _val;
    var cutIndex = parseFloat(sliceValue[0]) * 1;
    var cutPercent = parseFloat('0.' + sliceValue[1]) * 100;

    return { cutIndex: cutIndex, cutPercent: cutPercent };
};

export default {

  rateValue,
  isUndefined,
  getColumnWidth,
  formatDate,
  fixDate,
  itemValueByColumn,
  isString,
  print,
  linkChainDisplay,
  defaultLayoutGrid,
  makeIndexArray,
  oddSections,
  oddArray,
  slice,
  indexOf,
  getCom

};
//
// module.exports.rateValue = rateValue;
// module.exports.isUndefined = isUndefined;
// module.exports.getColumnWidth = getColumnWidth;
// module.exports.formatDate = formatDate;
// module.exports.fixDate = fixDate;
// module.exports.itemValueByColumn = itemValueByColumn;
// module.exports.isString = isString;
// module.exports.print = print;
// module.exports.linkChainDisplay = linkChainDisplay;
// module.exports.defaultLayoutGrid = defaultLayoutGrid;
// module.exports.makeIndexArray = makeIndexArray;
// module.exports.oddSections = oddSections;
// module.exports.oddArray = oddArray;
// module.exports.slice = slice;
// module.exports.indexOf = indexOf;
// module.exports.getCom = getCom;
