import { cachePage } from './request';
import { pageFullInfoFromId, parsePageInfo, getPatterns } from './utils';
import log, { mark } from '../utils/log';
const regeneratorRuntime = require('../lib/regenerator-runtime/runtime');

export const parseColumns = async function parseColumns(pageId, data) {
    // 获取页面信息，包含子页面
    const pageInfo = pageFullInfoFromId(pageId, data.allPages);

    // 默认列信息
    let defaultData = {
        columns: [],
        searchable: [],
        filtable: [],
        sortable: [],
        display: [],
        workflow: [],
        listpage: [],
        statusMap: {}
    };

    log('parseColumns', pageId, data);
    if (data.needFetch || data.local ) {
        if (pageInfo.page) {
            let element;
            let pattern;
            let status;

            if (data.local) {
                element = data.element;
                pattern = data.pattern;
                status = data.status;
            } else {
                const pageData = await cachePage(pageId);
                element = pageData.element;
                pattern = pageData.pattern;
                status = pageData.status;
            }

            // 获取列信息
            defaultData = parsePageInfo(
                pageInfo.page,
                pageInfo.subPages,
                data.allPages,
                pattern,
                element,
                data.statusMap,
                status,
                data.join
            );

            if (pageInfo.page.pageType === 10) {
            } else if (pageInfo.page.pageType === 16) {
            } else {
                const workflow = data.allPages.filter(
                    (p) => (p.pageType == 3 || p.pageType == 9) && p.categoryId === pageInfo.page.categoryId
                );
                if (workflow.length > 0 && defaultData.listpage.length > 0) {
                    console.log(workflow);
                    for (let ii = 0; ii < workflow.length; ii++) {
                        const w = workflow[ii];
                        if (!data.local) {
                            const workflowColumns = await cachePage(w.ID);
                            element = workflowColumns.element;
                            pattern = workflowColumns.pattern;
                            status = workflowColumns.status;
                        }
                      //  console.log(element);
                      //  console.log(w);

                        const cPatIds = element.filter(x=>x.pageId==w.ID).map(x=>x.patternId);

                      //  console.log(cPatIds);



                        let columnsAll = getPatterns(pattern, data.statusMap, status, data.join);
                        let columns = columnsAll.columns.filter(x=> cPatIds.indexOf(x.ID)>=0);
                        // 2021-03-17 bug
                        if (w.pageType == 9) {
                            columns = columns.filter((c) => c.pTypeId === 13);
                        }
                  //      console.log(columns);
                        if (columns.length > 0) {
                            let wstatusMap = columnsAll.statusMap[columns[0].ID];



                            if (w.pageType == 9) {
                                const availableStatus = data.workflow.filter((n) => {
                                    return n.categoryId === w.categoryId;
                                });
                                let subStatus = [];
                                availableStatus.forEach((i) => {
                                    subStatus.push(i.tagId1);
                                    subStatus.push(i.tagId2);
                                });

                                wstatusMap = wstatusMap.filter((s) => subStatus.indexOf(s.ID) >= 0);
                            }
                            defaultData.workflow.push(
                                Object.assign({}, columns[0], {
                                    primaryText: w.UIname,
                                    statusMap: wstatusMap,
                                    pageId: w.ID,
                                    listPageId: defaultData.listpage[0].ID,
                                    pageType: w.pageType
                                })
                            );
                        }
                    }
                }
            }
        }
    } else if (data.column) {
        defaultData = data.column;
    }

    return {
        page: pageInfo.page || { ID: pageId, pageProperty: {} },
        subPages: pageInfo.subPages || [],
        columns: defaultData
    };
};
