<Query Kind="Program">
  <Reference Relative="..\BIZSAAS.COM.dll">E:\dll\shop\BIZSAAS.COM.dll</Reference>
  <Reference Relative="..\mvcx.dll">E:\dll\shop\mvcx.dll</Reference>
  <Reference Relative="..\Newtonsoft.Json.dll">E:\dll\shop\Newtonsoft.Json.dll</Reference>
  <Reference>&lt;RuntimeDirectory&gt;\System.Drawing.dll</Reference>
  <Reference>&lt;RuntimeDirectory&gt;\System.Net.dll</Reference>
  <Reference Relative="..\System.Web.Mvc.dll">E:\dll\shop\System.Web.Mvc.dll</Reference>
  <Namespace>BIZSAAS.COM</Namespace>
  <Namespace>mvcx</Namespace>
  <Namespace>Newtonsoft.Json</Namespace>
  <Namespace>Newtonsoft.Json.Linq</Namespace>
  <Namespace>Newtonsoft.Json.Serialization</Namespace>
  <Namespace>System.Drawing</Namespace>
  <Namespace>System.Drawing.Imaging</Namespace>
  <Namespace>System.Net</Namespace>
  <Namespace>System.Web.Mvc</Namespace>
</Query>

void Main(string[] args)
{
  
	var db_conn = string.Empty;	
	if (args==null) return;
	var p = args[0];
	if (string.IsNullOrWhiteSpace(p)) return;
	p=p.Replace("~~",@"""").Replace("^"," ");	
	 
	
	using(StreamReader sr =new StreamReader("db.txt")){
		db_conn = sr.ReadToEnd();
	}
	tool.LOG(p);
	var configType = 0;
	JObject json = (JObject)JsonConvert.DeserializeObject(p);
	tool.LOG(json);
	foreach (var pj in json.Properties())
	{
       if (pj.Name=="configType") {  int.TryParse(pj.Value.ToString(),out configType) ; }
	}


	var dt = BIZSAAS.COM.SQLWrap.DataProvider.GetDataTable("select * from CooConfiguration",db_conn);
	var dlist = (from c in dt.AsEnumerable()
	            select new {
					 configuration_key =  c.Field<string>("configuration_key"),
					 configuration_value = c.Field<string>("configuration_value")
				}).ToList();	
	
	//serverPath
	var serverPath = dlist.FirstOrDefault(x=>x.configuration_key=="serverPath");
	var nodePath =  dlist.FirstOrDefault(x=>x.configuration_key=="nodePath");
	
	tool.LOG(nodePath);
	tool.LOG(p);
	tool.LOG(configType);
 
	
	switch(configType)
	{
		case 129:
		 if (serverPath!=null)
		 updateWebConfig(serverPath.configuration_value,p);
		break;
		case 130:
		 if (serverPath!=null)
		 updateJsConfig(serverPath.configuration_value,p);
		break;
		case 131:
		 if (nodePath!=null)
		 {
		 	updateNodeBaseConfig(nodePath.configuration_value,p);
		 }
		break;
	    case 132:
		if (nodePath!=null) updateNodeExtConfig(nodePath.configuration_value,p);
		break;
	    case 134:
		if (nodePath!=null)   updateNodeResource(nodePath.configuration_value,p);
		break;
		
	}
	 
	 
	 
}



protected void updateNodeResource(string path ,string json)
{

    tool.LOG(json);

	JObject fJson = (JObject)JsonConvert.DeserializeObject(json);
	JObject flatJson = (JObject)fJson.Properties().FirstOrDefault(x => x.Name == "json").Value;
    
	var urlObj = flatJson.Properties().FirstOrDefault(x=>x.Name=="url");
	var pathObj  = flatJson.Properties().FirstOrDefault(x=>x.Name=="path");
	var nameObj =  flatJson.Properties().FirstOrDefault(x=>x.Name=="Filename");
	var keyObj =  flatJson.Properties().FirstOrDefault(x=>x.Name=="key");
	
	tool.LOG("aaa");
	
	if (urlObj!=null && pathObj!=null && nameObj!=null)
	{
		var dest = path + pathObj.Value.ToString() + @"\" + nameObj.Value.ToString();
		if (keyObj!=null && keyObj.Value.ToString()=="appIcon")
		{
			dest = path + pathObj.Value.ToString() + @"\ic_launcher.png"  ;
		}

		if (keyObj != null && keyObj.Value.ToString() == "splashScreen")
		{
			dest = path + pathObj.Value.ToString() + @"\splash.png";
		}


		if (File.Exists(dest))
		{
			File.Delete(dest);
		}
		
		tool.LOG(dest);

		using (var client = new WebClient())
		{
			client.DownloadFile(urlObj.Value.ToString(), dest);
		}


		if (keyObj != null && keyObj.Value.ToString() == "appIcon")
		{
			updateAppIcon(path,json);
		}


		if (keyObj != null && keyObj.Value.ToString() == "splashScreen")
		{
			
			updateSplashScreen(path, json);
		 
		}

	}
    

	 
}



protected JObject updateFlatJson(JObject flatJson, JObject jobj){

	
	foreach(var fj in flatJson.Properties())
	{
	   tool.LOG(fj);
		
		var parts = fj.Name.Split('.');
		tool.LOG(parts);
		var currentJobj = jobj;
		
		for(int i=0;i<parts.Length;i++)
		{
	        var cj = currentJobj.Properties().FirstOrDefault(x=>x.Name==parts[i]);
		    if (cj!=null)
			{
				
				if (i==parts.Length-1){
					cj.Value = fj.Value;
				}
				else{
					currentJobj = (JObject)cj.Value;
				}
			}	
		}
	}
	
	return jobj;
}


protected void updateNodeExtConfig(string path,string json)
{
	var f = path + @"config\config.js";
	var configContent = string.Empty;

	if (File.Exists(f))
	{


		using (StreamReader sr = new StreamReader(f))
		{
			configContent = sr.ReadToEnd();
		}

		var configJson = Regex.Match(configContent, @"(?<=defaultConfig\s*?=\s*?)\{(?>[^\{\}]+|\{(?<Open>)|\}(?<-Open>))*(?(Open)(?!))\}").Value;
		
		
		configJson = Regex.Replace(configJson,@"(baseConfig.[a-zA-Z]+)",@"""${1}""");
		configJson = Regex.Replace(configJson,@"(require\([^\(\)]+\))",@"""${1}""");



		JObject fJson = (JObject)JsonConvert.DeserializeObject(json);
		JObject flatJson = (JObject)fJson.Properties().FirstOrDefault(x => x.Name == "json").Value;


       tool.LOG("444");

		var jobj = (JObject)JsonConvert.DeserializeObject(configJson);


		tool.LOG("333");

		var j2 = updateFlatJson(flatJson, jobj);
		configJson = JsonConvert.SerializeObject(j2);


		configJson = Regex.Replace(configJson, @"(""baseConfig.[a-zA-Z]+"")", delegate (Match match)
					   {
						   return match.Value.Replace(@"""","");
					   });
		configJson = Regex.Replace(configJson, @"(""require\([^\(\)]+\)"")", delegate (Match match)
					   {
						   return match.Value.Replace(@"""", "");
					   });


		configContent = Regex.Replace(configContent, @"(?<=defaultConfig\s*?=\s*?)\{(?>[^\{\}]+|\{(?<Open>)|\}(?<-Open>))*(?(Open)(?!))\}", delegate (Match match)
					   {
						   return configJson;
					   });


		using (StreamWriter sw = new StreamWriter(f, false, Encoding.UTF8))
		{
			sw.Write(configContent);
		}

	}

}



protected void updateNodeBaseConfig(string path, string json)
{
	var f = path + @"config.json";
    var configContent = "";
	if (File.Exists(f))
	{


		using (StreamReader sr = new StreamReader(f))
		{
			configContent = sr.ReadToEnd();
		}

	 

		JObject fJson = (JObject)JsonConvert.DeserializeObject(json);
		JObject flatJson = (JObject)fJson.Properties().FirstOrDefault(x => x.Name == "json").Value;

      
       JObject jobj =null;
       
	   try
	   {
	     jobj = (JObject)JsonConvert.DeserializeObject(configContent);
	   }
	   catch(Exception eee)
	   {
	      tool.LOG(eee);
	   }
		 


		var j2 = updateFlatJson(flatJson, jobj);
		configContent = JsonConvert.SerializeObject(j2);
		
		
		tool.LOG(f);
		
		try
		{
				var mutexKey2 = MutexExample.GetFilePathMutexKey(f);
	MutexExample.MutexExec(mutexKey2, () =>
						{
						tool.LOG("write");
							using (var writer = new StreamWriter(f, false, Encoding.UTF8))
							{
								writer.Write(configContent);
							}
						});
		
		}
		catch(Exception eee)
		{
		   tool.LOG(eee);
		}
		


 

       tool.LOG("end");

	}

}


protected void updateJsConfig(string path,string json)
{
	var f = path + @"web\cooConfig.js";
	var configContent = string.Empty;
	 tool.LOG(f);
	if (File.Exists(f))
	{
	  

		using (StreamReader sr = new StreamReader(f))
		{
			configContent = sr.ReadToEnd();
		}
		
		var  configJson = Regex.Match(configContent,@"\{(?>[^\{\}]+|\{(?<Open>)|\}(?<-Open>))*(?(Open)(?!))\}").Value;
		
		

		JObject fJson = (JObject)JsonConvert.DeserializeObject(json);
		JObject flatJson = (JObject)fJson.Properties().FirstOrDefault(x=>x.Name=="json").Value;
		
	 
	 
	 
	    var jobj =(JObject)JsonConvert.DeserializeObject(configJson);

		
		tool.LOG("cooConfig.js");
		tool.LOG(flatJson);
		 
	    var j2 =updateFlatJson(flatJson,jobj);
		configJson = JsonConvert.SerializeObject(j2);
		
		
		tool.LOG(configJson);

		configContent = Regex.Replace(configContent, @"\{(?>[^\{\}]+|\{(?<Open>)|\}(?<-Open>))*(?(Open)(?!))\}", delegate (Match match)
					   {
						    return  configJson;
					   });


		using (StreamWriter sw = new StreamWriter(f, false, Encoding.UTF8))
		{
			sw.Write(configContent);
		}

	}


}


protected void updateWebConfig(string path, string json)
{
	var f = path + "web.config";
	var configContent = string.Empty;
	if (File.Exists(f))
	{

		using (StreamReader sr = new StreamReader(f))
		{
			configContent = sr.ReadToEnd();
		}
		   tool.LOG(json);

		JObject j = (JObject)JsonConvert.DeserializeObject(json);
		foreach (var pj in j.Properties())
		{
			if (pj.Name=="json")
			{
				foreach(var pj2 in ((JObject)pj.Value).Properties())
				{
				   tool.LOG(pj2.Name);
					if (Regex.IsMatch(pj2.Name, @"^(localUser|anonymousUser|debug)$"))
					{
						configContent = Regex.Replace(configContent, @"<add\s*?key=""" + pj2.Name + @"""\s*?value=""([a-z0-9A-Z]+)""\s*?\/>", delegate (Match match)
							 {
								 var nkv = string.Format(@"<add key=""{0}"" value=""{1}"" />", pj2.Name, pj2.Value.ToString());
								 return nkv;
							 });
					}
				}
			}
		}

		using (StreamWriter sw = new StreamWriter(f, false, Encoding.UTF8))
		{
			sw.Write(configContent);
		}

	}
}



protected void updateSplashScreen(string path,string json)
{

	JObject fJson = (JObject)JsonConvert.DeserializeObject(json);
	JObject flatJson = (JObject)fJson.Properties().FirstOrDefault(x => x.Name == "json").Value;

	var urlObj = flatJson.Properties().FirstOrDefault(x => x.Name == "url");
	var pathObj = flatJson.Properties().FirstOrDefault(x => x.Name == "path");
	//var nameObj = flatJson.Properties().FirstOrDefault(x => x.Name == "Filename");



	if (urlObj == null || pathObj == null)
	{
		return;

	}

	var dest = path + pathObj.Value.ToString() + @"\splash.png";
	var savePath = path + pathObj.Value.ToString() + @"\";

	using (Stream BitmapStream = System.IO.File.Open(dest, System.IO.FileMode.Open))
	{
		Image img = Image.FromStream(BitmapStream);
		ImageCompress imgCompress = ImageCompress.GetImageCompressObject;
		imgCompress.GetImage = new Bitmap(img);


		imgCompress.Height = 621;
		imgCompress.Width = 1104;
		imgCompress.Save("splash.png", savePath + @"drawable-hdpi\");

		imgCompress.Height = 414;
		imgCompress.Width = 736;
		imgCompress.Save("splash.png", savePath + @"drawable-mdpi\");


		imgCompress.Height = 828;
		imgCompress.Width = 1472;
		imgCompress.Save("splash.png", savePath + @"drawable-xhdpi\");


		imgCompress.Height = 1242;
		imgCompress.Width = 2208;
		imgCompress.Save("splash.png", savePath + @"drawable-xxhdpi\");


		imgCompress.Height = 1656;
		imgCompress.Width = 2944;
		imgCompress.Save("splash.png", savePath + @"drawable-xxxhdpi\");


		//		imgCompress.Height = 512;
		//		imgCompress.Width = 512;
		//		imgCompress.Save("ic_launcher.png", savePath);





		//mipmap-xxxhdpi
		//...do whatever
	}


}


protected void updateAppIcon(string path, string json)
{
	JObject fJson = (JObject)JsonConvert.DeserializeObject(json);
	JObject flatJson = (JObject)fJson.Properties().FirstOrDefault(x => x.Name == "json").Value;

	var urlObj = flatJson.Properties().FirstOrDefault(x => x.Name == "url");
	var pathObj = flatJson.Properties().FirstOrDefault(x => x.Name == "path");
	//var nameObj = flatJson.Properties().FirstOrDefault(x => x.Name == "Filename");

   tool.LOG(urlObj);
   tool.LOG(pathObj);
	if (urlObj == null ||  pathObj ==null )
	{
	    return ;

	}

    var dest = path + pathObj.Value.ToString() + @"\ic_launcher.png"  ;
	var savePath = path + pathObj.Value.ToString() + @"\";
	
	tool.LOG(dest);
	
	
	try
	{
	   	using (Stream BitmapStream = System.IO.File.Open(dest, System.IO.FileMode.Open))
		{
			Image img = Image.FromStream(BitmapStream);
			ImageCompress imgCompress = ImageCompress.GetImageCompressObject;
			imgCompress.GetImage = new Bitmap(img);
	
	
			imgCompress.Height = 72;
			imgCompress.Width = 72;
			imgCompress.Save("ic_launcher.png", savePath + @"mipmap-hdpi\");
	
			imgCompress.Height = 48;
			imgCompress.Width = 48;
			imgCompress.Save("ic_launcher.png", savePath + @"mipmap-mdpi\");
	
	
			imgCompress.Height = 96;
			imgCompress.Width = 96;
			imgCompress.Save("ic_launcher.png", savePath + @"mipmap-xhdpi\");
	
	
			imgCompress.Height = 144;
			imgCompress.Width = 144;
			imgCompress.Save("ic_launcher.png", savePath + @"mipmap-xxhdpi\");
	
	
			imgCompress.Height = 192;
			imgCompress.Width = 192;
			imgCompress.Save("ic_launcher.png", savePath + @"mipmap-xxxhdpi\");
	
	
	//		imgCompress.Height = 512;
	//		imgCompress.Width = 512;
	//		imgCompress.Save("ic_launcher.png", savePath);
	
	
	
	
	
			//mipmap-xxxhdpi
			//...do whatever
		}
	
	   
	
	}catch(Exception ee)
	{
	   tool.LOG(ee);
	}

	




}




/// <summary>
/// This class is used to get the constants
/// </summary>
public class CommonConstant
{
	public const string JPEG = ".jpeg";
	public const string PNG = ".png";
	public const string JPG = ".jpg";
	public const string BTM = ".btm";
}





/// <summary>
/// This class is used to compress the image to
/// provided size
/// </summary>
public class ImageCompress
{
	#region[PrivateData]
	private static volatile ImageCompress imageCompress;
	private Bitmap bitmap;
	private int width;
	private int height;
	private Image img;
	#endregion[Privatedata]

	#region[Constructor]
	/// <summary>
	/// It is used to restrict to create the instance of the      ImageCompress
	/// </summary>
	private ImageCompress()
	{
	}
	#endregion[Constructor]

	#region[Poperties]
	/// <summary>
	/// Gets ImageCompress object
	/// </summary>
	public static ImageCompress GetImageCompressObject
	{
		get
		{
			if (imageCompress == null)
			{
				imageCompress = new ImageCompress();
			}
			return imageCompress;
		}
	}

	/// <summary>
	/// Gets or sets Width
	/// </summary>
	public int Height
	{
		get { return height; }
		set { height = value; }
	}

	/// <summary>
	/// Gets or sets Width
	/// </summary>
	public int Width
	{
		get { return width; }
		set { width = value; }
	}

	/// <summary>
	/// Gets or sets Image
	/// </summary>
	public Bitmap GetImage
	{
		get { return bitmap; }
		set { bitmap = value; }
	}
	#endregion[Poperties]

	#region[PublicFunction]
	/// <summary>
	/// This function is used to save the image
	/// </summary>
	/// <param name="fileName"></param>
	/// <param name="path"></param>
	public void Save(string fileName, string path)
	{
		if (ISValidFileType(fileName))
		{
			string pathaname = path + @"\" + fileName;
			save(pathaname, 100);
		}
	}
	#endregion[PublicFunction]

	#region[PrivateData]
	/// <summary>
	/// This function is use to compress the image to
	/// predefine size
	/// </summary>
	/// <returns>return bitmap in compress size</returns>
	private Image CompressImage()
	{
		if (GetImage != null)
		{
			Width = (Width == 0) ? GetImage.Width : Width;
			Height = (Height == 0) ? GetImage.Height : Height;
			Bitmap newBitmap = new Bitmap(Width, Height, PixelFormat.Format24bppRgb);
			newBitmap.SetResolution(96.0F, 96.0F);


			bitmap.MakeTransparent(System.Drawing.Color.White);
			newBitmap = bitmap;

			return newBitmap.GetThumbnailImage(Width, Height, null, IntPtr.Zero);
		}
		else
		{
			throw new Exception("Please provide bitmap");
		}
	}

	/// <summary>
	/// This function is used to check the file Type
	/// </summary>
	/// <param name="fileName">String data type:contain the file name</param>
	/// <returns>true or false on the file extention</returns>
	private bool ISValidFileType(string fileName)
	{
		bool isValidExt = false;
		string fileExt = Path.GetExtension(fileName);
		switch (fileExt.ToLower())
		{
			case CommonConstant.JPEG:
			case CommonConstant.BTM:
			case CommonConstant.JPG:
			case CommonConstant.PNG:
				isValidExt = true;
				break;
		}
		return isValidExt;
	}

	/// <summary>
	/// This function is used to get the imageCode info
	/// on the basis of mimeType
	/// </summary>
	/// <param name="mimeType">string data type</param>
	/// <returns>ImageCodecInfo data type</returns>
	private ImageCodecInfo GetImageCoeInfo(string mimeType)
	{
		ImageCodecInfo[] codes = ImageCodecInfo.GetImageEncoders();
		for (int i = 0; i < codes.Length; i++)
		{
			if (codes[i].MimeType == mimeType)
			{
				return codes[i];
			}
		}
		return null;
	}

	/// <summary>
	/// this function is used to save the image into a
	/// given path
	/// </summary>
	/// <param name="path">string data type</param>
	/// <param name="quality">int data type</param>
	private void save(string path, int quality)
	{
		img = CompressImage();
		////Setting the quality of the picture
		EncoderParameter qualityParam =
			new EncoderParameter(System.Drawing.Imaging.Encoder.Quality, quality);
		////Seting the format to save
		ImageCodecInfo imageCodec = GetImageCoeInfo("image/png");
		////Used to contain the poarameters of the quality
		EncoderParameters parameters = new EncoderParameters(1);
		parameters.Param[0] = qualityParam;

		var f = Path.GetDirectoryName(path);
		if (!Directory.Exists(f))
		{
			Directory.CreateDirectory(f);
		}

		////Used to save the image to a  given path
		img.Save(path, imageCodec, parameters);
	}
	#endregion[PrivateData]
}


// Define other methods and classes here