<Query Kind="Program">
  <Reference>I:\plugin\bizPlugin\SQLWrap\bin\Release\BIZSAAS.COM.dll</Reference>
  <Reference>I:\webapp\center\linq\lib\CooWork.Core.dll</Reference>
  <Reference>G:\f\project\CooWorkNew\CooWork\bin\CooWork.Data.dll</Reference>
  <Reference>G:\f\project\CooWorkNew\CooWork\bin\CooWork.Distributed.CacheDTO.dll</Reference>
  <Reference>G:\f\project\CooWorkNew\CooWork\bin\CooWork.WcfCommon.dll</Reference>
  <Reference>I:\webapp\center\linq\lib\mvcx.dll</Reference>
  <Reference>I:\plugin\bizPlugin\SQLWrap\bin\Release\Newtonsoft.Json.dll</Reference>
  <Reference>&lt;RuntimeDirectory&gt;\System.Net.dll</Reference>
  <Reference>&lt;RuntimeDirectory&gt;\System.Security.dll</Reference>
  <Namespace>CooWork.Core</Namespace>
  <Namespace>CooWork.Data</Namespace>
  <Namespace>CooWork.Data.Mapping</Namespace>
  <Namespace>CooWork.Distributed.CacheDTO</Namespace>
  <Namespace>CooWork.WcfCommon</Namespace>
  <Namespace>CooWork.WcfCommon.DTO</Namespace>
  <Namespace>mvcx</Namespace>
  <Namespace>Newtonsoft.Json</Namespace>
  <Namespace>Newtonsoft.Json.Converters</Namespace>
  <Namespace>Newtonsoft.Json.Linq</Namespace>
  <Namespace>Newtonsoft.Json.Schema</Namespace>
  <Namespace>Newtonsoft.Json.Serialization</Namespace>
  <Namespace>System.Net</Namespace>
</Query>

void Main()
{
	
	 
	 
	 
 
}

 



public class  SHOP
{
	
	 //{"companyId":1000,"cid":11,"id":77,"lsc":[],"iindex":1,"isize":10,"url":"https://center.mvcx.net/list/ajxlist2"}
	   public static ReturnWrap createModule(string s,string db_conn)
	   {
	   	   var ret = new ReturnWrap();
		   var sobj = (JObject)JsonConvert.DeserializeObject(s);
		   var list= new List<ComboBoxPairs>();
		   var itemId =0; 
		   var pageId =0;
		//jsonStr
		foreach (var p in sobj.Properties())
		{
			if (p.Name == "jsonStr")
			{
				list = JsonConvert.DeserializeObject<List<ComboBoxPairs>>(p.Value.ToString());
			}
			if (p.Name == "itemId")
			{
				itemId = Convert.ToInt32(p.Value.ToString());
			}
			if (p.Name == "pageId"){
				pageId = Convert.ToInt32(p.Value.ToString());
			}
		}
		
		if (pageId==0 ) return ret;

		int[] intCols = {  261,435,363, 368, 439, 389, 395, 405, 414, 415, 418, 428 ,469};//hardcoding
		int[] guidCols = { 372,431  };//hardcoding


		if (itemId == 0)
		{


			var scriptBase = new StringBuilder();
			var scriptValues = new StringBuilder();
			scriptBase.AppendFormat(" insert into CooWork_{0} (", pageId);


			var dupeList = new List<string>();
			var paramx = new List<SqlParameter>();

			foreach (var a in list)
			{
				if (dupeList.Contains(a._Key) || string.IsNullOrWhiteSpace(a._Value)) continue;
				if (dupeList.Count != 0)
				{
					scriptBase.Append(",");
					scriptValues.Append(",");
				}
				dupeList.Add(a._Key);


				scriptBase.AppendFormat("{0}", a._Key.Replace("_", ""));
				scriptValues.AppendFormat("@{0}", a._Key.Replace("_", ""));

				if (intCols.Contains(Convert.ToInt32(Regex.Replace(a._Key, @"\D", ""))))
				{
					paramx.Add(new SqlParameter(string.Format("@{0}", a._Key.Replace("_", "")), SqlDbType.Int, 32, ParameterDirection.Input, true, 0, 0, string.Empty, DataRowVersion.Current, a._Value == null ? DBNull.Value : (object)a._Value));

				}
				else if (guidCols.Contains(Convert.ToInt32(Regex.Replace(a._Key, @"\D", ""))))
				{

					paramx.Add(new SqlParameter(string.Format("@{0}", a._Key.Replace("_", "")), SqlDbType.UniqueIdentifier, 32, ParameterDirection.Input, true, 0, 0, string.Empty, DataRowVersion.Current, a._Value == null ? DBNull.Value : (object)a._Value));
				}
				else
				{

					paramx.Add(new SqlParameter(string.Format("@{0}", a._Key.Replace("_", "")), SqlDbType.NVarChar, a._Value.Length, ParameterDirection.Input, true, 0, 0, string.Empty, DataRowVersion.Current, (object)a._Value));
				}

			}

			scriptBase.AppendFormat(",server_identity");
			scriptValues.AppendFormat(",@server_identity");
			paramx.Add(new SqlParameter("@server_identity", SqlDbType.UniqueIdentifier, 32, ParameterDirection.Input, true, 0, 0, string.Empty, DataRowVersion.Current, Guid.NewGuid()));


			scriptBase.AppendFormat(",status) values({0},1) SELECT @@identity", scriptValues.ToString());

			DataSet ds = BIZSAAS.COM.SQLWrap.DataProvider.GetDataSet(scriptBase.ToString(),db_conn, paramx.ToArray());

			if (ds.Tables.Count > 0)
			{

				ret.data = Convert.ToInt32(ds.Tables[0].Rows[0][0]);
				ret.returnCode = "000000";
			}

		}
		else{

			StringBuilder updateScript = new StringBuilder();
			var dupeList = new List<string>();
			var paramx = new List<SqlParameter>();

			foreach (var a in list)
			{
				if (dupeList.Contains(a._Key) || string.IsNullOrWhiteSpace(a._Value)) continue;		 
				dupeList.Add(a._Key);

                updateScript.AppendFormat(",c{0} = @c{0}", Regex.Replace(a._Key, @"\D", ""));
				if (intCols.Contains(Convert.ToInt32(Regex.Replace(a._Key, @"\D", ""))))
				{
					paramx.Add(new SqlParameter(string.Format("@{0}", a._Key.Replace("_", "")), SqlDbType.Int, 32, ParameterDirection.Input, true, 0, 0, string.Empty, DataRowVersion.Current, a._Value == null ? DBNull.Value : (object)a._Value));

				}
				else if (guidCols.Contains(Convert.ToInt32(Regex.Replace(a._Key, @"\D", ""))))
				{

					paramx.Add(new SqlParameter(string.Format("@{0}", a._Key.Replace("_", "")), SqlDbType.UniqueIdentifier, 32, ParameterDirection.Input, true, 0, 0, string.Empty, DataRowVersion.Current, a._Value == null ? DBNull.Value : (object)a._Value));
				}
				else
				{

					paramx.Add(new SqlParameter(string.Format("@{0}", a._Key.Replace("_", "")), SqlDbType.NVarChar, a._Value.Length, ParameterDirection.Input, true, 0, 0, string.Empty, DataRowVersion.Current, (object)a._Value));
				}

			}

			var sqlstring = string.Empty;

			sqlstring = @" update [dbo].[CooWork_" + pageId + @"] set " + updateScript.ToString().Trim(',') + " where ID = " + itemId;


			if (updateScript.ToString().Length > 3)
			{
				BIZSAAS.COM.SQLWrap.DataProvider.ExecuteSql(sqlstring, db_conn, paramx.ToArray());
				ret.data = itemId;
			 	ret.returnCode = "000000";
			}
		}





		return ret;

	}


	public static void deleteModule(string s,string db_conn)
	{
		var sobj = (JObject)JsonConvert.DeserializeObject(s);
		var pageId = 0;
		var itemId = 0;
		foreach (var p in sobj.Properties())
		{
			if (p.Name == "pageId") pageId = Convert.ToInt32(p.Value.ToString());
			if (p.Name == "itemId") itemId = Convert.ToInt32(p.Value.ToString());

		}
		if (pageId == 0 || itemId == 0) return  ;

		var sql = string.Format(" delete  from CooWork_{0} where ID = {1}", pageId, itemId);

		BIZSAAS.COM.SQLWrap.DataProvider.ExecuteNonQuery(sql, db_conn);

		return ;

	}

   public static DataTable viewModule(string s,string db_conn){
   	   var sobj = (JObject)JsonConvert.DeserializeObject(s);	
	   var pageId =0;
		var itemId = 0;
		foreach (var p in sobj.Properties())
		{			 
			if (p.Name == "pageId") pageId = Convert.ToInt32(p.Value.ToString());
			if (p.Name == "itemId") itemId = Convert.ToInt32(p.Value.ToString());	
			
		}
		if (pageId==0 ||itemId ==0) return new DataTable();
		
		var sql = string.Format( " select top 1 * from CooWork_{0} where ID = {1}",pageId,itemId); 
		
        var dt = BIZSAAS.COM.SQLWrap.DataProvider.GetDataTable(sql,db_conn);
		
		return dt;

	}


	public static DynamicPage3 listModule(string s, string db_conn)
	   {
	   	    var ret = string.Empty;
			var sobj = (JObject)JsonConvert.DeserializeObject(s);	
			var lsc = new List<SearchCondition>();
			var iindex = 1;
			var isize = 10;
			var pageId = 0;
			foreach (var p in sobj.Properties())
			{
				if (p.Name == "lsc")
				{
				   lsc = JsonConvert.DeserializeObject<List<SearchCondition>>(p.Value.ToString());				 
				}
				if (p.Name == "iindex")  iindex= Convert.ToInt32(p.Value.ToString());
				if (p.Name == "isize" ) isize = Convert.ToInt32(p.Value.ToString());
				if (p.Name == "id" ) pageId = Convert.ToInt32(p.Value.ToString());
			}
			
			//ROW_NUMBER() OVER ( ORDER BY " + overColSTR + " ) AS RowNum,
			
			var partialSql = @"select  ROW_NUMBER() OVER ( ORDER BY  ID ) AS RowNum,  *   from  CooWork_"+ pageId + @"     ";
			
			if (pageId==100037){
				partialSql = @"select  ROW_NUMBER() OVER ( ORDER BY aa.ID ) AS RowNum, aa.*,bb.filepath   from  CooWork_"+ pageId + @"  aa left join Attachment bb on aa.c370= bb.att_identity  " ;
			}
			
			var sql = @"
			select * from ( 			" + partialSql;
			var whereStr = " where 1 = 1 and status>0  ";
			var paramx = new List<SqlParameter>();
			
			foreach(var sc in lsc){
				switch(sc.pTypeId){
					
				  case 2:
				  case 3:
				      whereStr += string.Format(@" and c{0} = @c{0}", sc.patternId);
					  paramx.Add( new SqlParameter(string.Format("@c{0}",sc.patternId), SqlDbType.Int, 32, ParameterDirection.Input, true, 0, 0, string.Empty, DataRowVersion.Current, sc.val1 ?? DBNull.Value));
				  break;
					
				  case 5:
				  case 7:
					whereStr += string.Format(@" and c{0} like  @c{0}", sc.patternId);
					paramx.Add( new SqlParameter(string.Format("@c{0}", sc.patternId), SqlDbType.NVarChar, 4000, ParameterDirection.Input, true, 0, 0, string.Empty, DataRowVersion.Current, sc.val1!=null?(object)("%" + sc.val1 + "%"):DBNull.Value));
 
					break;
					
					
				}				
			}
			
			sql += whereStr +  " ) as zz where RowNum>" + ((iindex-1)*isize) + " and RowNum<=" + (iindex * isize);
			
			sql += "select count(*) from  CooWork_"+ pageId +   whereStr;
			
			var dt = BIZSAAS.COM.SQLWrap.DataProvider.GetDataSet(sql,db_conn,paramx.ToArray());
			
			
			var dp = new DynamicPage3();
			dp.itemCount = Convert.ToInt32(dt.Tables[1].Rows[0][0]);
			dp.listItems = dt.Tables[0];
			



	    	return  dp;
	   }

	



		public static string  extractBackend(DataSet ds ,string basePath)
		{

			var args = new List<object>();	 

			//
			//tables
			var tbs = (from c in ds.Tables[0].AsEnumerable()
					   select new CooCategoryDTO
					   {

						   categoryName = c.Field<string>("c263"),
						   eName = c.Field<string>("c264") + "_" + c.Field<Int64>("ID").ToString() + "_" + c.Field<string>("server_identity").ToString(),
						   property = c.Field<string>("c265"),
						   cOrder = (int?)c.Field<Int64?>("c267"),
						   status = c.Field<bool?>("c268")

					   }).ToList();
			args.Add(tbs);


			var columns = (from c in ds.Tables[1].AsEnumerable()
						   select new CooItemPatternDTO
						   {

							   categoryId = mapCategoryId(c.Field<string>("c281"), tbs),
							   eName = c.Field<string>("c275") + "_" + c.Field<Int64>("ID").ToString() + "_" + c.Field<string>("server_identity").ToString(),
							   isUnique = c.Field<bool?>("c279"),
							   pName = c.Field<string>("c274"),
							   property = c.Field<string>("c280"),
							   pTypeId = mapPTypeId(c.Field<Int64?>("c276")),
							   required = c.Field<bool?>("c278"),
							   validator = c.Field<string>("c277")

						   }).ToList();
			args.Add(columns);



			var joins = (from c in ds.Tables[2].AsEnumerable()
						 select new CooViewJoinDTO
						 {

							 baseId = (int?)c.Field<Int64?>("c440"),
							 categoryId = (int?)c.Field<Int64?>("c441"),
							 joinCategoryId = (int?)c.Field<Int64?>("c287"),
							 joinPatternId = (int?)c.Field<Int64?>("c288"),
							 viewPatternId = (int?)c.Field<Int64?>("c289"),
							 nRelation = mapRelation(c.Field<Int64?>("c286"))


						 }).ToList();
			args.Add(joins);


			var statGroups = (from c in ds.Tables[3].AsEnumerable()
							  select new CooStatusGroupDTO
							  {
								  ename = c.Field<string>("c442") + "_" + c.Field<Int64>("ID").ToString() + "_" + c.Field<string>("server_identity").ToString(),
								  name = c.Field<string>("c291")
							  }).ToList();
			args.Add(statGroups);


			var status = (from c in ds.Tables[4].AsEnumerable()
						  select new CooStatusDTO
						  {
							  data1 = c.Field<string>("c298"),
							  data2 = c.Field<string>("c299"),
							  parentId = (int?)c.Field<Int64?>("c296"),
							  groupId = mapStatGroup(c.Field<string>("c297"), statGroups),
							  statusName = c.Field<string>("c294"),
							  statusOrder = (int?)c.Field<Int64?>("c295"),
						  }).ToList();
			args.Add(status);


			var statusMap = (from c in ds.Tables[5].AsEnumerable()
							 select new CooStatusMapDTO
							 {
								 depth = (int?)c.Field<Int64?>("c305"),
								 groupId = mapStatGroup(c.Field<string>("c303"), statGroups),
								 init = c.Field<bool?>("c304"),
								 patternId = mapColumn1(c.Field<string>("c301"), columns)


							 }).ToList();

			args.Add(statusMap);




			var pages = (from c in ds.Tables[6].AsEnumerable()
						 select new CooPageDTO
						 {
							 categoryId = mapCategoryId(c.Field<string>("c310"), tbs),
							 dif = (int?)c.Field<Int64?>("c317") == 120 ? 5 : 0,
							 pageName = c.Field<string>("c312") + "_" + c.Field<Int64>("ID").ToString() + "_" + c.Field<string>("server_identity").ToString(),
							 pageOrder = (int?)c.Field<Int64?>("c316"),
							 pageProperty = c.Field<string>("c313"),
							 pageType = (short?)mapPageType(c.Field<Int64?>("c314")),
							 parentId = string.IsNullOrWhiteSpace(c.Field<string>("c315")) ? (int?)null : Convert.ToInt32(c.Field<string>("c315")),
							 UIname = c.Field<string>("c311")

						 }).ToList();
			args.Add(pages);


			var elements = (from c in ds.Tables[7].AsEnumerable()
							select new CooPageElementDTO
							{
								categoryId = mapCategoryId(c.Field<string>("c319"), tbs),
								pageId = mapPageId(c.Field<string>("c320"), pages),
								eorder = (int?)c.Field<Int64?>("c322"),
								patternId = mapColumn1(c.Field<string>("c321"), columns),
								property = c.Field<string>("c323")


							}).ToList();

			args.Add(elements);




			var events = (from c in ds.Tables[8].AsEnumerable()
						  select new CooPageEventDTO
						  {
							  eName = c.Field<string>("c444") + "_" + c.Field<Int64>("ID").ToString() + "_" + c.Field<string>("server_identity").ToString(),
							  eventSource = c.Field<string>("c327"),
							  eventType = mapEventType(c.Field<Int64?>("c326")),
							  pageId = mapPageId(c.Field<string>("c325"), pages),
							  pName = c.Field<string>("c443"),


						  }).ToList();

			args.Add(events);





			var menus = (from c in ds.Tables[9].AsEnumerable()
						 select new CooMenuDTO
						 {
							 eName = c.Field<string>("c333") + "_" + c.Field<Int64>("ID").ToString() + "_" + c.Field<string>("server_identity").ToString(),
							 icon = c.Field<string>("c336"),
							 morder = (int?)c.Field<Int64?>("c335"),
							 parentId = (int?)c.Field<Int64?>("c337"),
							 pName = c.Field<string>("c332"),
							 property = c.Field<string>("c338"),
							 url = c.Field<string>("c334")


						 }).ToList();

			args.Add(menus);



			var triggers = (from c in ds.Tables[10].AsEnumerable()
							select new CooTriggerDTO
							{
								eName = c.Field<string>("c445") + "_" + c.Field<Int64>("ID").ToString() + "_" + c.Field<string>("server_identity").ToString(),
								pName = c.Field<string>("c340"),
								triggerSource = c.Field<string>("c341"),
								triggerType = mapTriggerType(c.Field<Int64?>("c342")),
								categoryId =(int?)c.Field<Int64?>("c452")




							}).ToList();

			args.Add(triggers);
			
			
	        var gid = Guid.NewGuid();
			var path = basePath + @"\" + gid.ToString() + ".txt";

			using (StreamWriter sw = new StreamWriter(path, false, Encoding.UTF8))
			{	
				sw.Write(JsonConvert.SerializeObject(args));
			}
			
			
			return path;


 


		}





	public static int? mapTriggerType(Int64? i)
	{
		int? ret = null;
		switch (i)
		{
			case 124: ret = 1; break;
			case 125: ret = 2; break;
			case 126: ret = 3; break;
			case 127: ret = 4; break;
			case 128: ret = 5; break;
		}

		return ret;
	}




	public static int? mapEventType(Int64? i)
	{
		int? ret = null;
		switch (i)
		{
			case 121: ret = 1; break;
			case 122: ret = 2; break;
			case 123: ret = 3; break;
		}

		return ret;
	}


	public static int? mapRelation(Int64? i)
	{
		int? ret = null;
		switch (i)
		{
			case 90: ret = 1; break;
			case 92: ret = 2; break;
			case 91: ret = 3; break;
			case 93: ret = 4; break;

		}

		return ret;
	}


	public static int? mapStatGroup(string str, List<CooStatusGroupDTO> pats)
	{
		int? ret = null;
		var row = pats.FirstOrDefault(x => x.ename.Contains(str));
		if (row != null)
		{
			ret = Convert.ToInt32(Regex.Match(row.ename, @"(?<=_)\d+(?=_)").Value);
		}
		return ret;
	}

	public static int? mapColumn1(string baseIdStr, List<CooItemPatternDTO> pats)
	{
		int? ret = null;
		var row = pats.FirstOrDefault(x => x.eName.Contains(baseIdStr));
		if (row != null)
		{
			ret = Convert.ToInt32(Regex.Match(row.eName, @"(?<=_)\d+(?=_)").Value);
		}
		return ret;
	}


	public static int? mapPageType(Int64? i)
	{
		int? ret = null;
		switch (i)
		{
			case 94: ret = 2; break;
			case 95: ret = 3; break;
			case 96: ret = 5; break;
			case 97: ret = 6; break;
			case 98: ret = 7; break;
			case 99: ret = 8; break;
			case 100: ret = 9; break;
			case 101: ret = 10; break;
			case 102: ret = 11; break;
			case 103: ret = 12; break;
			case 104: ret = 13; break;
			case 105: ret = 14; break;
			case 106: ret = 15; break;
			case 107: ret = 16; break;
			case 108: ret = 17; break;
			case 109: ret = 18; break;
			case 110: ret = 19; break;
			case 111: ret = 20; break;
			case 112: ret = 22; break;
			case 113: ret = 31; break;
			case 114: ret = 99; break;
			case 115: ret = 100; break;
			case 116: ret = 101; break;
			case 117: ret = 102; break;
			case 118: ret = 103; break;

		}
		return ret;
	}



	public static int? mapPTypeId(Int64? i)
	{
		int? ret = null;
		switch (i)
		{
			case 70: ret = 1; break;
			case 71: ret = 2; break;
			case 72: ret = 3; break;
			case 73: ret = 4; break;
			case 74: ret = 5; break;
			case 75: ret = 6; break;
			case 76: ret = 7; break;
			case 77: ret = 10; break;
			case 78: ret = 11; break;
			case 79: ret = 12; break;
			case 80: ret = 13; break;
			case 81: ret = 16; break;
			case 82: ret = 17; break;
			case 83: ret = 18; break;
			case 84: ret = 19; break;
			case 85: ret = 20; break;
			case 86: ret = 22; break;
			case 87: ret = 23; break;
			case 88: ret = 24; break;
			case 89: ret = 26; break;

		}
		return ret;
	}


	public static int? mapPageId(string s, List<CooPageDTO> pages)
	{
		int? ret = null;
		var row = pages.FirstOrDefault(x => x.pageName.Contains(s));
		if (row != null)
		{
			ret = Convert.ToInt32(Regex.Match(row.pageName, @"(?<=_)\d+(?=_)").Value);
		}
		return ret;
	}


	public static int? mapCategoryId(string s, List<CooCategoryDTO> cates)
	{
		int? ret = null;
		var row = cates.FirstOrDefault(x => x.eName.Contains(s));
		if (row != null)
		{
			ret = Convert.ToInt32(Regex.Match(row.eName, @"(?<=_)\d+(?=_)").Value);
		}
		return ret;
	}


	//frontEndFunction

	public static void extractFrontend(DataSet ds, string db_conn ,string basePath,string serverHeader)
	{

	 
//		var basePath = @"E:\node\yunhaofang\design\mvcx\src";
//		var serverHeader = @"https://file5.mvcx.net/files/";

		var keyConfigTable = ds.Tables[13];
		var functionTable = ds.Tables[14];
		var pageTable = ds.Tables[12];
		var routerTable = ds.Tables[15];
		var themeTable = ds.Tables[16];
		var resourceTable = ds.Tables[17];	 
		
		var moduleTable  =ds.Tables[18];
 

		var tbPage = makePage(pageTable, basePath, db_conn);

		makeKeyConfig(keyConfigTable, basePath);   //src/config.json

		var tbConfig = makeConfig(keyConfigTable, basePath, db_conn);   //config.js

		var tbFunction = makeFunction(functionTable, basePath, db_conn);

		makeRouter(routerTable, basePath);

		makeTheme(themeTable, basePath);

		var tbResource = makeResource(resourceTable, basePath, serverHeader);
		//https://file5.mvcx.net/files/

		var dst = new DataSet();

		dst.Tables.Add(tbPage.Copy());

		dst.Tables.Add(tbConfig.Copy());

		dst.Tables.Add(tbFunction.Copy());

		dst.Tables.Add(routerTable.Copy());

		dst.Tables.Add(themeTable.Copy());

		dst.Tables.Add(tbResource.Copy());
		
		dst.Tables.Add(moduleTable.Copy());

        updateFrontEndCode(dst,db_conn);

	}


	public static  DataTable makePage(DataTable dt, string basePath, string db_conn)
	{


		foreach (DataRow r in dt.Rows)
		{

			var file = basePath + @"\pages\" + r["c362"].ToString() + @"\index.js";
			var content = mapingPage(r["c365"].ToString(), db_conn);

			r["c365"] = content;

			if (File.Exists(file)) continue;

			var folder = Path.GetDirectoryName(file);			 
			if (!Directory.Exists(folder))
			{
				Directory.CreateDirectory(folder);
			}

			var mutexKey = MutexExample.GetFilePathMutexKey(file);

			MutexExample.MutexExec(mutexKey, () =>
			{
				using (var writer = new StreamWriter(file, false, Encoding.UTF8))
				{
					writer.Write(content);
				}
			});
		}

		return dt;

	}

	public static string mapingPage(string content, string db_conn)
	{

		//pageId
		var pageIds = new List<string>();
		var rpageId = new Regex(@"pageId\s*?(:|=)\s*?(\d+)", RegexOptions.IgnoreCase);
		var pageMc = rpageId.Matches(content);
		foreach (Match m in pageMc)
		{
			pageIds.Add(m.Groups[2].Value);
		}

		//patternId
		var patIds = new List<string>();
		var rpatId = new Regex(@"(__c|patternId\s*?[:=]\s*?)(\d+)", RegexOptions.IgnoreCase);
		var patMc = rpatId.Matches(content);
		foreach (Match m in patMc)
		{
			patIds.Add(m.Groups[2].Value);
		}


		//statusId
		var rstatusRow = new Regex(@"[^\n]+\/\/(\[{\s*?groupId[^\]]+\])", RegexOptions.IgnoreCase);
		var statusKv = new List<CooStatusDTO>();

		var mc = rstatusRow.Matches(content);
		foreach (Match m in mc)
		{
			var g1 = m.Groups[1].Value;
			var d = JArray.Parse(g1);
			foreach (dynamic dd in d)
			{
				var gid = (int?)dd.groupId;
				var statusId = (int?)dd.statusId;
				var statusName = (string)dd.statusName;
				var cv = new CooStatusDTO();
				cv.ID = statusId.Value;
				cv.groupId = gid;
				cv.statusName = statusName;
				statusKv.Add(cv);
			}
		}
		string where1 = " and ( 2=1 ";
		foreach (var p in pageIds)
		{
			where1 += string.Format("or  pageName like '%[_]{0}[_]%'  ", p);
		}
		where1 += " )";

		string where2 = " and ( 2=1 ";
		foreach (var p in patIds)
		{
			where2 += string.Format("or  eName like '%[_]{0}[_]%'  ", p);
		}
		where2 += " )";

		string where3 = " and ( 3=1";
		foreach (var p in statusKv)
		{
			where3 += string.Format(" or  (groupId = {0} and statusName ='{1}' ) ", p.groupId, p.statusName);
		}
		where3 += " ) ";


		var sql = string.Format(@"select * from CooPage where  1=1 {0}
	select *  from CooItemPattern where 2=2 {1}
	select *  from CooStatus where 3=3 {2}
	", where1, where2, where3);

		var ds = BIZSAAS.COM.SQLWrap.DataProvider.GetDataSet(sql, db_conn);



		Dictionary<string, string> dpage = new Dictionary<string, string>();
		foreach (DataRow dr in ds.Tables[0].Rows)
		{
			var p1 = Regex.Match(dr["pageName"].ToString(), @"_(\d+)_").Groups[1].Value;
			if (!string.IsNullOrWhiteSpace(p1))
			{
				dpage.Add(p1, dr["ID"].ToString());
			}
		}

		Dictionary<string, string> dpat = new Dictionary<string, string>();
		foreach (DataRow dr in ds.Tables[1].Rows)
		{
			var p1 = Regex.Match(dr["eName"].ToString(), @"_(\d+)_").Groups[1].Value;
			if (!string.IsNullOrWhiteSpace(p1))
			{
				dpat.Add(p1, dr["ID"].ToString());
			}
		}

		var lstat = new List<CooStatusDTO>();

		lstat = (from c in ds.Tables[2].AsEnumerable()
				 select new CooStatusDTO
				 {
					 ID = c.Field<int>("ID"),
					 groupId = c.Field<int?>("groupId"),
					 statusName = c.Field<string>("statusName")
				 }).ToList();


		content = Regex.Replace(content, @"pageId\s*?(:|=)\s*?(\d+)", delegate (Match match)
						  {
						  	  if (dpage.ContainsKey(match.Groups[2].Value)){
							  	return string.Format(@"pageId {0} {1}", match.Groups[1].Value, dpage[match.Groups[2].Value]);
							  }
							  else{
							    tool.LOG("dicPage error "+ match.Groups[2].Value);
							  	return match.Value;
							  }						  	
							  
						  });

		content = Regex.Replace(content, @"(__c|patternId\s*?[:=]\s*?)(\d+)", delegate (Match match)
					   {
					   	   if (dpat.ContainsKey(match.Groups[2].Value)){
						     	return string.Format(@"{0} {1}", match.Groups[1].Value, dpat[match.Groups[2].Value]);
						   }
						   else
						   {
							   tool.LOG("dicPat error " + match.Groups[2].Value);
							   return match.Value;
						   }
						   
					   });


		content = Regex.Replace(content, @"[^\n]+\/\/(\[{\s*?groupId[^\]]+\])", delegate (Match match)
						 {
							 var g1 = match.Groups[1].Value;
							 var d = JArray.Parse(g1);
							 var rx = string.Empty;
							 foreach (dynamic dd in d)
							 {
								 var gid = (int?)dd.groupId;
								 var statusId = (int?)dd.statusId;
								 var statusName = (string)dd.statusName;
								 var nid = lstat.FirstOrDefault(x => x.groupId == gid && x.statusName == statusName).ID;
								 rx = Regex.Replace(match.Value, @" " + statusId + " ", " " + nid + " ");
							 }

							 return match.Value;
						 });






		return content;

	}


	public static void makeKeyConfig(DataTable dt, string basePath)
	{

		var path = basePath += @"\config.json";



		var json = string.Empty;


		var mutexKey = MutexExample.GetFilePathMutexKey(path);
		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var reader = new StreamReader(path, Encoding.UTF8))
			{
				json = reader.ReadToEnd();
			}
		});


		var lkv = new List<KeyValuePair<string, object>>();
		foreach (DataRow dr in dt.Rows)
		{
			if (dr["c439"].ToString() == "41")
			{
				object jobj = null;
				if (dr["c382"].ToString().IsDouble())
				{
					jobj = Convert.ToDecimal(dr["c382"].ToString());
				}
				else if (dr["c382"].ToString().IsInt())
				{
					jobj = Convert.ToInt32(dr["c382"].ToString());
				}
				else
				{
					jobj = dr["c382"].ToString();
				}

				lkv.Add(new KeyValuePair<string, object>(dr["c381"].ToString(), jobj));
			}
		}


		json = replaceJsonFirstLevelProperty(json, lkv);


		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var writer = new StreamWriter(path, false, Encoding.UTF8))
			{
				writer.Write(json);
			}
		});


	}


	public static string replaceJsonFirstLevelProperty(string json, List<KeyValuePair<string, object>> lkv)
	{

		var jobj = (JObject)JsonConvert.DeserializeObject(json);

		foreach (var kv in lkv)
		{

			if (!jobj.Properties().Select(x => x.Name).Contains(kv.Key))
			{

				if (kv.Value.ToString().StartsWith("{"))
				{
					jobj[kv.Key] = JsonConvert.DeserializeObject<JObject>(kv.Value.ToString());
				}
				else if (kv.Value.ToString().StartsWith("["))
				{
					jobj[kv.Key] = JsonConvert.DeserializeObject<JArray>(kv.Value.ToString());
				}
				else
				{
					jobj[kv.Key] = new JValue(kv.Value);
				}

				continue;
			}


			foreach (var p in jobj.Properties())
			{
				if (p.Name == kv.Key)
				{
					var vtype = p.Value.GetType().ToString();
					switch (vtype)
					{
						case "Newtonsoft.Json.Linq.JValue":
							p.Value = new JValue(kv.Value);
							break;
						case "Newtonsoft.Json.Linq.JArray":
							p.Value = JsonConvert.DeserializeObject<JArray>(kv.Value.ToString());

							break;
						case "Newtonsoft.Json.Linq.JObject":
							p.Value = JsonConvert.DeserializeObject<JObject>(kv.Value.ToString());

							break;

					}
				}

			}
		}



		return JsonConvert.SerializeObject(jobj);
	}




	public static DataTable makeConfig(DataTable dt, string basePath, string db_conn)
	{

		var path = basePath += @"\config\config.js";

		var json = string.Empty;

		var mutexKey = MutexExample.GetFilePathMutexKey(path);
		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var reader = new StreamReader(path, Encoding.UTF8))
			{
				json = reader.ReadToEnd();
			}
		});

		var lkv = new List<KeyValuePair<string, object>>();
		var lkvPage = new List<KeyValuePair<string, object>>();

		var mockContent = string.Empty;


		foreach (DataRow dr in dt.Rows)
		{
			if (dr["c439"].ToString() == "44")
			{
				mockContent += string.Format(@"pageId : {0} 
				{1}", dr["c381"].ToString(), dr["c382"].ToString());

			}
			else
			{
				mockContent += string.Format(@"{0}  :
				{1}", dr["c381"].ToString(), dr["c382"].ToString());

			}

		}


		var cppsOriginalList = get_category_page_column_status_list(mockContent);
		var cppsNewList = category_page_column_status_dic(cppsOriginalList, db_conn);

		var dcategory = cppsNewList[0] as Dictionary<string, string>;
		var dpage = cppsNewList[1] as Dictionary<string, string>;
		var dpat = cppsNewList[2] as Dictionary<string, string>;
		var dstatus = cppsNewList[3] as Dictionary<string, string>;


		foreach (DataRow dr in dt.Rows)
		{
			if (dr["c439"].ToString() == "44" || dr["c439"].ToString() == "42" || dr["c439"].ToString() == "43")
			{
				dr["c382"] = mappingContent(cppsNewList, dr["c382"].ToString());

				object jobj = null;
				if (dr["c382"].ToString().IsDouble())
				{
					jobj = Convert.ToDecimal(dr["c382"].ToString());
				}
				else if (dr["c382"].ToString().IsInt())
				{
					jobj = Convert.ToInt32(dr["c382"].ToString());
				}
				else
				{
					jobj = dr["c382"].ToString();
				}

				if (dr["c439"].ToString() == "44")
				{
					if (dpage.ContainsKey(dr["c381"].ToString())){
						dr["c381"] = dpage[dr["c381"].ToString()];
						lkvPage.Add(new KeyValuePair<string, object>(dpage[dr["c381"].ToString()], jobj));
					}		
					
					
				}
				else
				{
					lkv.Add(new KeyValuePair<string, object>(dr["c381"].ToString(), jobj));
				}
			}

		}


		json = Regex.Replace(json, @"baseConfig\.[a-zA-Z0-9]+", delegate (Match match)
				  {					   
					  return @"""" + match.Value + @"""";
				  });


		json = Regex.Replace(json, @"(?<=const\s*?defaultConfig\s*?=\s*?)([\s\S]+)(?=;[\s\n]*?export\s*?const\s*configSetting)", delegate (Match match)
					  {
						  var content = match.Groups[1].Value;
						  JObject jcObj = JsonConvert.DeserializeObject<JObject>(content);
						  var j2 = (JObject)jcObj["router"];
						  var j2Str = replaceJsonFirstLevelProperty(JsonConvert.SerializeObject(j2), lkvPage);
						  lkv.Add(new KeyValuePair<string, object>("router", j2Str));

						  return replaceJsonFirstLevelProperty(content, lkv);
					  });

		json = Regex.Replace(json, @"""(baseConfig\.[a-zA-Z0-9]+)""", delegate (Match match)
			  {
				  return  match.Groups[1].Value;
			  });



		//   const\s*?defaultConfig\s*?=\s*?([\s\S]+);[\s\n]*?export\s*?const\s*configSetting



		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var writer = new StreamWriter(path, false, Encoding.UTF8))
			{
				writer.Write(json);
			}
		});

		return dt;


	}



	public static List<object> get_category_page_column_status_list(string content)
	{
		var ret = new List<object>();


		//pageId
		var pageIds = new List<string>();
		var rpageId = new Regex(@"pageId\s*?(:|=)\s*?(\d+)", RegexOptions.IgnoreCase);
		var rpageId2 = new Regex(@"(\d+)\s*?:\s*?\{", RegexOptions.IgnoreCase);
		var pageMc = rpageId.Matches(content);
		var pageMc2 = rpageId2.Matches(content);
		foreach (Match m in pageMc)
		{
			pageIds.Add(m.Groups[2].Value);
		}
		foreach (Match m in pageMc2)
		{
			pageIds.Add(m.Groups[1].Value);
		}

		//patternId
		var patIds = new List<string>();
		var rpatId = new Regex(@"ID\s*?:\s*?(\d+)");  //大写
		var rpatId2 = new Regex(@"excludes\s*?:\s*?\[([\d,\s]+)\]", RegexOptions.IgnoreCase);
		var rpatId3 = new Regex(@"__c(\d+)", RegexOptions.IgnoreCase);
		var patMc = rpatId.Matches(content);
		var patMc2 = rpatId2.Matches(content);
		var patMc3 = rpatId3.Matches(content);
		foreach (Match m in patMc)
		{
			patIds.Add(m.Groups[1].Value);
		}
		foreach (Match m in patMc2)
		{
			var ags = m.Groups[1].Value.Split(',');
			foreach (var ag in ags)
			{
				patIds.Add(ag.Trim());
			}
		}
		foreach (Match m in patMc3)
		{
			patIds.Add(m.Groups[1].Value);
		}

		//categoryId
		var categoryIds = new List<string>();
		var rcategoryId = new Regex(@"categoryId\s*?:\s*?(\d+)", RegexOptions.IgnoreCase);
		var categoryMc = rcategoryId.Matches(content);
		foreach (Match m in categoryMc)
		{
			categoryIds.Add(m.Groups[1].Value);
		}


		//statusId
		var rstatusRow = new Regex(@"[^\n]+\/\/(\[{\s*?groupId[^\]]+\])", RegexOptions.IgnoreCase);
		var statusKv = new List<CooStatusDTO>();

		var mc = rstatusRow.Matches(content);
		foreach (Match m in mc)
		{
			var g1 = m.Groups[1].Value;
			var d = JArray.Parse(g1);
			foreach (dynamic dd in d)
			{
				var gid = (int?)dd.groupId;
				var statusId = (int?)dd.statusId;
				var statusName = (string)dd.statusName;
				var cv = new CooStatusDTO();
				cv.ID = statusId.Value;
				cv.groupId = gid;
				cv.statusName = statusName;
				statusKv.Add(cv);
			}
		}

		ret.Add(categoryIds);
		ret.Add(pageIds);
		ret.Add(patIds);
		ret.Add(statusKv);

		return ret;
	}


	public static List<object> category_page_column_status_dic(List<object> args, string db_conn)
	{
		var pageIds = args[0] as List<string>;
		var patIds = args[1] as List<string>;
		var categoryIds = args[2] as List<string>;
		var statusKv = args[3] as List<CooStatusDTO>;


		if (pageIds.Count == 0 && patIds.Count == 0 && categoryIds.Count == 0 && statusKv.Count == 0)
		{
			var ret2 = new List<object>();
			ret2.Add(new Dictionary<string, string>());
			ret2.Add(new Dictionary<string, string>());
			ret2.Add(new Dictionary<string, string>());
			ret2.Add(new Dictionary<string, string>());
			return ret2;
		}


		string where1 = " and ( 2=1 ";
		foreach (var p in pageIds)
		{
			where1 += string.Format("or  pageName like '%[_]{0}[_]%'  ", p);
		}
		where1 += " )";

		string where2 = " and ( 2=1 ";
		foreach (var p in patIds)
		{
			where2 += string.Format("or  eName like '%[_]{0}[_]%'  ", p);
		}
		where2 += " )";

		string where3 = " and ( 3=1";
		foreach (var p in categoryIds)
		{
			where3 += string.Format("or  eName like '%[_]{0}[_]%'  ", p);
		}
		where3 += " ) ";


		string where4 = " and ( 4=1";
		foreach (var p in statusKv)
		{
			where4 += string.Format(" or  (groupId = {0} and statusName ='{1}' ) ", p.groupId, p.statusName);
		}
		where4 += " ) ";





		var sql = string.Format(@"select * from CooPage where  1=1 {0}
	select *  from CooItemPattern where 2=2 {1}
	select *  from CooCategory where 3=3 {2}
	select *  from CooStatus where 4=4 {3}
	", where1, where2, where3, where4);

		var ds = BIZSAAS.COM.SQLWrap.DataProvider.GetDataSet(sql, db_conn);


		//tidi



		Dictionary<string, string> dpage = new Dictionary<string, string>();
		foreach (DataRow dr in ds.Tables[0].Rows)
		{
			var p1 = Regex.Match(dr["pageName"].ToString(), @"_(\d+)_").Groups[1].Value;
			if (!string.IsNullOrWhiteSpace(p1))
			{
				dpage.Add(p1, dr["ID"].ToString());
			}
		}

		Dictionary<string, string> dpat = new Dictionary<string, string>();
		foreach (DataRow dr in ds.Tables[1].Rows)
		{
			var p1 = Regex.Match(dr["eName"].ToString(), @"_(\d+)_").Groups[1].Value;
			if (!string.IsNullOrWhiteSpace(p1))
			{
				dpat.Add(p1, dr["ID"].ToString());
			}
		}


		Dictionary<string, string> dcategory = new Dictionary<string, string>();
		foreach (DataRow dr in ds.Tables[2].Rows)
		{
			var p1 = Regex.Match(dr["eName"].ToString(), @"_(\d+)_").Groups[1].Value;
			if (!string.IsNullOrWhiteSpace(p1))
			{
				dcategory.Add(p1, dr["ID"].ToString());
			}
		}


		Dictionary<string, string> dstatus = new Dictionary<string, string>();
		foreach (DataRow dr in ds.Tables[3].Rows)
		{
			var p2 = statusKv.FirstOrDefault(x => x.groupId.ToString() == dr["groupId"].ToString() && x.statusName == dr["statusName"].ToString());
			if (p2 != null)
			{
				dstatus.Add(p2.ID.ToString(), dr["ID"].ToString());
			}
		}




		var ret = new List<object>();
		ret.Add(dcategory);
		ret.Add(dpage);
		ret.Add(dpat);
		ret.Add(dstatus);


		return ret;


	}



	public static string mappingContent(List<object> cppsNewList, string content)
	{

		var dcategory = cppsNewList[0] as Dictionary<string, string>;
		var dpage = cppsNewList[1] as Dictionary<string, string>;
		var dpat = cppsNewList[2] as Dictionary<string, string>;
		var dstatus = cppsNewList[3] as Dictionary<string, string>;

		var rcategoryId = new Regex(@"categoryId\s*?:\s*?(\d+)", RegexOptions.IgnoreCase);

		var rpageId = new Regex(@"pageId\s*?(:|=)\s*?(\d+)", RegexOptions.IgnoreCase);
		var rpageId2 = new Regex(@"(\d+)\s*?:\s*?\{", RegexOptions.IgnoreCase);

		var rpatId = new Regex(@"ID\s*?:\s*?(\d+)");  //大写
		var rpatId2 = new Regex(@"excludes\s*?:\s*?\[([\d,\s]+)\]", RegexOptions.IgnoreCase);
		var rpatId3 = new Regex(@"__c(\d+)", RegexOptions.IgnoreCase);

		var rstatusRow = new Regex(@"[^\n]+\/\/(\[{\s*?groupId[^\]]+\])", RegexOptions.IgnoreCase);

		//categoryId
		content = Regex.Replace(content, @"categoryId\s*?:\s*?(\d+)", delegate (Match match)
					  {  
					  	 if (dcategory.ContainsKey(match.Groups[1].Value)){
						 	 return string.Format(@"categoryId : {0}", dcategory[match.Groups[1].Value]);
						 }
						 else{
						     tool.LOG("dcategory" + match.Groups[1].Value);
						 	 return  match.Value;							 
						 }				
					  	  
						 
					  });

		//pageId
		content = Regex.Replace(content, @"pageId\s*?(:|=)\s*?(\d+)", delegate (Match match)
						  {
						  	 
							  if (dpage.ContainsKey(match.Groups[2].Value)){
							  	 return string.Format(@"pageId {0} {1}", match.Groups[1].Value, dpage[match.Groups[2].Value]);
							  }
							  else{

								  tool.LOG("dpage" + match.Groups[2].Value);
								  return match.Value;
							  } 					  
							  
						  });

		content = Regex.Replace(content, @"(\d+)\s*?:\s*?\{", delegate (Match match)
					  {
						  if (dpage.ContainsKey(match.Groups[1].Value))
						  {
						    	return string.Format(@"{0} : {{", dpage[match.Groups[1].Value]);							 
						  }
						  else
						  {
							  tool.LOG("dpage" + match.Groups[1].Value);
							  return match.Value;
						  }					  
					  });


		//	var rpatId = new Regex(@"ID\s*?:\s*?(\d+)");  //大写
		//	var rpatId2 = new Regex(@"excludes: \[([\d,\s]+)\]", RegexOptions.IgnoreCase);
		//	var rpatId3 = new Regex(@"__c(\d+)", RegexOptions.IgnoreCase);

		content = Regex.Replace(content, @"ID\s*?:\s*?(\d+)", delegate (Match match)
					  {
					  	  if (dpat.ContainsKey(match.Groups[1].Value)){
						  	 return string.Format(@"ID : {0}", dpat[match.Groups[1].Value]);
						  }
						  else
						  {
						  	  tool.LOG("dpat" + match.Groups[1].Value);
							  return match.Value;
						  }					
						 
					  });

		content = Regex.Replace(content, @"excludes\s*?:\s*?\[([\d,\s]+)\]", delegate (Match match)
				  {
				  	  
					
					  var ags = match.Groups[1].Value.Split(',');
					  
					  foreach(var c in ags){
					  	if (!dpat.ContainsKey(c)){
						    tool.LOG("dpat" + c);
							return match.Value;
						}
					  }
					  
					  var ags2 = (from c in ags
								  select dpat[c]).ToList();

					  return string.Format(@"excludes : [{0}]", string.Join(",", ags2));				  
					  
				  });

		content = Regex.Replace(content, @"__c(\d+)", delegate (Match match)
					  {
					  	  if (dpat.ContainsKey(match.Groups[1].Value)){
						  	 return string.Format(@"__c{0}", dpat[match.Groups[1].Value]);
						  }
						  else
						  {
							  tool.LOG("dpat" + match.Groups[1].Value);
							  return match.Value;
						  }
						
						 
					  });


		content = Regex.Replace(content, @"[^\n]+\/\/(\[{\s*?groupId[^\]]+\])", delegate (Match match)
					 {
						 var g1 = match.Groups[1].Value;
						 var d = JArray.Parse(g1);
						 var rx = string.Empty;
						 foreach (dynamic dd in d)
						 {
							 var statusId = (int?)dd.statusId;					 
							 if (dstatus.ContainsKey(statusId.ToString())){
							 	 rx = Regex.Replace(match.Value, @" " + statusId + " ", " " + dstatus[statusId.ToString()] + " ");
							 }
							 else{
							 	
								tool.LOG("dstatus"+ statusId);								
							 }			 
							 
						 }

						 return rx;
					 });



		return content;
	}


	public static DataTable makeFunction(DataTable dt, string basePath, string db_conn)
	{

		var path = basePath += @"\config\request.js";

		var content = string.Empty;
		var mutexKey = MutexExample.GetFilePathMutexKey(path);
		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var reader = new StreamReader(path, Encoding.UTF8))
			{
				content = reader.ReadToEnd();
			}
		});

		var mockContent = string.Empty;
		foreach (DataRow dr in dt.Rows)
		{
			if (string.IsNullOrWhiteSpace(dr["c391"].ToString())) continue;
			mockContent += dr["c391"].ToString() + @"
		 
		 ";
		}

		var cppsOriginalList = get_category_page_column_status_list(mockContent);
		var cppsNewList = category_page_column_status_dic(cppsOriginalList, db_conn);




		foreach (DataRow dr in dt.Rows)
		{
			if (string.IsNullOrWhiteSpace(dr["c391"].ToString())) continue;

			dr["c391"] = mappingContent(cppsNewList, dr["c391"].ToString());

			var newFunc = dr["c391"].ToString();
			var funcName = Regex.Match(dr["c391"].ToString(), @"^[^\(]+").Value;

			content = Regex.Replace(content, funcName + @"\s*?\([^\{]+\{(?>[^\{\}]+|\{(?<Open>)|\}(?<-Open>))*(?(Open)(?!))\}", "");

			content = Regex.Replace(content, @"export\s*?default\s*?\{", @"
		 export default {
		 " + newFunc + @",
		 ");

		}

		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var writer = new StreamWriter(path, false, Encoding.UTF8))
			{
				writer.Write(content);
			}
		});

		return dt;

	}




	public static void makeRouter(DataTable dt, string basePath)
	{
		var file = basePath + @"\config\routes.js";
		var content = string.Empty;
		var mutexKey = MutexExample.GetFilePathMutexKey(file);

		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var writer = new StreamWriter(file, false, Encoding.UTF8))
			{
				writer.Write(content);
			}
		});

		foreach (DataRow r in dt.Rows)
		{
			var routerName = Regex.Match(r["c406"].ToString(), @"(?<=screen\s*?:\s*?)[^\{\s]+", RegexOptions.IgnoreCase).Value;


			content = Regex.Replace(content, @"import\s*?" + routerName + "[^\n]+", "");
			content = Regex.Replace(content, routerName + @"\s*?:\s*?\{[^\n]+ ", "");

			content = Regex.Replace(content, @"^", string.Format(@"import {0} from '{1}';", routerName, r["c404"].ToString()));
			content = Regex.Replace(content, @"const\s*?routes\s*?=\s*?\{", string.Format(@"const routers = {{
		 {0} : {1},
		", routerName, r["c406"].ToString()));

		}

		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var writer = new StreamWriter(file, false, Encoding.UTF8))
			{
				writer.Write(content);
			}
		});


	}



	public static void makeTheme(DataTable dt, string basePath)
	{

		var file = basePath + @"\config\theme.js";
		var content = string.Empty;
		var mutexKey = MutexExample.GetFilePathMutexKey(file);

		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var writer = new StreamWriter(file, false, Encoding.UTF8))
			{
				writer.Write(content);
			}
		});

		foreach (DataRow r in dt.Rows)
		{
			var themeName = r["c413"].ToString();


			content = Regex.Replace(content, @"'\s*?\." + themeName + @"'\s*?:\s*?\{(?>[^\{\}]+|\{(?<Open>)|\}(?<-Open>))*(?(Open)(?!))\},?", "", RegexOptions.IgnoreCase);

			content = Regex.Replace(content, @"export\s*?default\s*?\{", string.Format(@"export default {{
		 '{0}' : {1},
		", themeName, r["c416"].ToString()));

		}

		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var writer = new StreamWriter(file, false, Encoding.UTF8))
			{
				writer.Write(content);
			}
		});


	}



	public static DataTable makeResource(DataTable dt, string basePath, string serverHeader)
	{
		//1000\2018115\8f65108e-f614-4414-bd07-0ea49899b39b.png

		foreach (DataRow r in dt.Rows)
		{
			var url = serverHeader + r["objc429"].ToString().Replace(@"\", @"/");
			r["objc429"] = url;

			var fileName = basePath + @"\images\" + r["c427"].ToString();

			if (!File.Exists(fileName))
			{

				using (var client = new WebClient())
				{
					client.DownloadFile(url, fileName);
				}

			}
		}

		return dt;
	}


	public static void insertDataTable2Database(DataTable dt, string destinationTableName, List<string> ignoreCols, string db_conn)
	{
		//c372
		var dtConv = new DataTable();
		foreach (DataColumn col in dt.Columns)
		{ 
			if (col.ColumnName=="server_identity" || col.ColumnName =="c372")
			{
				dtConv.Columns.Add(col.ColumnName,typeof(Guid));
			}
			else{
				dtConv.Columns.Add(col.ColumnName, col.DataType);
			}			 
		}
		
		foreach(DataRow dr in dt.Rows){
			var dr2 = dtConv.NewRow();
			foreach (DataColumn col in dtConv.Columns)
			{
				if (col.ColumnName == "server_identity" || col.ColumnName == "c372" || col.ColumnName == "c431")
				{
					dr2[col.ColumnName]  = dr[col.ColumnName]!= DBNull.Value ? new Guid(dr[col.ColumnName].ToString()): Guid.Empty;
				}
				else
				{
					dr2[col.ColumnName]  = dr[col.ColumnName];
				}

			}
			dtConv.Rows.Add(dr2);
		}




		using (var bulkCopy = new SqlBulkCopy(db_conn))
		{
			// my DataTable column names match my SQL Column names, so I simply made this loop. However if your column names don't match, just pass in which datatable name matches the SQL column name in Column Mappings
			foreach (DataColumn col in dtConv.Columns)
			{
				if (!ignoreCols.Contains(col.ColumnName))
				{
					bulkCopy.ColumnMappings.Add(col.ColumnName, col.ColumnName);
				}
			}

			bulkCopy.BulkCopyTimeout = 600;
			bulkCopy.DestinationTableName = destinationTableName;
			bulkCopy.WriteToServer(dtConv);
		}

	}



	public static void bulkInsertAppTable(DataTable pageTable, string destTableName, List<string> ignoreCols, string db_conn)
	{
		var pageGids = (from c in pageTable.AsEnumerable()
						select c.Field<string>("server_identity")).ToList();
		pageGids.Add(Guid.Empty.ToString());


		var xGidsTable = BIZSAAS.COM.SQLWrap.DataProvider.GetDataTable(string.Format(@"
	select server_identity from {0} where  server_identity in ('{1}')
	", destTableName, string.Join("','", pageGids)), db_conn);
		var xGidsList = (from c in xGidsTable.AsEnumerable()
						 select c.Field<Guid?>("server_identity").Value.ToString()).ToList();

		for (int i = pageTable.Rows.Count - 1; i >= 0; i--)
		{
			DataRow dr = pageTable.Rows[i];
			if (xGidsList.Contains(dr["server_identity"].ToString()))
				pageTable.Rows.Remove(dr);
		}
		pageTable.AcceptChanges();

		insertDataTable2Database(pageTable, destTableName, ignoreCols, db_conn);
	}




	//serverSide
	public static void updateFrontEndCode(DataSet ds, string db_conn)
	{


		var pageTable = ds.Tables[0];
		var configTable = ds.Tables[1];
		var functionTable = ds.Tables[2];
		var routerTable = ds.Tables[3];
		var themeTable = ds.Tables[4];
		var resourceTable = ds.Tables[5];
		var moduleTable  = ds.Tables[6];

		var ignoreCols = new List<string>();
		ignoreCols.Add("ID");
		ignoreCols.Add("rootId");
		
		bulkInsertAppTable(pageTable, "CooWork_100037", ignoreCols, db_conn);
		bulkInsertAppTable(configTable, "CooWork_100039", ignoreCols, db_conn);
		bulkInsertAppTable(functionTable, "CooWork_100041", ignoreCols, db_conn);
		bulkInsertAppTable(routerTable, "CooWork_100043", ignoreCols, db_conn);
		bulkInsertAppTable(themeTable, "CooWork_100045", ignoreCols, db_conn);
		bulkInsertAppTable(resourceTable, "CooWork_100047", ignoreCols, db_conn);
		
		bulkInsertAppTable(moduleTable, "CooWork_100020", ignoreCols, db_conn);







	}




	//frontEndFunction  }}}}  }}}}   }}}}   }}}} }}}}  }}    正则匹配修正

}