<Query Kind="Program">
  <Reference Relative="..\Alachisoft.NCache.Linq.dll">D:\dll\sa006\Alachisoft.NCache.Linq.dll</Reference>
  <Reference Relative="..\Alachisoft.NCache.Runtime.dll">D:\dll\sa006\Alachisoft.NCache.Runtime.dll</Reference>
  <Reference Relative="..\Alachisoft.NCache.Web.dll">D:\dll\sa006\Alachisoft.NCache.Web.dll</Reference>
  <Reference Relative="..\BIZSAAS.COM.dll">D:\dll\sa006\BIZSAAS.COM.dll</Reference>
  <Reference Relative="..\CooWork.Core.dll">D:\dll\sa006\CooWork.Core.dll</Reference>
  <Reference Relative="..\CooWork.Data.dll">D:\dll\sa006\CooWork.Data.dll</Reference>
  <Reference Relative="..\CooWork.Distributed.CacheDTO.dll">D:\dll\sa006\CooWork.Distributed.CacheDTO.dll</Reference>
  <Reference Relative="..\CooWork.WcfCommon.dll">D:\dll\sa006\CooWork.WcfCommon.dll</Reference>
  <Reference Relative="..\DocumentFormat.OpenXml.dll">D:\dll\sa006\DocumentFormat.OpenXml.dll</Reference>
  <Reference Relative="..\mvcx.dll">D:\dll\sa006\mvcx.dll</Reference>
  <Reference Relative="..\Newtonsoft.Json.dll">D:\dll\sa006\Newtonsoft.Json.dll</Reference>
  <Reference>&lt;RuntimeDirectory&gt;\System.Configuration.dll</Reference>
  <Reference>&lt;RuntimeDirectory&gt;\System.Data.dll</Reference>
  <Reference>&lt;RuntimeDirectory&gt;\System.Drawing.dll</Reference>
  <Reference>&lt;RuntimeDirectory&gt;\WPF\WindowsBase.dll</Reference>
  <Namespace>Alachisoft.NCache.Runtime</Namespace>
  <Namespace>Alachisoft.NCache.Web.Caching</Namespace>
  <Namespace>BIZSAAS.COM.SQLWrap</Namespace>
  <Namespace>CooWork.Core</Namespace>
  <Namespace>CooWork.WcfCommon</Namespace>
  <Namespace>CooWork.WcfCommon.DTO</Namespace>
  <Namespace>DocumentFormat.OpenXml</Namespace>
  <Namespace>DocumentFormat.OpenXml.Drawing.Spreadsheet</Namespace>
  <Namespace>DocumentFormat.OpenXml.Packaging</Namespace>
  <Namespace>DocumentFormat.OpenXml.Spreadsheet</Namespace>
  <Namespace>mvcx</Namespace>
  <Namespace>Newtonsoft.Json</Namespace>
  <Namespace>Newtonsoft.Json.Converters</Namespace>
  <Namespace>Newtonsoft.Json.Linq</Namespace>
  <Namespace>Newtonsoft.Json.Serialization</Namespace>
  <Namespace>System.Configuration</Namespace>
  <Namespace>System.Data</Namespace>
  <Namespace>System.Data.SqlClient</Namespace>
  <Namespace>System.Drawing</Namespace>
  <Namespace>System.Drawing.Imaging</Namespace>
  <Namespace>System.Linq.Dynamic</Namespace>
  <AppConfig>
    <Content>
      <configuration>
        <appSettings>
          <add key="dbConn" value="data source=iZldo20stydao8Z;Database=greensun20161116;uid=lead#song1982!;pwd=Ssong1982!;" />
        </appSettings>
      </configuration>
    </Content>
  </AppConfig>
</Query>

void Main()
{
	return ;	
}




public class OpenXMLExcelReplace2
{




			public static DataTable ExcelReplaceWrap(GETDATA gd ,dynamic attRow,dynamic templateJson ,int? itemId,ref string message)
			{
			
			   tool.LOG("ffff0");
			 
				var fileServer = gd.getConfig("fileServer");
				var elements = gd.argsDic["elements"] as List<CooPageElementDTO>;
				var pages = gd.argsDic["pages"] as List<CooPageDTO>;
				var subPage = pages.FirstOrDefault(x => x.parentId == gd.page.ID && x.pageType != 17);


				var tempExcelFile = fileServer + (string)attRow.FilePath;
			    uint startRowIndex = (uint)templateJson.startRowIndex; ;
				uint endRowIndex = (uint)templateJson.endRowIndex;
				string mergeColumnIds = (string)templateJson.mergeColumnIds;
				var referPatId = (int?)templateJson.referPatId;
		        var subAttachPatId  = (int?)templateJson.subAttachPatId;
				var mergeTxtPatId =   (int?)templateJson.mergeTxtPatId;
				var mergeTxtIndex =   (int?)templateJson.mergeTxtIndex;
				var mergeColumnIndex = (int?)templateJson.mergeColumnIndex; //imageColumn
				var baseFormula =  (string)templateJson.baseFormula;
				var baseSum =  (string)templateJson.baseSum;
				var fileId  = (int?)templateJson.fileId;




				var related = new Dictionary<int, DataTable>();
				var dlist = new DataTable();
				var outJoins = new List<CooItemJoinDTO>();

				dlist = gd.DetailCooItemFull(new List<SearchCondition>(), itemId.Value, null, gd.page.ID, out outJoins, out related);
				if (!related.ContainsKey(subPage.ID)) return new DataTable();
				var subDt = related[subPage.ID];


				var _myFilePath = string.Format(@"{0}{1}\temp\{2}{3}", fileServer, gd.companyId, dlist.Rows[0]["__c"+fileId].ToString(), Regex.Match((string)attRow.FilePath, @"\.[a-zA-Z]+$").Value);
				if (File.Exists(_myFilePath)) File.Delete(_myFilePath);
				File.Copy(tempExcelFile, _myFilePath);


				uint sIndex = startRowIndex + (uint)subDt.Rows.Count;
				using (SpreadsheetDocument spreadsheetDocument =
											 SpreadsheetDocument.Open(_myFilePath, true))
				{
					// Iterate through all WorksheetParts
					WorkbookPart workbookPart = spreadsheetDocument.WorkbookPart;
					WorksheetPart worksheetPart = workbookPart.WorksheetParts.First();
					var sheetData = worksheetPart.Worksheet.Elements<SheetData>().FirstOrDefault();
					var worksheet = worksheetPart.Worksheet;


					//jyrb.ExcelMoveUpImages((int)endRowIndex, (int)(endRowIndex - startRowIndex + 1 - (uint)subDt.Rows.Count), worksheetPart);
					//jyrb.ExcelMoveUpMergeCells((int)endRowIndex, (int)(endRowIndex - startRowIndex + 1 - (uint)subDt.Rows.Count), worksheet);
					//jyrb.RemoveRangeRows(sIndex, endRowIndex, sheetData);


					worksheetPart.Worksheet.Save();
				}

				var tempDs = mvcx.dataop.dataSetFromExcel(_myFilePath, false);
				var tempDt = tempDs.Tables[0];


				var mainPats = (from c in gd.pats
								from d in elements
								where c.ID == d.patternId && d.pageId == gd.page.ID
								select c).ToList();

				var subPats = (from c in gd.pats
							   from d in elements
							   where c.ID == d.patternId && d.pageId == subPage.ID
							   select c).ToList();


				var hArr = new[] { new { columnName = string.Empty, rowIndex = (uint)0, value = string.Empty, pTypeId = (int)0, patternId = (int)0 } };
				var h = hArr.ToList();
				h.RemoveAt(0);
				var charArr = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

				for (int i = 0; i < tempDt.Rows.Count; i++)
				{
					if (i >= startRowIndex - 1 && i < startRowIndex - 1 + subDt.Rows.Count) continue;

					for (int j = 0; j < tempDt.Columns.Count; j++)
					{
						var cellV = tempDt.Rows[i][j].ToString();
						if (cellV.Contains("{") && cellV.Contains("}"))
						{
							var patName = Regex.Match(cellV, @"\{(.+)\}").Groups[1].Value;

							var checkMain = mainPats.FirstOrDefault(x => x.pName == patName);
							if (checkMain != null)
							{
								var tp = checkMain.pTypeId;
								var v = dlist.Rows[0]["__c" + checkMain.ID].ToString();
								if (tp == 2)
								{
									tp = 5;
								}
								if (tp == 6)
								{
									v = Convert.ToDateTime(v).ToString("yyyy-MM-dd");
									tp = 5;
								}
								if (tp == 7) { v = Regex.Replace(v, @"<[^>]+>", ""); };
								v = Regex.Replace(cellV, @"\{" + patName + @"\}", v);
								h.Add(new { columnName = charArr[j].ToString(), rowIndex = (uint)(i + 1), value = v, pTypeId = (int)tp, patternId = (int)checkMain.ID });
							}

						}
					}

				}




				for (int j = 0; j < tempDt.Columns.Count; j++)
				{
					var cellV = tempDt.Rows[(int)startRowIndex - 1][j].ToString();
					if (cellV.Contains("{") && cellV.Contains("}"))
					{
						var patName = Regex.Match(cellV, @"\{(.+)\}").Groups[1].Value;

						var checkSub = subPats.FirstOrDefault(x => x.pName == patName);
						if (checkSub != null)
						{
							var tp = checkSub.pTypeId;
							for (int k = 0; k < subDt.Rows.Count; k++)
							{
								var v = subDt.Rows[k]["__c" + checkSub.ID].ToString();
								if (tp == 2)
								{
									tp = 5;
								}
								if (tp == 6)
								{
									v = Convert.ToDateTime(v).ToString("yyyy-MM-dd");
									tp = 5;
								}
								if (tp == 7) { v = Regex.Replace(v, @"<[^>]+>", ""); };
								v = Regex.Replace(cellV, @"\{" + patName + @"\}", v);

								h.Add(new { columnName = charArr[j].ToString(), rowIndex = (uint)(k + startRowIndex), value = v, pTypeId = (int)tp, patternId = (int)checkSub.ID });

							}
						}

					}
				}

				var subI = 0;
				List<int> spans = new List<int>();
				var imgDic = new Dictionary<int, string>();
				var txtDic = new Dictionary<int, string>();
				var spanDic = new Dictionary<int, string>();
				var cellDic = new Dictionary<string, string>();
				var mergeCols = new List<string>();
				
				
				tool.LOG("fff1");



				foreach (DataRow dr in subDt.Rows)
				{
			    	if (dr["__c" + referPatId].ToString().ToLower()=="true")
					{
						spans.Add(subI);
						if (Regex.IsMatch(dr["__c" + subAttachPatId].ToString(), @"FilePath""\s*?:\s*?""[\\\/a-zA-Z0-9\.]+"))
						{
							imgDic.Add(subI, Regex.Match(dr["__c" + subAttachPatId].ToString(), @"FilePath""\s*?:\s*?""([^""]+)").Groups[1].Value);
						}
						if (mergeTxtPatId>0)
						{
							txtDic.Add(subI, dr["__c" + mergeTxtPatId].ToString());
						}
						

					}

					subI++;
				}

				foreach (var mgIndex in mergeColumnIds.Split(','))
				{
					for (int i = 0; i < spans.Count - 1; i++)
					{
						var cls = string.Format("{0}{1}:{0}{2}", charArr[Convert.ToInt32(mgIndex)], startRowIndex + spans[i], startRowIndex + spans[i + 1] - 1);
						mergeCols.Add(cls);

						if (mgIndex == mergeColumnIndex.ToString())
						{
							spanDic.Add(spans[i], cls);
						}

					}
					
					
		            if (spans.Count>0)
					{
						mergeCols.Add(string.Format("{0}{1}:{0}{2}", charArr[Convert.ToInt32(mgIndex)], startRowIndex + spans[spans.Count - 1], startRowIndex + subDt.Rows.Count - 1));
						if (mgIndex == mergeColumnIndex.ToString())
						{
							spanDic.Add(spans[spans.Count - 1], string.Format("{0}{1}:{0}{2}", charArr[mergeColumnIndex.Value], startRowIndex + spans[spans.Count - 1], startRowIndex + subDt.Rows.Count - 1));
						}
					}

				}
				
			 
		        	tool.LOG("fff2");


				OpenXMLExcelReplace2.ExcelTemplateReplace(_myFilePath, JsonConvert.SerializeObject(h));
				
			 	//message = _myFilePath.Replace(fileServer,"").Replace(@"\","/");
				
				//return  dlist;


				var kvDic = new Dictionary<string, string>();
				var formulaDic = new Dictionary<string, string>();
				 
				foreach (var j in spans)
				{

					if (txtDic.ContainsKey(j))
					{
						var cls = spanDic[j];
						var args = Regex.Replace(cls, @"[a-zA-Z]", "").Split(':');

						kvDic.Add(string.Format(@"{0}{1}", charArr[mergeTxtIndex.Value], args[0]), txtDic[j]);
					}
				}


				if (!string.IsNullOrWhiteSpace(baseFormula))
				{
					for (int i = 0; i < subDt.Rows.Count; i++)
					{
						formulaDic.Add(string.Format(baseSum, startRowIndex + i), string.Format(baseFormula, startRowIndex + i));
					}
					formulaDic.Add(string.Format(baseSum, startRowIndex + subDt.Rows.Count), string.Format(@"SUM({0}:{1})", string.Format(baseSum, startRowIndex), string.Format(baseSum, startRowIndex + subDt.Rows.Count - 1)));
				}


				using (SpreadsheetDocument spreadsheetDocument =
											 SpreadsheetDocument.Open(_myFilePath, true))
				{
					// Iterate through all WorksheetParts
					WorkbookPart workbookPart = spreadsheetDocument.WorkbookPart;
					WorksheetPart worksheetPart = workbookPart.WorksheetParts.First();
					var sheetData = worksheetPart.Worksheet.Elements<SheetData>().FirstOrDefault();
					var worksheet = worksheetPart.Worksheet;


					InsertMergeCells(worksheet, mergeCols);


					foreach (var r in sheetData.Elements<Row>())
					{
						var cells = r.Descendants<Cell>();
						foreach (var c in cells)
						{

							if (kvDic.ContainsKey(c.CellReference.InnerText))
							{
								c.CellValue = new CellValue(kvDic[c.CellReference.InnerText]);
								c.DataType =
									new EnumValue<CellValues>(CellValues.String);
							}

							if (formulaDic.ContainsKey(c.CellReference.InnerText))
							{
								CellFormula cellFormula = new CellFormula(formulaDic[c.CellReference.InnerText]);
								c.Append(cellFormula);
							}

						}
					}
					worksheetPart.Worksheet.Save();

				}


				foreach (var j in spans)
				{
					if (imgDic.ContainsKey(j))
					{
						var cls = spanDic[j];
						var args = Regex.Replace(cls, @"[a-zA-Z]", "").Split(':');

						InsertImage2Excel(_myFilePath, fileServer + Regex.Replace(imgDic[j], @"\/", "\\"), (uint)(1000 + j),
						mergeColumnIndex.Value, (Convert.ToInt32(args[0]) - 1), mergeColumnIndex.Value, (Convert.ToInt32(args[1]) - 1));

					}


				}
				
					tool.LOG("fff3");
				
				message = _myFilePath.Replace(fileServer,"").Replace(@"\","/");
				
				return  dlist;


			}















			public static void RemoveRangeRows(uint startIndex, uint endIndex, SheetData sheetData)
			{
				uint newRowIndex;

				var row1s = sheetData.Descendants<Row>().Where(r => r.RowIndex.Value >= startIndex && r.RowIndex.Value <= endIndex).ToList();

				foreach (var r in row1s)
				{
					r.Remove();
				}
				IEnumerable<Row> rows = sheetData.Descendants<Row>().Where(r => r.RowIndex.Value > endIndex);
				foreach (Row row in rows)
				{
					newRowIndex = System.Convert.ToUInt32(row.RowIndex.Value - 1 - endIndex + startIndex);

					foreach (Cell cell in row.Elements<Cell>())
					{
						// Update the references for reserved cells.
						string cellReference = cell.CellReference.Value;
						cell.CellReference = new StringValue(cellReference.Replace(row.RowIndex.Value.ToString(), newRowIndex.ToString()));
					}
					// Update the row index.
					row.RowIndex = new UInt32Value(newRowIndex);
				}

			}



			public static void ExcelMoveUpImages(int endRowIndex, int removeRowCount, WorksheetPart worksheetPart)
			{

				var dp = worksheetPart.DrawingsPart;
				if (dp == null){
					 return;
				}
				//	dp = worksheetPart.AddNewPart<DrawingsPart>();


				if (!worksheetPart.Worksheet.ChildElements.OfType<Drawing>().Any())
				{

					if (worksheetPart.Worksheet.Elements<LegacyDrawing>().Count() > 0)
					{
						LegacyDrawing lg = worksheetPart.Worksheet.Elements<LegacyDrawing>().First();
						worksheetPart.Worksheet.InsertBefore<Drawing>(new Drawing { Id = worksheetPart.GetIdOfPart(dp) }, lg);
					}
					else
					{
						worksheetPart.Worksheet.Append(new Drawing { Id = worksheetPart.GetIdOfPart(dp) });
					}
				}

				if (dp.WorksheetDrawing == null)
				{
					return;
					//dp.WorksheetDrawing = new WorksheetDrawing();
				}
		 

				if (dp.WorksheetDrawing.Descendants<TwoCellAnchor>().Count() > 0)
				{
					foreach (var tc in dp.WorksheetDrawing.Descendants<TwoCellAnchor>())
					{
						if (Convert.ToInt32(tc.FromMarker.RowId.Text) >= endRowIndex)
						{
							tc.FromMarker.RowId = new RowId((Convert.ToInt32(tc.FromMarker.RowId.Text) - removeRowCount).ToString());
							tc.ToMarker.RowId = new RowId((Convert.ToInt32(tc.ToMarker.RowId.Text) - removeRowCount).ToString());
						}
					}
				}
			}


			public static void ExcelAddFormula(Dictionary<string, string> fDic, SheetData sheetData)
			{

				foreach (var r in sheetData.Elements<Row>())
				{
					var cells = r.Descendants<Cell>();
					foreach (var c in cells)
					{
						if (fDic.ContainsKey(c.CellReference.InnerText))
						{
							CellFormula cellFormula = new CellFormula(fDic[c.CellReference.InnerText]);
							c.Append(cellFormula);
						}
					}
				}
			}



			public static void ExcelMoveUpMergeCells(int endRowIndex, int removeRowCount, Worksheet ws)
			{
				if (ws.Descendants<MergeCells>().Count() > 0)
				{
					var mergeCells = ws.Elements<MergeCells>().First();

					foreach (MergeCell mc in mergeCells)
					{
						var rtxt = mc.Reference.InnerText;
						var rowIds = Regex.Replace(rtxt, @"[a-zA-Z]", "").Split(':');
						if (Convert.ToInt32(rowIds[0]) >= endRowIndex)
						{
							var newRefer = Regex.Replace(rtxt, @"\d+(?=:)", (Convert.ToInt32(rowIds[0]) - removeRowCount).ToString());
							newRefer = Regex.Replace(newRefer, @"\d+$", (Convert.ToInt32(rowIds[1]) - removeRowCount).ToString());
							mc.Reference = new StringValue(newRefer);
						}
					}
				}

			}
			
			


			 public static void InsertMergeCells(Worksheet worksheet, List<string> cellRanges)
			{
				MergeCells mergeCells;
				if (worksheet.Elements<MergeCells>().Count() > 0)
				{
					mergeCells = worksheet.Elements<MergeCells>().First();
				}
				else
				{
					mergeCells = new MergeCells();

					// Insert a MergeCells object into the specified position.
					if (worksheet.Elements<CustomSheetView>().Count() > 0)
					{
						worksheet.InsertAfter(mergeCells, worksheet.Elements<CustomSheetView>().First());
					}
					else if (worksheet.Elements<DataConsolidate>().Count() > 0)
					{
						worksheet.InsertAfter(mergeCells, worksheet.Elements<DataConsolidate>().First());
					}
					else if (worksheet.Elements<SortState>().Count() > 0)
					{
						worksheet.InsertAfter(mergeCells, worksheet.Elements<SortState>().First());
					}
					else if (worksheet.Elements<AutoFilter>().Count() > 0)
					{
						worksheet.InsertAfter(mergeCells, worksheet.Elements<AutoFilter>().First());
					}
					else if (worksheet.Elements<Scenarios>().Count() > 0)
					{
						worksheet.InsertAfter(mergeCells, worksheet.Elements<Scenarios>().First());
					}
					else if (worksheet.Elements<ProtectedRanges>().Count() > 0)
					{
						worksheet.InsertAfter(mergeCells, worksheet.Elements<ProtectedRanges>().First());
					}
					else if (worksheet.Elements<SheetProtection>().Count() > 0)
					{
						worksheet.InsertAfter(mergeCells, worksheet.Elements<SheetProtection>().First());
					}
					else if (worksheet.Elements<SheetCalculationProperties>().Count() > 0)
					{
						worksheet.InsertAfter(mergeCells, worksheet.Elements<SheetCalculationProperties>().First());
					}
					else
					{
						worksheet.InsertAfter(mergeCells, worksheet.Elements<SheetData>().First());
					}
				}

				foreach (var s in cellRanges)
				{
					MergeCell mergeCell = new MergeCell() { Reference = new StringValue(s) }; //C11:C13
					mergeCells.Append(mergeCell);
				}

			}

			public static ImagePartType GetImagePartTypeByName(string filename)
			{
				if (filename.ToLower().EndsWith(".png"))
				{
					return ImagePartType.Png;
				}

				return ImagePartType.Jpeg;


			}



			public static void InsertImage2Excel(string excelName, string sImagePath, UInt32 id, int c1, int r1, int c2, int r2)
			{

				using (SpreadsheetDocument spreadsheetDocument =
												 SpreadsheetDocument.Open(excelName, true))
				{
					// Iterate through all WorksheetParts
					WorkbookPart workbookPart = spreadsheetDocument.WorkbookPart;
					WorksheetPart worksheetPart = workbookPart.WorksheetParts.First();
					var sheetData = worksheetPart.Worksheet.Elements<SheetData>().FirstOrDefault();
					var worksheet = worksheetPart.Worksheet;


					var dp = worksheetPart.DrawingsPart;
					if (dp == null)
						dp = worksheetPart.AddNewPart<DrawingsPart>();


					if (!worksheetPart.Worksheet.ChildElements.OfType<Drawing>().Any())
					{

						if (worksheetPart.Worksheet.Elements<LegacyDrawing>().Count() > 0)
						{
							LegacyDrawing lg = worksheetPart.Worksheet.Elements<LegacyDrawing>().First();
							worksheetPart.Worksheet.InsertBefore<Drawing>(new Drawing { Id = worksheetPart.GetIdOfPart(dp) }, lg);
						}
						else
						{
							worksheetPart.Worksheet.Append(new Drawing { Id = worksheetPart.GetIdOfPart(dp) });
						}
					}

					if (dp.WorksheetDrawing == null)
					{
						dp.WorksheetDrawing = new WorksheetDrawing();
					}




					ImagePart imgp = dp.AddImagePart(GetImagePartTypeByName(sImagePath) );
					using (FileStream fs = new FileStream(sImagePath, FileMode.Open))
					{
						imgp.FeedData(fs);
					}

					NonVisualDrawingProperties nvdp = new NonVisualDrawingProperties();
					nvdp.Id = id;
					nvdp.Name = "Picture " + id.ToString();
					nvdp.Description = Regex.Match(sImagePath, @"[^\\\/]+$").Value;
					DocumentFormat.OpenXml.Drawing.PictureLocks picLocks = new DocumentFormat.OpenXml.Drawing.PictureLocks();
					picLocks.NoChangeAspect = true;
					picLocks.NoChangeArrowheads = true;
					NonVisualPictureDrawingProperties nvpdp = new NonVisualPictureDrawingProperties();
					nvpdp.PictureLocks = picLocks;
					NonVisualPictureProperties nvpp = new NonVisualPictureProperties();
					nvpp.NonVisualDrawingProperties = nvdp;
					nvpp.NonVisualPictureDrawingProperties = nvpdp;

					DocumentFormat.OpenXml.Drawing.Stretch stretch = new DocumentFormat.OpenXml.Drawing.Stretch();
					stretch.FillRectangle = new DocumentFormat.OpenXml.Drawing.FillRectangle();

					BlipFill blipFill = new BlipFill();
					DocumentFormat.OpenXml.Drawing.Blip blip = new DocumentFormat.OpenXml.Drawing.Blip();
					blip.Embed = dp.GetIdOfPart(imgp);
					blip.CompressionState = DocumentFormat.OpenXml.Drawing.BlipCompressionValues.Print;
					blipFill.Blip = blip;
					blipFill.SourceRectangle = new DocumentFormat.OpenXml.Drawing.SourceRectangle();
					blipFill.Append(stretch);

					DocumentFormat.OpenXml.Drawing.Transform2D t2d = new DocumentFormat.OpenXml.Drawing.Transform2D();
					DocumentFormat.OpenXml.Drawing.Offset offset = new DocumentFormat.OpenXml.Drawing.Offset();
					offset.X = 0;
					offset.Y = 0;
					t2d.Offset = offset;
					Bitmap bm = new Bitmap(sImagePath);

					DocumentFormat.OpenXml.Drawing.Extents extents = new DocumentFormat.OpenXml.Drawing.Extents();
					extents.Cx = (long)bm.Width * (long)((float)914400 / bm.HorizontalResolution);
					extents.Cy = (long)bm.Height * (long)((float)914400 / bm.VerticalResolution);
					bm.Dispose();
					t2d.Extents = extents;
					ShapeProperties sp = new ShapeProperties();
					sp.BlackWhiteMode = DocumentFormat.OpenXml.Drawing.BlackWhiteModeValues.Auto;
					sp.Transform2D = t2d;
					DocumentFormat.OpenXml.Drawing.PresetGeometry prstGeom = new DocumentFormat.OpenXml.Drawing.PresetGeometry();
					prstGeom.Preset = DocumentFormat.OpenXml.Drawing.ShapeTypeValues.Rectangle;
					prstGeom.AdjustValueList = new DocumentFormat.OpenXml.Drawing.AdjustValueList();
					sp.Append(prstGeom);
					sp.Append(new DocumentFormat.OpenXml.Drawing.NoFill());

					DocumentFormat.OpenXml.Drawing.Spreadsheet.Picture picture = new DocumentFormat.OpenXml.Drawing.Spreadsheet.Picture();
					picture.NonVisualPictureProperties = nvpp;
					picture.BlipFill = blipFill;
					picture.ShapeProperties = sp;

					Position pos = new Position();
					pos.X = 0;
					pos.Y = 0;
					Extent ext = new Extent();
					ext.Cx = extents.Cx;
					ext.Cy = extents.Cy;

					var charArr = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

					double columnWidth = 1;

					Columns columns1 = worksheet.GetFirstChild<Columns>();

					var ci = 0;
					foreach (Column col in columns1)
					{
						if (col.Min == (c1 + 1))
						{

							columnWidth = col.Width;
						}

					}

					var tWidth1 = Convert.ToInt32(columnWidth * 0.1 * 914400 * 0.05);
					var tWidth2 = Convert.ToInt32(columnWidth * 0.1 * 914400 * 0.8);

					if (dp.WorksheetDrawing.Descendants<TwoCellAnchor>().Count() > 0)
					{
						foreach (var tc in dp.WorksheetDrawing.Descendants<TwoCellAnchor>())
						{
							if (Convert.ToInt32(tc.FromMarker.RowId.Text) > 40)
							{
								tc.FromMarker.RowId = new RowId((Convert.ToInt32(tc.FromMarker.RowId.Text) - 20).ToString());
								tc.ToMarker.RowId = new RowId((Convert.ToInt32(tc.ToMarker.RowId.Text) - 20).ToString());
							}

						}

					}




					//	dp.WorksheetDrawing = new WorksheetDrawing();
					TwoCellAnchor twoCellAnchor = dp.WorksheetDrawing.AppendChild<TwoCellAnchor>(new TwoCellAnchor());
					twoCellAnchor.Append(new DocumentFormat.OpenXml.Drawing.Spreadsheet.FromMarker(new ColumnId(c1.ToString()),
					   new ColumnOffset(tWidth1.ToString()),
					   new RowId(r1.ToString()),
					   new RowOffset("76225")));
					twoCellAnchor.Append(new DocumentFormat.OpenXml.Drawing.Spreadsheet.ToMarker(new ColumnId(c2.ToString()),
						new ColumnOffset(tWidth2.ToString()),
						new RowId(r2.ToString()),
						new RowOffset("76225")));


					twoCellAnchor.Append(picture);
					twoCellAnchor.Append(new ClientData());

					//	Drawing drawing = new Drawing();
					//	drawing.Id = dp.GetIdOfPart(imgp);

					dp.WorksheetDrawing.Save();
					//	worksheet.Append(drawing);


					worksheetPart.Worksheet.Save();





				}


			}




		   
		public static string generateCellList(GETDATA gd,Dictionary<int, DataTable> source,string templateConfig, string filePath)
		{
			
			var hArr = new[] { new { tableIndex = (uint)0, columnName = string.Empty, rowIndex = (uint)0, value = string.Empty, pTypeId = (int)0, patternId = (int)0 } };
			var h = hArr.ToList();
			h.RemoveAt(0);

		    var charArr = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
			var pArr = new[] { new { id = (int)0, tbi = (int)0, range = string.Empty, type = string.Empty, cols = string.Empty } };
			var pList = JsonConvert.DeserializeAnonymousType(Regex.Replace(templateConfig, @"<[^>]+>", ""), pArr).ToList();
		    var tempDs = mvcx.dataop.dataSetFromExcel(filePath, false);
			
			
			
			foreach(var p in pList)
			{
				var tempDt = tempDs.Tables[p.tbi-1];
				var dt  = source[p.id];		
				var p2 = p.range.Split(':');
				var startRow = Convert.ToInt32( Regex.Match(p2[0],@"\d+").Value) -1 ;
				var endRow = Convert.ToInt32( Regex.Match(p2[1],@"\d+").Value) -1 ;
				var startCol = 0;
				var endCol = 0;
				for (int k = Regex.Match(p2[0], @"[A-Z]+").Value.Length - 1; k >= 0; k--)
				{
					startCol += (charArr.IndexOf(Regex.Match(p2[0], @"[A-Z]+").Value[k]) + (k == 0 ? 0 : 1)) * (int)Math.Pow(26, k);
				}
				for (int k = Regex.Match(p2[1], @"[A-Z]+").Value.Length - 1; k >= 0; k--)
				{
					endCol += (charArr.IndexOf(Regex.Match(p2[1], @"[A-Z]+").Value[k]) + +(k == 0 ? 0 : 1)) * (int)Math.Pow(26, k);
				}
				var mainPats = gd.pats.Where(x=> ("," + p.cols + ",").IndexOf("," + x.ID + ",")>=0).ToList();
				

				switch(p.type){
					case "form":
						for (int i = startRow ; i < endRow+1 ; i++)
						{		 
							for (int j = startCol ; j < endCol+1; j++)
							{
								var cellV = tempDt.Rows[i][j].ToString();
								if (cellV.Contains("{") && cellV.Contains("}"))
								{
									var patName = Regex.Match(cellV, @"\{(.+)\}").Groups[1].Value;
									var checkMain = mainPats.FirstOrDefault(x => x.pName == patName);
									if (checkMain != null)
									{
										var tp = checkMain.pTypeId;
										if (tp != 3 && tp != 4) tp = 0;
										if (dt.Rows.Count > 0)
										{
											var v = dt.Rows[0]["c" + checkMain.ID].ToString();
											if (tp == 7) { v = Regex.Replace(v, @"<[^>]+>", "");  };									
											v = Regex.Replace(cellV, @"\{" + patName + @"\}", v);
											h.Add(new { tableIndex = (uint)p.tbi, columnName = charArr[j].ToString(), rowIndex = (uint)(i + 1), value = v, pTypeId = tp.Value, patternId = (int)checkMain.ID });

										}else{
											h.Add(new { tableIndex = (uint)p.tbi, columnName = charArr[j].ToString(), rowIndex = (uint)(i + 1), value = "", pTypeId = tp.Value, patternId = (int)checkMain.ID });
										}
								   }

								}
							}
						}
						break;
					case "colList":
						
							for (int i = startRow; i < endRow + 1; i++)
							{

								var cellV = tempDt.Rows[i][startCol].ToString();
								if (cellV.Contains("{") && cellV.Contains("}"))
								{
									var patName = Regex.Match(cellV, @"\{(.+)\}").Groups[1].Value;
									var checkMain = mainPats.FirstOrDefault(x => x.pName == patName);
									if (checkMain != null)
									{
										var tp = checkMain.pTypeId;
										if (tp != 3 && tp != 4) tp = 0;
										if (dt.Rows.Count > 0)
										{
											for (int q = 0; q < dt.Rows.Count; q++)
											{
												var v = dt.Rows[q]["c" + checkMain.ID].ToString();
												if (tp == 7) { v = Regex.Replace(v, @"<[^>]+>", ""); };
												v = Regex.Replace(cellV, @"\{" + patName + @"\}", v);
												h.Add(new { tableIndex = (uint)p.tbi, columnName = charArr[startCol + q].ToString(), rowIndex = (uint)(i + 1), value = v, pTypeId = tp.Value, patternId = (int)checkMain.ID });
			
											}
										}else{
											h.Add(new { tableIndex = (uint)p.tbi, columnName = charArr[startCol].ToString(), rowIndex = (uint)(i + 1), value = "", pTypeId = tp.Value, patternId = (int)checkMain.ID });
										}
											
									}
								}
							}


						break;
					case "rowList":

						for (int j = startCol; j < endCol; j++)
						{
							var cellV = tempDt.Rows[startRow][j].ToString();
							if (cellV.Contains("{") && cellV.Contains("}"))
							{
								var patName = Regex.Match(cellV, @"\{(.+)\}").Groups[1].Value;
								var checkMain = mainPats.FirstOrDefault(x => x.pName == patName);
								if (checkMain != null)
								{
									var tp = checkMain.pTypeId;
									if (dt.Rows.Count > 0)
									{
										for (int q = 0; q < dt.Rows.Count; q++)
										{
											var ctp = tp;
											if (tp != 3 && tp != 4 && tp != 6) ctp = 20;								
											
											
											var v = dt.Rows[q]["c" + checkMain.ID].ToString();
											if (tp == 7) { v = Regex.Replace(v, @"<[^>]+>", ""); };
											if (tp == 6) { v = DateTime.Parse(v).ToString("yyyy-MM-dd"); ctp = 20; }
											v = Regex.Replace(cellV, @"\{" + patName + @"\}", v);
											h.Add(new { tableIndex = (uint)p.tbi, columnName = charArr[j].ToString(), rowIndex = (uint)(startRow + q + 1), value = v, pTypeId = ctp.Value, patternId = (int)checkMain.ID });
										}
									}
									else
									{
										h.Add(new { tableIndex = (uint)p.tbi, columnName = charArr[j].ToString(), rowIndex = (uint)(startRow +  1), value = "", pTypeId = tp.Value, patternId = (int)checkMain.ID });
									}
									
								}

							}
						}

						break;
				}
			}
			
			tool.LOG(h);

			return JsonConvert.SerializeObject(h);


		}



     public static void GetExcelDic(DataTable subDt, uint startRowIndex,Dictionary<int,string> groupList ,string mergeTxtColumnMap,string baseFormula,string baseSum,
	string mergeImageColumnMap ,ref Dictionary<string,string> imgDic ,ref List<string> mergeCols, ref Dictionary<string,string> txtDic, ref Dictionary<string,string> formulaDic
	)
	{
		var charArr = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
		 
		for (int i = 0; i < subDt.Rows.Count; i++)
		{
			var idx = i + (int)startRowIndex;
			var dr = subDt.Rows[i];

			if (groupList.ContainsKey(idx))
			{
				foreach (var imgSpan in mergeImageColumnMap.Split(','))
				{
					if (!string.IsNullOrWhiteSpace(imgSpan))					
					imgDic.Add(string.Format(@"{0}{1}:{0}{2}", charArr[Convert.ToInt32(imgSpan.Split(':')[0])], groupList[idx].Split(':')[0], groupList[idx].Split(':')[1]), Regex.Match(dr["__c" + imgSpan.Split(':')[1]].ToString(), @"FilePath""\s*?:\s*?""([^""]+)").Groups[1].Value);
				}

				foreach (var txtSpan in mergeTxtColumnMap.Split(','))
				{
					if (!string.IsNullOrWhiteSpace(txtSpan))
					{
						var cls = string.Format("{0}{1}:{0}{2}", charArr[Convert.ToInt32(txtSpan.Split(':')[0])], groupList[idx].Split(':')[0], groupList[idx].Split(':')[1]);
						mergeCols.Add(cls);
						txtDic.Add(string.Format(@"{0}{1}", charArr[Convert.ToInt32(txtSpan.Split(':')[0])], idx), dr["__c" + txtSpan.Split(':')[1]].ToString());
					}				
				
				}

			}
		}
		if (!string.IsNullOrWhiteSpace(baseFormula))
		{
			for (int i = 0; i < subDt.Rows.Count; i++)
			{
				formulaDic.Add(string.Format(baseSum, startRowIndex + i), string.Format(baseFormula, startRowIndex + i));
			}
			formulaDic.Add(string.Format(baseSum, startRowIndex + subDt.Rows.Count), string.Format(@"SUM({0}:{1})", string.Format(baseSum, startRowIndex), string.Format(baseSum, startRowIndex + subDt.Rows.Count - 1)));
		}

	}


	public static void ExcelTemplateReplace(string path, string jsonArray)
	{

		var h = new[] { new { columnName = string.Empty, rowIndex = (uint)0, value = string.Empty, pTypeId = (int)0 } };

		var hArr = JsonConvert.DeserializeAnonymousType(jsonArray, h).ToList();

		using (SpreadsheetDocument spreadSheet =
						 SpreadsheetDocument.Open(path, true))
		{
			var sheetName = spreadSheet.WorkbookPart.Workbook.Descendants<Sheet>().First().Name;
			WorksheetPart worksheetPart =
				  OpenXMLExcelReplace.GetWorksheetPartByName(spreadSheet, sheetName.Value);



			if (worksheetPart != null)
			{
				foreach (var a in hArr)
				{
					Cell cell = OpenXMLExcelReplace2.GetCell(worksheetPart.Worksheet,
									a.columnName, a.rowIndex);

					cell.CellValue = new CellValue(a.value);
					switch (a.pTypeId)
					{
						case 1:
							cell.DataType = new EnumValue<CellValues>(CellValues.Boolean);
							break;
						case 6:
							cell.DataType = new EnumValue<CellValues>(CellValues.Date);
							break;
						case 3:
						case 4:
							cell.DataType = new EnumValue<CellValues>(CellValues.Number);
							break;
						default:
							cell.DataType = new EnumValue<CellValues>(CellValues.String);
							break;
					}
				}
				// Save the worksheet.
				worksheetPart.Worksheet.Save();
			}
		}

	}


	public static void ExcelTemplateReplace(string templatePath,string path, string jsonArray)
	{
		if (File.Exists(path)) File.Delete(path);

		File.Copy(templatePath, path);
		
		ExcelTemplateReplace(path,jsonArray);

	}




	public static void UpdateCell(string docName, string text,
		uint rowIndex, string columnName)
	{
		// Open the document for editing.
		using (SpreadsheetDocument spreadSheet =
				 SpreadsheetDocument.Open(docName, true))
		{
			var sheetName = spreadSheet.WorkbookPart.Workbook.Descendants<Sheet>().First().Name;
			WorksheetPart worksheetPart =
				  OpenXMLExcelReplace.GetWorksheetPartByName(spreadSheet, sheetName.Value);

			if (worksheetPart != null)
			{
				Cell cell = GetCell(worksheetPart.Worksheet,
										 columnName, rowIndex);

				cell.CellValue = new CellValue(text);
				cell.DataType =
					new EnumValue<CellValues>(CellValues.Number);

				// Save the worksheet.
				worksheetPart.Worksheet.Save();
			}
		}

	}

	public static WorksheetPart
		 GetWorksheetPartByName(SpreadsheetDocument document,
		 string sheetName)
	{
		IEnumerable<Sheet> sheets =
		   document.WorkbookPart.Workbook.GetFirstChild<Sheets>().
		   Elements<Sheet>().Where(s => s.Name == sheetName);

		if (sheets.Count() == 0)
		{
			// The specified worksheet does not exist.

			return null;
		}

		string relationshipId = sheets.First().Id.Value;
		WorksheetPart worksheetPart = (WorksheetPart)
			 document.WorkbookPart.GetPartById(relationshipId);
		return worksheetPart;

	}

	// Given a worksheet, a column name, and a row index, 
	// gets the cell at the specified column and 
	public static Cell GetCell(Worksheet worksheet,
			  string columnName, uint rowIndex)
	{
		Row row = GetRow(worksheet, rowIndex);

		if (row == null)
			return null;

		return row.Elements<Cell>().Where(c => string.Compare
			   (c.CellReference.Value, columnName +
			   rowIndex, true) == 0).First();
	}


	// Given a worksheet and a row index, return the row.
	private static Row GetRow(Worksheet worksheet, uint rowIndex)
	{ 
			var rs = worksheet.GetFirstChild<SheetData>().
				  Elements<Row>().Where(r => r.RowIndex == rowIndex);
		
			if (rs.Count() > 0)
			{
				return rs.First();
			}
			else
			{
					return worksheet.GetFirstChild<SheetData>().
		  Elements<Row>().Where(r => r.RowIndex == rowIndex).First();
			}
	}
}