<Query Kind="Program">
  <Reference Relative="..\mvcx.dll">D:\dll\sa006\mvcx.dll</Reference>
  <Namespace>mvcx</Namespace>
</Query>

void Main()
{
	
	var applicationInstance = "sa006";
	var workingDirectory = @"D:\dll\sa006\lib";
	
	var stopProcessCmd = string.Format(@"c:\windows\system32\inetsrv\appcmd stop apppool /apppool.name:""{0}""",applicationInstance);
	
	var startProcessCmd = string.Format(@"c:\windows\system32\inetsrv\appcmd start apppool /apppool.name:""{0}""",applicationInstance);
	
	var buildCmd = @"C:\Windows\Microsoft.NET\Framework\v4.0.30319\csc.exe /warn:0 /r:../mvcx.dll /r:../JPush.dll /r:System.Drawing.dll /r:System.Runtime.Caching.dll /r:Microsoft.CSharp.dll /r:System.Net.dll /r:../WindowsBase.dll /r:System.dll /r:System.Web.dll /r:../System.Web.Mvc.dll /r:System.Security.dll /r:System.Net.Http.dll /r:../LINQPad.exe /r:../Newtonsoft.Json.dll /r:../Excel.dll /r:../DocumentFormat.OpenXml.dll /r:../CooWork.Core.dll /r:../CooWork.WcfCommon.dll /r:../CooWork.Distributed.CacheDTO.dll  /r:../BIZSAAS.COM.dll /r:../Alachisoft.NCache.Web.dll /r:../Alachisoft.NCache.Runtime.dll /r:../aliyun-net-sdk-core.dll /r:../aliyun-net-sdk-dysmsapi.dll  /t:library -out:mvcx.udf.dll udfOutput.cs -unsafe";
	
	ExecuteCommand(stopProcessCmd,@"c:\windows\system32\inetsrv");

	var qPath = Util.CurrentQueryPath;
	var dirPath = Path.GetDirectoryName(qPath);
	tool.LOG(qPath);

	var usingFile = dirPath + @"\using.cs";
	var outputFile = dirPath + @"\udfOutput.cs";

	tool.LOG("udf build");
	var content = string.Empty;
	using (StreamReader sr = new StreamReader(usingFile))
	{
		content = sr.ReadToEnd();
	}

	var files = Directory.GetFiles(dirPath);
	var rClass = new Regex(@"public[a-zA-Z\s]{0,20}class\s*?[a-zA-Z0-9_\s:]{1,40}[\s\n]*?\{(?>[^\{\}]+|\{(?<Open>)|\}(?<-Open>))*(?(Open)(?!))\}", RegexOptions.IgnoreCase);
	foreach (var f in files)
	{
		if (f.ToLower().EndsWith(".linq") && !f.ToLower().EndsWith("build.linq"))
		{

			using (StreamReader sr = new StreamReader(f))
			{
				var tempContent = sr.ReadToEnd();
			    MatchCollection mc = rClass.Matches(tempContent);
				foreach (Match m in mc)
				{

					content = content.Replace(@"//classPlaceHolder", @"//classPlaceHolder
					
					" + m.Value);
				}
			}
		}
	}

	using (StreamWriter sw = new StreamWriter(outputFile))
	{
		sw.Write(content);
	}

	if (File.Exists(dirPath + @"\mvcx.udf.dll"))
	{
		File.Delete(dirPath + @"\mvcx.udf.dll");
	}	
	
	var libPath = Regex.Replace(dirPath,@"lib\\*?$","");
	if (File.Exists(libPath + @"\mvcx.udf.dll"))
	{
		File.Delete(libPath + @"\mvcx.udf.dll");
	}
	ExecuteCommand(buildCmd,workingDirectory);
	
	if (File.Exists(dirPath + @"\mvcx.udf.dll"))
	{
		File.Move(dirPath + @"\mvcx.udf.dll" , libPath+ @"\mvcx.udf.dll" );
		
	}
	
	ExecuteCommand(startProcessCmd,@"c:\windows\system32\inetsrv");	
	"ok".Dump();


}

// Define other methods and classes here


public static void ExecuteCommand(string command,string workingDirectory)
{
	int exitCode;
	ProcessStartInfo processInfo;
	Process process;

	processInfo = new ProcessStartInfo("cmd.exe", "/c " + command);
	processInfo.CreateNoWindow = true;
	processInfo.UseShellExecute = false;
	
	processInfo.WorkingDirectory = workingDirectory;
	
	// *** Redirect the output ***
	processInfo.RedirectStandardError = true;
	processInfo.RedirectStandardOutput = true;

	process = Process.Start(processInfo);
	process.WaitForExit();

	// *** Read the streams ***
	// Warning: This approach can lead to deadlocks, see Edit #2
	string output = process.StandardOutput.ReadToEnd();
	string error = process.StandardError.ReadToEnd();

	exitCode = process.ExitCode;

	Console.WriteLine("output>>" + (String.IsNullOrEmpty(output) ? "(none)" : output));
	Console.WriteLine("error>>" + (String.IsNullOrEmpty(error) ? "(none)" : error));
	Console.WriteLine("ExitCode: " + exitCode.ToString(), "ExecuteCommand");
	process.Close();
}