<Query Kind="Program">
  <Reference Relative="BIZSAAS.COM.dll">D:\dll\sa006\BIZSAAS.COM.dll</Reference>
  <Reference Relative="CooWork.Core.dll">D:\dll\sa006\CooWork.Core.dll</Reference>
  <Reference Relative="CooWork.WcfCommon.dll">D:\dll\sa006\CooWork.WcfCommon.dll</Reference>
  <Reference Relative="mvcx.dll">D:\dll\sa006\mvcx.dll</Reference>
  <Reference Relative="mvcx.udf.dll">D:\dll\sa006\mvcx.udf.dll</Reference>
  <Reference Relative="Newtonsoft.Json.dll">D:\dll\sa006\Newtonsoft.Json.dll</Reference>
  <Reference>&lt;RuntimeDirectory&gt;\System.Net.dll</Reference>
  <Namespace>CooWork.Core</Namespace>
  <Namespace>CooWork.WcfCommon</Namespace>
  <Namespace>CooWork.WcfCommon.DTO</Namespace>
  <Namespace>mvcx</Namespace>
  <Namespace>mvcx.udf</Namespace>
  <Namespace>Newtonsoft.Json</Namespace>
  <Namespace>Newtonsoft.Json.Linq</Namespace>
  <Namespace>System.Net</Namespace>
</Query>

ReturnWrap Main(object[] args)
    {

        var ret = new ReturnWrap();
        ret.returnCode = "000007";
        ret.message = "000007";
        ret.returnType = 1;

        try
        {
		    var argsDic = args[0] as Dictionary<string,object>;
			

            
            var etor = argsDic["etor"] as string;
            var user = argsDic["user"] as cUser;
            var companyId = argsDic["companyId"]  as int?;
            var configurations = argsDic["configurations"] as List<CooConfigurationDTO>;


            //custom Code
            var centerSiteKey = configurations.FirstOrDefault(x => x.configuration_key == "centerSiteKey").configuration_value;


            //   tool.LOG(etor);
			dynamic obj = JObject.Parse(etor);
			if ((int?)obj.pageId == 75 )
            {
                var s2 = (string)obj.jsonStr;
                var s3 = JArray.Parse(s2);
				var pageName =string.Empty;
                foreach (dynamic j in s3)
                {                    
			            if (((string)j._Key) == "__c112")
			            {
			                pageName = (string)j._Value;
			            }
                }
				etor= etor.Replace("<<appPageName>>",pageName);
            }

            ret.data = tool.CrossSitePost(etor, centerSiteKey);
			
			
			 


          

            switch ((int?)obj.pageId)
            {
                case 75:
                    page_75(etor,configurations, ref ret);
                    break;
				case 76:
				    page_76(etor,ref ret);
				    break;
				case 363:
				   page_363(etor,configurations,ref ret);
				   break;
                default:

                    break;

            }





            return ret;

        }
        catch (Exception ee)
        {
            tool.LOG(ee);
            return ret;
        }


    }
	
	protected void page_363(string etor ,List<CooConfigurationDTO> configurations,ref ReturnWrap ret)
	{
	    var basePath = @"D:\dll\sa006\module";
		
		var appWebPath = @"E:\node\yunhaofang\design\mvcx\src";
 		var serverHeader = @"https://file5.mvcx.net/files/";
		
		var db_conn =  configurations.FirstOrDefault(x => x.configuration_key == "db_conn").configuration_value;
		
		DataSet ds = new DataSet();
		
		JToken token = JToken.Parse(ret.data);		
	    var jobj =  (JObject)JsonConvert.DeserializeObject(token.ToString());	
		foreach(var p  in jobj.Properties()){
			if (p.Name=="data"){			 
			   ds = JsonConvert.DeserializeObject<DataSet>(p.Value.ToString());			     
			}
		}     
		
	//todo:	SHOP.extractFrontend(ds,db_conn,appWebPath,serverHeader);
		 
	 
//	    var fullPath = 	SHOP.extractBackend(ds,basePath);
//		
//		 
//		
//		var ex = new { fullPath = fullPath };
//
//	    var r2 = BIZSAAS.COM.HTTPHelper.M.PostJSON(@"https://shop.bizsaas.com/create/backend", JsonConvert.SerializeObject(ex));
		 
	 
		
	}
	
	protected void page_76(string etor ,ref ReturnWrap ret)
	{
		 
				var path = @"E:\node\yunhaofang\design\mvcx\src";
				var configPath = @"E:\node\yunhaofang\design\mvcx\src\config\config.js";
				var configTxt = string.Empty;
				var pageName = string.Empty;
				dynamic obj = JObject.Parse(etor);
		     	var pageList =  new List<CooPageDTO>();
				
				if ((bool?)obj.preview == true)
				{
			
					var s2 = (string)obj.jsonStr;
					var s3 = JArray.Parse(s2);
					tool.LOG(s3);
					foreach (dynamic j in s3)
					{
						if (((string)j._Key) == "__c101")
						{
							var jsfile = (string)j._Value;
							jsfile = jsfile.Replace("..", "").Replace(@"/", @"\");
							var ic = Regex.Matches(jsfile, @"\\").Count;
							if (ic == 2)
							{
								jsfile += @"\index.js";
							}
							else
							{
								jsfile += ".js";
							}
							path += jsfile;
						}
						 if (((string)j._Key) == "__c112")
			            {
			                pageName = (string)j._Value;
			            }
						if (((string)j._Key) == "__c227")
						{
						  
							var pageJson = (string)j._Value;						
							if (!string.IsNullOrWhiteSpace(pageJson))
							{
								pageList = JsonConvert.DeserializeObject<List<CooPageDTO>>(pageJson);
							}
						}
					}
			
					foreach (dynamic j in s3)
					{
					 
						if (((string)j._Key) == "__c115" && path.EndsWith(".js"))
						{
			
							using (StreamWriter sw = new StreamWriter(path, false, Encoding.UTF8))
							{
								sw.Write((string)j._Value);
							}
						}
					}
	
			//替换config.js
					var mutexKey2 = MutexExample.GetFilePathMutexKey(configPath);
					MutexExample.MutexExec(mutexKey2, () =>
					{
						using (var reader = new StreamReader(configPath, Encoding.UTF8))
						{
							configTxt = reader.ReadToEnd();
						}
					});
			
					tool.LOG(pageList);

					if (pageList.Count == 0) return;
					configTxt = Regex.Replace(configTxt, @"((?!\d).)" + pageList[0].ID.ToString() + @"\s*?:\s*?\{[^\{\}]+\},?","") ;
					configTxt = Regex.Replace(configTxt, @"\d+\s*?:\s*?\{[^\{\}]+pages\/"+pageName+ @"\/[^\{\}]+\},?","") ;
			 		configTxt = Regex.Replace(configTxt, @"\/\/\/<\/router>",
				    string.Format(@"{0} : {{ title:'', categoryId:{1} ,router:'/pages/{2}/index' }},
					 ///</router>", pageList[0].ID.ToString(), pageList[0].categoryId, pageName)
					);
				 
					if (!string.IsNullOrWhiteSpace(configTxt))
					{
						MutexExample.MutexExec(mutexKey2, () =>
						{
							using (var writer = new StreamWriter(configPath, false, Encoding.UTF8))
							{
								writer.Write(configTxt);
							}
						});
					}
		}
	
	}






protected void page_75(string etor,List<CooConfigurationDTO> configurations, ref ReturnWrap ret)
{
	 
	dynamic obj = JObject.Parse(etor);
	
    var db_conn =  configurations.FirstOrDefault(x => x.configuration_key == "db_conn").configuration_value;

	var jsPath = @"E:\node\yunhaofang\design\mvcx\src\pages\";
	var routePath = @"E:\node\yunhaofang\design\mvcx\src\config\routes.js";
	
	
   var r1 =	mvcx.udf.SHOP.createModule(etor,db_conn);



	var s2 = (string)obj.jsonStr;
	var s3 = JArray.Parse(s2);
	var pageName = string.Empty;
	var pageContent = string.Empty;

	var datajson = string.Empty;

	foreach (dynamic j in s3)
	{
		if (((string)j._Key) == "__c362")
		{
			pageName = (string)j._Value;
		}
		if (((string)j._Key) == "__c365")
		{
			pageContent = (string)j._Value;
		}
		 

	}


	ret.returnCode = (string)r1.returnCode;
	ret.message = (string)r1.message;
	if (ret.returnCode == "000000" && !string.IsNullOrWhiteSpace(pageName) && !string.IsNullOrWhiteSpace(pageContent))
	{

		jsPath += pageName + @"\";
		var jsFile = jsPath + "index.js";
		if (File.Exists(jsFile)){
			ret.message= "文件名重复,请重新命名";
			ret.returnCode = "000003";
			return;
		}	
		
		if (!Directory.Exists(jsPath)) Directory.CreateDirectory(jsPath);
		using (StreamWriter sw = new StreamWriter(jsFile, false, Encoding.UTF8))
		{
			sw.Write(pageContent);
		}
		
		var routeTxt = string.Empty;

		var newImport = string.Format(@"///import {0} import {1} from '../pages/{1}'; ", System.Environment.NewLine, pageName);
		var newRoute = string.Format(@"///route {0} {1} :{{ path:'{1}',name:'/pages/{1}/index' ,screen : {1} }}, ", System.Environment.NewLine, pageName);

		var mutexKey = MutexExample.GetFilePathMutexKey(routePath);


		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var reader = new StreamReader(routePath, Encoding.UTF8))
			{
				routeTxt = reader.ReadToEnd();
			}
		});

		if (!routeTxt.Contains(string.Format(@"/pages/{0}/index", pageName)))
		{
			routeTxt = Regex.Replace(routeTxt, @"\/\/\/import", newImport);
			routeTxt = Regex.Replace(routeTxt, @"\/\/\/route", newRoute);
			MutexExample.MutexExec(mutexKey, () =>
			{
				using (var writer = new StreamWriter(routePath, false, Encoding.UTF8))
				{
					writer.Write(routeTxt);
				}
			});
		}




	}
}









public class  SHOPX
{

	



		public static string  extractBackend(DataSet ds ,string basePath)
		{

			var args = new List<object>();	 

			//
			//tables
			var tbs = (from c in ds.Tables[0].AsEnumerable()
					   select new CooCategoryDTO
					   {

						   categoryName = c.Field<string>("c263"),
						   eName = c.Field<string>("c264") + "_" + c.Field<Int64>("ID").ToString() + "_" + c.Field<string>("server_identity").ToString(),
						   property = c.Field<string>("c265"),
						   cOrder = (int?)c.Field<Int64?>("c267"),
						   status = c.Field<bool?>("c268")

					   }).ToList();
			args.Add(tbs);


			var columns = (from c in ds.Tables[1].AsEnumerable()
						   select new CooItemPatternDTO
						   {

							   categoryId = mapCategoryId(c.Field<string>("c281"), tbs),
							   eName = c.Field<string>("c275") + "_" + c.Field<Int64>("ID").ToString() + "_" + c.Field<string>("server_identity").ToString(),
							   isUnique = c.Field<bool?>("c279"),
							   pName = c.Field<string>("c274"),
							   property = c.Field<string>("c280"),
							   pTypeId = mapPTypeId(c.Field<Int64?>("c276")),
							   required = c.Field<bool?>("c278"),
							   validator = c.Field<string>("c277")

						   }).ToList();
			args.Add(columns);



			var joins = (from c in ds.Tables[2].AsEnumerable()
						 select new CooViewJoinDTO
						 {

							 baseId = (int?)c.Field<Int64?>("c440"),
							 categoryId = (int?)c.Field<Int64?>("c441"),
							 joinCategoryId = (int?)c.Field<Int64?>("c287"),
							 joinPatternId = (int?)c.Field<Int64?>("c288"),
							 viewPatternId = (int?)c.Field<Int64?>("c289"),
							 nRelation = mapRelation(c.Field<Int64?>("c286"))


						 }).ToList();
			args.Add(joins);


			var statGroups = (from c in ds.Tables[3].AsEnumerable()
							  select new CooStatusGroupDTO
							  {
								  ename = c.Field<string>("c442") + "_" + c.Field<Int64>("ID").ToString() + "_" + c.Field<string>("server_identity").ToString(),
								  name = c.Field<string>("c291")
							  }).ToList();
			args.Add(statGroups);


			var status = (from c in ds.Tables[4].AsEnumerable()
						  select new CooStatusDTO
						  {
							  data1 = c.Field<string>("c298"),
							  data2 = c.Field<string>("c299"),
							  parentId = (int?)c.Field<Int64?>("c296"),
							  groupId = mapStatGroup(c.Field<string>("c297"), statGroups),
							  statusName = c.Field<string>("c294"),
							  statusOrder = (int?)c.Field<Int64?>("c295"),
						  }).ToList();
			args.Add(status);


			var statusMap = (from c in ds.Tables[5].AsEnumerable()
							 select new CooStatusMapDTO
							 {
								 depth = (int?)c.Field<Int64?>("c305"),
								 groupId = mapStatGroup(c.Field<string>("c303"), statGroups),
								 init = c.Field<bool?>("c304"),
								 patternId = mapColumn1(c.Field<string>("c301"), columns)


							 }).ToList();

			args.Add(statusMap);




			var pages = (from c in ds.Tables[6].AsEnumerable()
						 select new CooPageDTO
						 {
							 categoryId = mapCategoryId(c.Field<string>("c310"), tbs),
							 dif = (int?)c.Field<Int64?>("c317") == 120 ? 5 : 0,
							 pageName = c.Field<string>("c312") + "_" + c.Field<Int64>("ID").ToString() + "_" + c.Field<string>("server_identity").ToString(),
							 pageOrder = (int?)c.Field<Int64?>("c316"),
							 pageProperty = c.Field<string>("c313"),
							 pageType = (short?)mapPageType(c.Field<Int64?>("c314")),
							 parentId = string.IsNullOrWhiteSpace(c.Field<string>("c315")) ? (int?)null : Convert.ToInt32(c.Field<string>("c315")),
							 UIname = c.Field<string>("c311")

						 }).ToList();
			args.Add(pages);


			var elements = (from c in ds.Tables[7].AsEnumerable()
							select new CooPageElementDTO
							{
								categoryId = mapCategoryId(c.Field<string>("c319"), tbs),
								pageId = mapPageId(c.Field<string>("c320"), pages),
								eorder = (int?)c.Field<Int64?>("c322"),
								patternId = mapColumn1(c.Field<string>("c321"), columns),
								property = c.Field<string>("c323")


							}).ToList();

			args.Add(elements);




			var events = (from c in ds.Tables[8].AsEnumerable()
						  select new CooPageEventDTO
						  {
							  eName = c.Field<string>("c444") + "_" + c.Field<Int64>("ID").ToString() + "_" + c.Field<string>("server_identity").ToString(),
							  eventSource = c.Field<string>("c327"),
							  eventType = mapEventType(c.Field<Int64?>("c326")),
							  pageId = mapPageId(c.Field<string>("c325"), pages),
							  pName = c.Field<string>("c443"),


						  }).ToList();

			args.Add(events);





			var menus = (from c in ds.Tables[9].AsEnumerable()
						 select new CooMenuDTO
						 {
							 eName = c.Field<string>("c333") + "_" + c.Field<Int64>("ID").ToString() + "_" + c.Field<string>("server_identity").ToString(),
							 icon = c.Field<string>("c336"),
							 morder = (int?)c.Field<Int64?>("c335"),
							 parentId = (int?)c.Field<Int64?>("c337"),
							 pName = c.Field<string>("c332"),
							 property = c.Field<string>("c338"),
							 url = c.Field<string>("c334")


						 }).ToList();

			args.Add(menus);



			var triggers = (from c in ds.Tables[10].AsEnumerable()
							select new CooTriggerDTO
							{
								eName = c.Field<string>("c445") + "_" + c.Field<Int64>("ID").ToString() + "_" + c.Field<string>("server_identity").ToString(),
								pName = c.Field<string>("c340"),
								triggerSource = c.Field<string>("c341"),
								triggerType = mapTriggerType(c.Field<Int64?>("c342")),
								categoryId =(int?)c.Field<Int64?>("c452")




							}).ToList();

			args.Add(triggers);
			
			
	        var gid = Guid.NewGuid();
			var path = basePath + @"\" + gid.ToString() + ".txt";

			using (StreamWriter sw = new StreamWriter(path, false, Encoding.UTF8))
			{	
				sw.Write(JsonConvert.SerializeObject(args));
			}
			
			
			return path;


 


		}





	public static int? mapTriggerType(Int64? i)
	{
		int? ret = null;
		switch (i)
		{
			case 124: ret = 1; break;
			case 125: ret = 2; break;
			case 126: ret = 3; break;
			case 127: ret = 4; break;
			case 128: ret = 5; break;
		}

		return ret;
	}




	public static int? mapEventType(Int64? i)
	{
		int? ret = null;
		switch (i)
		{
			case 121: ret = 1; break;
			case 122: ret = 2; break;
			case 123: ret = 3; break;
		}

		return ret;
	}


	public static int? mapRelation(Int64? i)
	{
		int? ret = null;
		switch (i)
		{
			case 90: ret = 1; break;
			case 92: ret = 2; break;
			case 91: ret = 3; break;
			case 93: ret = 4; break;

		}

		return ret;
	}


	public static int? mapStatGroup(string str, List<CooStatusGroupDTO> pats)
	{
		int? ret = null;
		var row = pats.FirstOrDefault(x => x.ename.Contains(str));
		if (row != null)
		{
			ret = Convert.ToInt32(Regex.Match(row.ename, @"(?<=_)\d+(?=_)").Value);
		}
		return ret;
	}

	public static int? mapColumn1(string baseIdStr, List<CooItemPatternDTO> pats)
	{
		int? ret = null;
		var row = pats.FirstOrDefault(x => x.eName.Contains(baseIdStr));
		if (row != null)
		{
			ret = Convert.ToInt32(Regex.Match(row.eName, @"(?<=_)\d+(?=_)").Value);
		}
		return ret;
	}


	public static int? mapPageType(Int64? i)
	{
		int? ret = null;
		switch (i)
		{
			case 94: ret = 2; break;
			case 95: ret = 3; break;
			case 96: ret = 5; break;
			case 97: ret = 6; break;
			case 98: ret = 7; break;
			case 99: ret = 8; break;
			case 100: ret = 9; break;
			case 101: ret = 10; break;
			case 102: ret = 11; break;
			case 103: ret = 12; break;
			case 104: ret = 13; break;
			case 105: ret = 14; break;
			case 106: ret = 15; break;
			case 107: ret = 16; break;
			case 108: ret = 17; break;
			case 109: ret = 18; break;
			case 110: ret = 19; break;
			case 111: ret = 20; break;
			case 112: ret = 22; break;
			case 113: ret = 31; break;
			case 114: ret = 99; break;
			case 115: ret = 100; break;
			case 116: ret = 101; break;
			case 117: ret = 102; break;
			case 118: ret = 103; break;

		}
		return ret;
	}



	public static int? mapPTypeId(Int64? i)
	{
		int? ret = null;
		switch (i)
		{
			case 70: ret = 1; break;
			case 71: ret = 2; break;
			case 72: ret = 3; break;
			case 73: ret = 4; break;
			case 74: ret = 5; break;
			case 75: ret = 6; break;
			case 76: ret = 7; break;
			case 77: ret = 10; break;
			case 78: ret = 11; break;
			case 79: ret = 12; break;
			case 80: ret = 13; break;
			case 81: ret = 16; break;
			case 82: ret = 17; break;
			case 83: ret = 18; break;
			case 84: ret = 19; break;
			case 85: ret = 20; break;
			case 86: ret = 22; break;
			case 87: ret = 23; break;
			case 88: ret = 24; break;
			case 89: ret = 26; break;

		}
		return ret;
	}


	public static int? mapPageId(string s, List<CooPageDTO> pages)
	{
		int? ret = null;
		var row = pages.FirstOrDefault(x => x.pageName.Contains(s));
		if (row != null)
		{
			ret = Convert.ToInt32(Regex.Match(row.pageName, @"(?<=_)\d+(?=_)").Value);
		}
		return ret;
	}


	public static int? mapCategoryId(string s, List<CooCategoryDTO> cates)
	{
		int? ret = null;
		var row = cates.FirstOrDefault(x => x.eName.Contains(s));
		if (row != null)
		{
			ret = Convert.ToInt32(Regex.Match(row.eName, @"(?<=_)\d+(?=_)").Value);
		}
		return ret;
	}


	//frontEndFunction

	public static void extractFrontend(DataSet ds, string db_conn ,string basePath,string serverHeader)
	{

	 
//		var basePath = @"E:\node\yunhaofang\design\mvcx\src";
//		var serverHeader = @"https://file5.mvcx.net/files/";

		var keyConfigTable = ds.Tables[13];
		var functionTable = ds.Tables[14];
		var pageTable = ds.Tables[12];
		var routerTable = ds.Tables[15];
		var themeTable = ds.Tables[16];
		var resourceTable = ds.Tables[17];	 
 

		var tbPage = makePage(pageTable, basePath, db_conn);

		makeKeyConfig(keyConfigTable, basePath);   //src/config.json

		var tbConfig = makeConfig(keyConfigTable, basePath, db_conn);   //config.js

		var tbFunction = makeFunction(functionTable, basePath, db_conn);

		makeRouter(routerTable, basePath);

		makeTheme(themeTable, basePath);

		var tbResource = makeResource(resourceTable, basePath, serverHeader);
		//https://file5.mvcx.net/files/

		var dst = new DataSet();

		dst.Tables.Add(tbPage.Copy());

		dst.Tables.Add(tbConfig.Copy());

		dst.Tables.Add(tbFunction.Copy());

		dst.Tables.Add(routerTable.Copy());

		dst.Tables.Add(themeTable.Copy());

		dst.Tables.Add(tbResource.Copy());

        updateFrontEndCode(dst,db_conn);

	}


	public static  DataTable makePage(DataTable dt, string basePath, string db_conn)
	{


		foreach (DataRow r in dt.Rows)
		{

			var file = basePath + @"\pages\" + r["c362"].ToString() + @"\index.js";
			var content = mapingPage(r["c365"].ToString(), db_conn);

			r["c365"] = content;

			if (File.Exists(file)) continue;
			
			var folder = Path.GetDirectoryName(file);			 
			if (!Directory.Exists(folder))
			{
				Directory.CreateDirectory(folder);
			}

			var mutexKey = MutexExample.GetFilePathMutexKey(file);

			MutexExample.MutexExec(mutexKey, () =>
			{
				using (var writer = new StreamWriter(file, false, Encoding.UTF8))
				{
					writer.Write(content);
				}
			});
		}

		return dt;

	}

	public static string mapingPage(string content, string db_conn)
	{

		//pageId
		var pageIds = new List<string>();
		var rpageId = new Regex(@"pageId\s*?(:|=)\s*?(\d+)", RegexOptions.IgnoreCase);
		var pageMc = rpageId.Matches(content);
		foreach (Match m in pageMc)
		{
			pageIds.Add(m.Groups[2].Value);
		}

		//patternId
		var patIds = new List<string>();
		var rpatId = new Regex(@"(__c|patternId\s*?[:=]\s*?)(\d+)", RegexOptions.IgnoreCase);
		var patMc = rpatId.Matches(content);
		foreach (Match m in patMc)
		{
			patIds.Add(m.Groups[2].Value);
		}


		//statusId
		var rstatusRow = new Regex(@"[^\n]+\/\/(\[{\s*?groupId[^\]]+\])", RegexOptions.IgnoreCase);
		var statusKv = new List<CooStatusDTO>();

		var mc = rstatusRow.Matches(content);
		foreach (Match m in mc)
		{
			var g1 = m.Groups[1].Value;
			var d = JArray.Parse(g1);
			foreach (dynamic dd in d)
			{
				var gid = (int?)dd.groupId;
				var statusId = (int?)dd.statusId;
				var statusName = (string)dd.statusName;
				var cv = new CooStatusDTO();
				cv.ID = statusId.Value;
				cv.groupId = gid;
				cv.statusName = statusName;
				statusKv.Add(cv);
			}
		}
		string where1 = " and ( 2=1 ";
		foreach (var p in pageIds)
		{
			where1 += string.Format("or  pageName like '%[_]{0}[_]%'  ", p);
		}
		where1 += " )";

		string where2 = " and ( 2=1 ";
		foreach (var p in patIds)
		{
			where2 += string.Format("or  eName like '%[_]{0}[_]%'  ", p);
		}
		where2 += " )";

		string where3 = " and ( 3=1";
		foreach (var p in statusKv)
		{
			where3 += string.Format(" or  (groupId = {0} and statusName ='{1}' ) ", p.groupId, p.statusName);
		}
		where3 += " ) ";


		var sql = string.Format(@"select * from CooPage where  1=1 {0}
	select *  from CooItemPattern where 2=2 {1}
	select *  from CooStatus where 3=3 {2}
	", where1, where2, where3);

		var ds = BIZSAAS.COM.SQLWrap.DataProvider.GetDataSet(sql, db_conn);



		Dictionary<string, string> dpage = new Dictionary<string, string>();
		foreach (DataRow dr in ds.Tables[0].Rows)
		{
			var p1 = Regex.Match(dr["pageName"].ToString(), @"_(\d+)_").Groups[1].Value;
			if (!string.IsNullOrWhiteSpace(p1))
			{
				dpage.Add(p1, dr["ID"].ToString());
			}
		}

		Dictionary<string, string> dpat = new Dictionary<string, string>();
		foreach (DataRow dr in ds.Tables[1].Rows)
		{
			var p1 = Regex.Match(dr["eName"].ToString(), @"_(\d+)_").Groups[1].Value;
			if (!string.IsNullOrWhiteSpace(p1))
			{
				dpat.Add(p1, dr["ID"].ToString());
			}
		}

		var lstat = new List<CooStatusDTO>();

		lstat = (from c in ds.Tables[2].AsEnumerable()
				 select new CooStatusDTO
				 {
					 ID = c.Field<int>("ID"),
					 groupId = c.Field<int?>("groupId"),
					 statusName = c.Field<string>("statusName")
				 }).ToList();


		content = Regex.Replace(content, @"pageId\s*?(:|=)\s*?(\d+)", delegate (Match match)
						  {
						  	  if (dpage.ContainsKey(match.Groups[2].Value)){
							  	return string.Format(@"pageId {0} {1}", match.Groups[1].Value, dpage[match.Groups[2].Value]);
							  }
							  else{
							    tool.LOG("dicPage error "+ match.Groups[2].Value);
							  	return match.Value;
							  }						  	
							  
						  });

		content = Regex.Replace(content, @"(__c|patternId\s*?[:=]\s*?)(\d+)", delegate (Match match)
					   {
					   	   if (dpat.ContainsKey(match.Groups[2].Value)){
						     	return string.Format(@"{0} {1}", match.Groups[1].Value, dpat[match.Groups[2].Value]);
						   }
						   else
						   {
							   tool.LOG("dicPat error " + match.Groups[2].Value);
							   return match.Value;
						   }
						   
					   });


		content = Regex.Replace(content, @"[^\n]+\/\/(\[{\s*?groupId[^\]]+\])", delegate (Match match)
						 {
							 var g1 = match.Groups[1].Value;
							 var d = JArray.Parse(g1);
							 var rx = string.Empty;
							 foreach (dynamic dd in d)
							 {
								 var gid = (int?)dd.groupId;
								 var statusId = (int?)dd.statusId;
								 var statusName = (string)dd.statusName;
								 var nid = lstat.FirstOrDefault(x => x.groupId == gid && x.statusName == statusName).ID;
								 rx = Regex.Replace(match.Value, @" " + statusId + " ", " " + nid + " ");
							 }

							 return match.Value;
						 });






		return content;

	}


	public static void makeKeyConfig(DataTable dt, string basePath)
	{

		var path = basePath += @"\config.json";



		var json = string.Empty;


		var mutexKey = MutexExample.GetFilePathMutexKey(path);
		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var reader = new StreamReader(path, Encoding.UTF8))
			{
				json = reader.ReadToEnd();
			}
		});
		
	//	tool.LOG(json);


		var lkv = new List<KeyValuePair<string, object>>();
		foreach (DataRow dr in dt.Rows)
		{
			if (dr["c439"].ToString() == "41")
			{
				object jobj = null;
			    if (dr["c382"].ToString().IsDouble())
				{
					jobj = Convert.ToDecimal(dr["c382"].ToString());
				}
				else if (dr["c382"].ToString().IsInt())
				{
					jobj = Convert.ToInt32(dr["c382"].ToString());
				}
				else
				{
					jobj = dr["c382"].ToString();
				}

				lkv.Add(new KeyValuePair<string, object>(dr["c381"].ToString(), jobj));
			}
		}


		json = replaceJsonFirstLevelProperty(json, lkv);


		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var writer = new StreamWriter(path, false, Encoding.UTF8))
			{
				writer.Write(json);
			}
		});


	}


	public static string replaceJsonFirstLevelProperty(string json, List<KeyValuePair<string, object>> lkv)
	{
	 

		var jobj = (JObject)JsonConvert.DeserializeObject(json);
		
		 
		 
	 

		foreach (var kv in lkv)
		{

			if (!jobj.Properties().Select(x => x.Name).Contains(kv.Key))
			{

				if (kv.Value.ToString().StartsWith("{"))
				{
					jobj[kv.Key] = JsonConvert.DeserializeObject<JObject>(kv.Value.ToString());
				}
				else if (kv.Value.ToString().StartsWith("["))
				{
					jobj[kv.Key] = JsonConvert.DeserializeObject<JArray>(kv.Value.ToString());
				}
				else
				{
					jobj[kv.Key] = new JValue(kv.Value);
				}

				continue;
			}


			foreach (var p in jobj.Properties())
			{
				if (p.Name == kv.Key)
				{
					var vtype = p.Value.GetType().ToString();
					switch (vtype)
					{
						case "Newtonsoft.Json.Linq.JValue":
						     tool.LOG(kv.Value);
							p.Value = new JValue(kv.Value);
							break;
						case "Newtonsoft.Json.Linq.JArray":
						    tool.LOG(kv.Value);
							p.Value = JsonConvert.DeserializeObject<JArray>(kv.Value.ToString());

							break;
						case "Newtonsoft.Json.Linq.JObject":
						    tool.LOG(kv.Value);
							p.Value = JsonConvert.DeserializeObject<JObject>(kv.Value.ToString());

							break;

					}
				}

			}
		}



		return JsonConvert.SerializeObject(jobj);
	}




	
	public static DataTable makeConfig(DataTable dt, string basePath, string db_conn)
	{

		var path = basePath += @"\config\config.js";

		var json = string.Empty;

		var mutexKey = MutexExample.GetFilePathMutexKey(path);
		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var reader = new StreamReader(path, Encoding.UTF8))
			{
				json = reader.ReadToEnd();
			}
		});

		var lkv = new List<KeyValuePair<string, object>>();
		var lkvPage = new List<KeyValuePair<string, object>>();

		var mockContent = string.Empty;


		foreach (DataRow dr in dt.Rows)
		{
			if (dr["c439"].ToString() == "44")
			{
				mockContent += string.Format(@"pageId : {0} 
				{1}", dr["c381"].ToString(), dr["c382"].ToString());

			}
			else
			{
				mockContent += string.Format(@"{0}  :
				{1}", dr["c381"].ToString(), dr["c382"].ToString());

			}

		}


		var cppsOriginalList = get_category_page_column_status_list(mockContent);
		var cppsNewList = category_page_column_status_dic(cppsOriginalList, db_conn);

		var dcategory = cppsNewList[0] as Dictionary<string, string>;
		var dpage = cppsNewList[1] as Dictionary<string, string>;
		var dpat = cppsNewList[2] as Dictionary<string, string>;
		var dstatus = cppsNewList[3] as Dictionary<string, string>;


		foreach (DataRow dr in dt.Rows)
		{
			if (dr["c439"].ToString() == "44" || dr["c439"].ToString() == "42" || dr["c439"].ToString() == "43")
			{
				dr["c382"] = mappingContent(cppsNewList, dr["c382"].ToString());

				object jobj = null;
				if (dr["c382"].ToString().IsDouble())
				{
					jobj = Convert.ToDecimal(dr["c382"].ToString());
				}
				else if (dr["c382"].ToString().IsInt())
				{
					jobj = Convert.ToInt32(dr["c382"].ToString());
				}
				else
				{
					jobj = dr["c382"].ToString();
				}

				if (dr["c439"].ToString() == "44")
				{
					if (dpage.ContainsKey(dr["c381"].ToString())){
						dr["c381"] = dpage[dr["c381"].ToString()];
						lkvPage.Add(new KeyValuePair<string, object>(dpage[dr["c381"].ToString()], jobj));
					}		
					
					
				}
				else
				{
					lkv.Add(new KeyValuePair<string, object>(dr["c381"].ToString(), jobj));
				}
			}

		}


		json = Regex.Replace(json, @"baseConfig\.[a-zA-Z0-9]+", delegate (Match match)
				  {					   
					  return @"""" + match.Value + @"""";
				  });


		json = Regex.Replace(json, @"(?<=const\s*?defaultConfig\s*?=\s*?)([\s\S]+)(?=;[\s\n]*?export\s*?const\s*configSetting)", delegate (Match match)
					  {
						  var content = match.Groups[1].Value;
						  JObject jcObj = JsonConvert.DeserializeObject<JObject>(content);
						  var j2 = (JObject)jcObj["router"];
						  var j2Str = replaceJsonFirstLevelProperty(JsonConvert.SerializeObject(j2), lkvPage);
						  lkv.Add(new KeyValuePair<string, object>("router", j2Str));

						  return replaceJsonFirstLevelProperty(content, lkv);
					  });

		json = Regex.Replace(json, @"""(baseConfig\.[a-zA-Z0-9]+)""", delegate (Match match)
			  {
				  return  match.Groups[1].Value;
			  });



		//   const\s*?defaultConfig\s*?=\s*?([\s\S]+);[\s\n]*?export\s*?const\s*configSetting



		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var writer = new StreamWriter(path, false, Encoding.UTF8))
			{
				writer.Write(json);
			}
		});

		return dt;


	}



	public static List<object> get_category_page_column_status_list(string content)
	{
		var ret = new List<object>();


		//pageId
		var pageIds = new List<string>();
		var rpageId = new Regex(@"pageId\s*?(:|=)\s*?(\d+)", RegexOptions.IgnoreCase);
		var rpageId2 = new Regex(@"(\d+)\s*?:\s*?\{", RegexOptions.IgnoreCase);
		var pageMc = rpageId.Matches(content);
		var pageMc2 = rpageId2.Matches(content);
		foreach (Match m in pageMc)
		{
			pageIds.Add(m.Groups[2].Value);
		}
		foreach (Match m in pageMc2)
		{
			pageIds.Add(m.Groups[1].Value);
		}

		//patternId
		var patIds = new List<string>();
		var rpatId = new Regex(@"ID\s*?:\s*?(\d+)");  //大写
		var rpatId2 = new Regex(@"excludes\s*?:\s*?\[([\d,\s]+)\]", RegexOptions.IgnoreCase);
		var rpatId3 = new Regex(@"__c(\d+)", RegexOptions.IgnoreCase);
		var patMc = rpatId.Matches(content);
		var patMc2 = rpatId2.Matches(content);
		var patMc3 = rpatId3.Matches(content);
		foreach (Match m in patMc)
		{
			patIds.Add(m.Groups[1].Value);
		}
		foreach (Match m in patMc2)
		{
			var ags = m.Groups[1].Value.Split(',');
			foreach (var ag in ags)
			{
				patIds.Add(ag.Trim());
			}
		}
		foreach (Match m in patMc3)
		{
			patIds.Add(m.Groups[1].Value);
		}

		//categoryId
		var categoryIds = new List<string>();
		var rcategoryId = new Regex(@"categoryId\s*?:\s*?(\d+)", RegexOptions.IgnoreCase);
		var categoryMc = rcategoryId.Matches(content);
		foreach (Match m in categoryMc)
		{
			categoryIds.Add(m.Groups[1].Value);
		}


		//statusId
		var rstatusRow = new Regex(@"[^\n]+\/\/(\[{\s*?groupId[^\]]+\])", RegexOptions.IgnoreCase);
		var statusKv = new List<CooStatusDTO>();

		var mc = rstatusRow.Matches(content);
		foreach (Match m in mc)
		{
			var g1 = m.Groups[1].Value;
			var d = JArray.Parse(g1);
			foreach (dynamic dd in d)
			{
				var gid = (int?)dd.groupId;
				var statusId = (int?)dd.statusId;
				var statusName = (string)dd.statusName;
				var cv = new CooStatusDTO();
				cv.ID = statusId.Value;
				cv.groupId = gid;
				cv.statusName = statusName;
				statusKv.Add(cv);
			}
		}

		ret.Add(categoryIds);
		ret.Add(pageIds);
		ret.Add(patIds);
		ret.Add(statusKv);

		return ret;
	}


	public static List<object> category_page_column_status_dic(List<object> args, string db_conn)
	{
		var pageIds = args[0] as List<string>;
		var patIds = args[1] as List<string>;
		var categoryIds = args[2] as List<string>;
		var statusKv = args[3] as List<CooStatusDTO>;


		if (pageIds.Count == 0 && patIds.Count == 0 && categoryIds.Count == 0 && statusKv.Count == 0)
		{
			var ret2 = new List<object>();
			ret2.Add(new Dictionary<string, string>());
			ret2.Add(new Dictionary<string, string>());
			ret2.Add(new Dictionary<string, string>());
			ret2.Add(new Dictionary<string, string>());
			return ret2;
		}


		string where1 = " and ( 2=1 ";
		foreach (var p in pageIds)
		{
			where1 += string.Format("or  pageName like '%[_]{0}[_]%'  ", p);
		}
		where1 += " )";

		string where2 = " and ( 2=1 ";
		foreach (var p in patIds)
		{
			where2 += string.Format("or  eName like '%[_]{0}[_]%'  ", p);
		}
		where2 += " )";

		string where3 = " and ( 3=1";
		foreach (var p in categoryIds)
		{
			where3 += string.Format("or  eName like '%[_]{0}[_]%'  ", p);
		}
		where3 += " ) ";


		string where4 = " and ( 4=1";
		foreach (var p in statusKv)
		{
			where4 += string.Format(" or  (groupId = {0} and statusName ='{1}' ) ", p.groupId, p.statusName);
		}
		where4 += " ) ";





		var sql = string.Format(@"select * from CooPage where  1=1 {0}
	select *  from CooItemPattern where 2=2 {1}
	select *  from CooCategory where 3=3 {2}
	select *  from CooStatus where 4=4 {3}
	", where1, where2, where3, where4);

		var ds = BIZSAAS.COM.SQLWrap.DataProvider.GetDataSet(sql, db_conn);


		//tidi



		Dictionary<string, string> dpage = new Dictionary<string, string>();
		foreach (DataRow dr in ds.Tables[0].Rows)
		{
			var p1 = Regex.Match(dr["pageName"].ToString(), @"_(\d+)_").Groups[1].Value;
			if (!string.IsNullOrWhiteSpace(p1))
			{
				dpage.Add(p1, dr["ID"].ToString());
			}
		}

		Dictionary<string, string> dpat = new Dictionary<string, string>();
		foreach (DataRow dr in ds.Tables[1].Rows)
		{
			var p1 = Regex.Match(dr["eName"].ToString(), @"_(\d+)_").Groups[1].Value;
			if (!string.IsNullOrWhiteSpace(p1))
			{
				dpat.Add(p1, dr["ID"].ToString());
			}
		}


		Dictionary<string, string> dcategory = new Dictionary<string, string>();
		foreach (DataRow dr in ds.Tables[2].Rows)
		{
			var p1 = Regex.Match(dr["eName"].ToString(), @"_(\d+)_").Groups[1].Value;
			if (!string.IsNullOrWhiteSpace(p1))
			{
				dcategory.Add(p1, dr["ID"].ToString());
			}
		}


		Dictionary<string, string> dstatus = new Dictionary<string, string>();
		foreach (DataRow dr in ds.Tables[3].Rows)
		{
			var p2 = statusKv.FirstOrDefault(x => x.groupId.ToString() == dr["groupId"].ToString() && x.statusName == dr["statusName"].ToString());
			if (p2 != null)
			{
				dstatus.Add(p2.ID.ToString(), dr["ID"].ToString());
			}
		}




		var ret = new List<object>();
		ret.Add(dcategory);
		ret.Add(dpage);
		ret.Add(dpat);
		ret.Add(dstatus);


		return ret;


	}



	public static string mappingContent(List<object> cppsNewList, string content)
	{

		var dcategory = cppsNewList[0] as Dictionary<string, string>;
		var dpage = cppsNewList[1] as Dictionary<string, string>;
		var dpat = cppsNewList[2] as Dictionary<string, string>;
		var dstatus = cppsNewList[3] as Dictionary<string, string>;

		var rcategoryId = new Regex(@"categoryId\s*?:\s*?(\d+)", RegexOptions.IgnoreCase);

		var rpageId = new Regex(@"pageId\s*?(:|=)\s*?(\d+)", RegexOptions.IgnoreCase);
		var rpageId2 = new Regex(@"(\d+)\s*?:\s*?\{", RegexOptions.IgnoreCase);

		var rpatId = new Regex(@"ID\s*?:\s*?(\d+)");  //大写
		var rpatId2 = new Regex(@"excludes\s*?:\s*?\[([\d,\s]+)\]", RegexOptions.IgnoreCase);
		var rpatId3 = new Regex(@"__c(\d+)", RegexOptions.IgnoreCase);

		var rstatusRow = new Regex(@"[^\n]+\/\/(\[{\s*?groupId[^\]]+\])", RegexOptions.IgnoreCase);

		//categoryId
		content = Regex.Replace(content, @"categoryId\s*?:\s*?(\d+)", delegate (Match match)
					  {  
					  	 if (dcategory.ContainsKey(match.Groups[1].Value)){
						 	 return string.Format(@"categoryId : {0}", dcategory[match.Groups[1].Value]);
						 }
						 else{
						     tool.LOG("dcategory" + match.Groups[1].Value);
						 	 return  match.Value;							 
						 }				
					  	  
						 
					  });

		//pageId
		content = Regex.Replace(content, @"pageId\s*?(:|=)\s*?(\d+)", delegate (Match match)
						  {
						  	 
							  if (dpage.ContainsKey(match.Groups[2].Value)){
							  	 return string.Format(@"pageId {0} {1}", match.Groups[1].Value, dpage[match.Groups[2].Value]);
							  }
							  else{

								  tool.LOG("dpage" + match.Groups[2].Value);
								  return match.Value;
							  } 					  
							  
						  });

		content = Regex.Replace(content, @"(\d+)\s*?:\s*?\{", delegate (Match match)
					  {
						  if (dpage.ContainsKey(match.Groups[1].Value))
						  {
						    	return string.Format(@"{0} : {{", dpage[match.Groups[1].Value]);							 
						  }
						  else
						  {
							  tool.LOG("dpage" + match.Groups[1].Value);
							  return match.Value;
						  }					  
					  });


		//	var rpatId = new Regex(@"ID\s*?:\s*?(\d+)");  //大写
		//	var rpatId2 = new Regex(@"excludes: \[([\d,\s]+)\]", RegexOptions.IgnoreCase);
		//	var rpatId3 = new Regex(@"__c(\d+)", RegexOptions.IgnoreCase);

		content = Regex.Replace(content, @"ID\s*?:\s*?(\d+)", delegate (Match match)
					  {
					  	  if (dpat.ContainsKey(match.Groups[1].Value)){
						  	 return string.Format(@"ID : {0}", dpat[match.Groups[1].Value]);
						  }
						  else
						  {
						  	  tool.LOG("dpat" + match.Groups[1].Value);
							  return match.Value;
						  }					
						 
					  });

		content = Regex.Replace(content, @"excludes\s*?:\s*?\[([\d,\s]+)\]", delegate (Match match)
				  {
				  	  
					
					  var ags = match.Groups[1].Value.Split(',');
					  
					  foreach(var c in ags){
					  	if (!dpat.ContainsKey(c)){
						    tool.LOG("dpat" + c);
							return match.Value;
						}
					  }
					  
					  var ags2 = (from c in ags
								  select dpat[c]).ToList();

					  return string.Format(@"excludes : [{0}]", string.Join(",", ags2));				  
					  
				  });

		content = Regex.Replace(content, @"__c(\d+)", delegate (Match match)
					  {
					  	  if (dpat.ContainsKey(match.Groups[1].Value)){
						  	 return string.Format(@"__c{0}", dpat[match.Groups[1].Value]);
						  }
						  else
						  {
							  tool.LOG("dpat" + match.Groups[1].Value);
							  return match.Value;
						  }
						
						 
					  });


		content = Regex.Replace(content, @"[^\n]+\/\/(\[{\s*?groupId[^\]]+\])", delegate (Match match)
					 {
						 var g1 = match.Groups[1].Value;
						 var d = JArray.Parse(g1);
						 var rx = string.Empty;
						 foreach (dynamic dd in d)
						 {
							 var statusId = (int?)dd.statusId;					 
							 if (dstatus.ContainsKey(statusId.ToString())){
							 	 rx = Regex.Replace(match.Value, @" " + statusId + " ", " " + dstatus[statusId.ToString()] + " ");
							 }
							 else{
							 	
								tool.LOG("dstatus"+ statusId);								
							 }			 
							 
						 }

						 return rx;
					 });



		return content;
	}


	public static DataTable makeFunction(DataTable dt, string basePath, string db_conn)
	{

		var path = basePath += @"\config\request.js";

		var content = string.Empty;
		var mutexKey = MutexExample.GetFilePathMutexKey(path);
		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var reader = new StreamReader(path, Encoding.UTF8))
			{
				content = reader.ReadToEnd();
			}
		});

		var mockContent = string.Empty;
		foreach (DataRow dr in dt.Rows)
		{
			if (string.IsNullOrWhiteSpace(dr["c391"].ToString())) continue;
			mockContent += dr["c391"].ToString() + @"
		 
		 ";
		}

		var cppsOriginalList = get_category_page_column_status_list(mockContent);
		var cppsNewList = category_page_column_status_dic(cppsOriginalList, db_conn);




		foreach (DataRow dr in dt.Rows)
		{
			if (string.IsNullOrWhiteSpace(dr["c391"].ToString())) continue;

			dr["c391"] = mappingContent(cppsNewList, dr["c391"].ToString());

			var newFunc = dr["c391"].ToString();
			var funcName = Regex.Match(dr["c391"].ToString(), @"^[^\(]+").Value;

			content = Regex.Replace(content, funcName + @"\s*?\([^\{]+\{(?>[^\{\}]+|\{(?<Open>)|\}(?<-Open>))*(?(Open)(?!))\}", "");

			content = Regex.Replace(content, @"export\s*?default\s*?\{", @"
		 export default {
		 " + newFunc + @",
		 ");

		}

		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var writer = new StreamWriter(path, false, Encoding.UTF8))
			{
				writer.Write(content);
			}
		});

		return dt;

	}




	public static void makeRouter(DataTable dt, string basePath)
	{
		var file = basePath + @"\config\routes.js";
		var content = string.Empty;
		var mutexKey = MutexExample.GetFilePathMutexKey(file);

		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var writer = new StreamWriter(file, false, Encoding.UTF8))
			{
				writer.Write(content);
			}
		});

		foreach (DataRow r in dt.Rows)
		{
			var routerName = Regex.Match(r["c406"].ToString(), @"(?<=screen\s*?:\s*?)[^\{\s]+", RegexOptions.IgnoreCase).Value;


			content = Regex.Replace(content, @"import\s*?" + routerName + "[^\n]+", "");
			content = Regex.Replace(content, routerName + @"\s*?:\s*?\{[^\n]+ ", "");

			content = Regex.Replace(content, @"^", string.Format(@"import {0} from '{1}';", routerName, r["c404"].ToString()));
			content = Regex.Replace(content, @"const\s*?routes\s*?=\s*?\{", string.Format(@"const routers = {{
		 {0} : {1},
		", routerName, r["c406"].ToString()));

		}

		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var writer = new StreamWriter(file, false, Encoding.UTF8))
			{
				writer.Write(content);
			}
		});


	}



	public static void makeTheme(DataTable dt, string basePath)
	{

		var file = basePath + @"\config\theme.js";
		var content = string.Empty;
		var mutexKey = MutexExample.GetFilePathMutexKey(file);

		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var writer = new StreamWriter(file, false, Encoding.UTF8))
			{
				writer.Write(content);
			}
		});

		foreach (DataRow r in dt.Rows)
		{
			var themeName = r["c413"].ToString();


			content = Regex.Replace(content, @"'\s*?\." + themeName + @"'\s*?:\s*?\{(?>[^\{\}]+|\{(?<Open>)|\}(?<-Open>))*(?(Open)(?!))\},?", "", RegexOptions.IgnoreCase);

			content = Regex.Replace(content, @"export\s*?default\s*?\{", string.Format(@"export default {{
		 '{0}' : {1},
		", themeName, r["c416"].ToString()));

		}

		MutexExample.MutexExec(mutexKey, () =>
		{
			using (var writer = new StreamWriter(file, false, Encoding.UTF8))
			{
				writer.Write(content);
			}
		});


	}



	public static DataTable makeResource(DataTable dt, string basePath, string serverHeader)
	{
		//1000\2018115\8f65108e-f614-4414-bd07-0ea49899b39b.png

		foreach (DataRow r in dt.Rows)
		{
			var url = serverHeader + r["objc429"].ToString().Replace(@"\", @"/");
			r["objc429"] = url;

			var fileName = basePath + @"\images\" + r["c427"].ToString();

			if (!File.Exists(fileName))
			{

				using (var client = new WebClient())
				{
					client.DownloadFile(url, fileName);
				}

			}
		}

		return dt;
	}


	public static void insertDataTable2Database(DataTable dt, string destinationTableName, List<string> ignoreCols, string db_conn)
	{
		//c372
		var dtConv = new DataTable();
		foreach (DataColumn col in dt.Columns)
		{ 
			if (col.ColumnName=="server_identity" || col.ColumnName =="c372")
			{
				dtConv.Columns.Add(col.ColumnName,typeof(Guid));
			}
			else{
				dtConv.Columns.Add(col.ColumnName, col.DataType);
			}			 
		}
		
		foreach(DataRow dr in dt.Rows){
			var dr2 = dtConv.NewRow();
			foreach (DataColumn col in dtConv.Columns)
			{
				if (col.ColumnName == "server_identity" || col.ColumnName == "c372")
				{
					dr2[col.ColumnName]  = dr[col.ColumnName]!= DBNull.Value ? new Guid(dr[col.ColumnName].ToString()): Guid.Empty;
				}
				else
				{
					dr2[col.ColumnName]  = dr[col.ColumnName];
				}

			}
			dtConv.Rows.Add(dr2);
		}




		using (var bulkCopy = new SqlBulkCopy(db_conn))
		{
			// my DataTable column names match my SQL Column names, so I simply made this loop. However if your column names don't match, just pass in which datatable name matches the SQL column name in Column Mappings
			foreach (DataColumn col in dtConv.Columns)
			{
				if (!ignoreCols.Contains(col.ColumnName))
				{
					bulkCopy.ColumnMappings.Add(col.ColumnName, col.ColumnName);
				}
			}

			bulkCopy.BulkCopyTimeout = 600;
			bulkCopy.DestinationTableName = destinationTableName;
			bulkCopy.WriteToServer(dtConv);
		}

	}



	public static void bulkInsertAppTable(DataTable pageTable, string destTableName, List<string> ignoreCols, string db_conn)
	{
		var pageGids = (from c in pageTable.AsEnumerable()
						select c.Field<string>("server_identity")).ToList();
		pageGids.Add(Guid.Empty.ToString());


		var xGidsTable = BIZSAAS.COM.SQLWrap.DataProvider.GetDataTable(string.Format(@"
	select server_identity from {0} where  server_identity in ('{1}')
	", destTableName, string.Join("','", pageGids)), db_conn);
		var xGidsList = (from c in xGidsTable.AsEnumerable()
						 select c.Field<Guid?>("server_identity").Value.ToString()).ToList();

		for (int i = pageTable.Rows.Count - 1; i >= 0; i--)
		{
			DataRow dr = pageTable.Rows[i];
			if (xGidsList.Contains(dr["server_identity"].ToString()))
				pageTable.Rows.Remove(dr);
		}
		pageTable.AcceptChanges();

		insertDataTable2Database(pageTable, destTableName, ignoreCols, db_conn);
	}




	//serverSide
	public static void updateFrontEndCode(DataSet ds, string db_conn)
	{


		var pageTable = ds.Tables[0];
		var configTable = ds.Tables[1];
		var functionTable = ds.Tables[2];
		var routerTable = ds.Tables[3];
		var themeTable = ds.Tables[4];
		var resourceTable = ds.Tables[5];

		var ignoreCols = new List<string>();
		ignoreCols.Add("ID");
		bulkInsertAppTable(pageTable, "CooWork_100037", ignoreCols, db_conn);
		bulkInsertAppTable(configTable, "CooWork_100039", ignoreCols, db_conn);
		bulkInsertAppTable(functionTable, "CooWork_100041", ignoreCols, db_conn);
		bulkInsertAppTable(routerTable, "CooWork_100043", ignoreCols, db_conn);
		bulkInsertAppTable(themeTable, "CooWork_100045", ignoreCols, db_conn);
		bulkInsertAppTable(resourceTable, "CooWork_100047", ignoreCols, db_conn);







	}




	//frontEndFunction  }}}}  }}}}   }}}}   }}}} }}}}  }}    正则匹配修正

}