import Reg from '../utils/reghelper';
import config from './config';

export default {
  emitReq(component, req, params, callback, messages) {
    messages || (messages = {});
    component.emit('req', component.page, req, params, callback, messages.valid, messages.prompt, messages.success);
  },
  emitReqRefresh(component, req, params, callback, messages, updateData) {
    this.emitReq(component, req, params, (ret)=> {
      let deleteData = null;

      if (req === 'fakeDel') {
        deleteData = params.ids;
      }

      const router = config.router[component.getOption('pageId')] || {};
      const viewRouter = config.router[component.getOption('viewPageId')] || {};
      const myIdColumn = router.myIdColumn || router.idColumn || viewRouter.idColumn;
      component.emit('refresh_data', null, myIdColumn, updateData, deleteData);
      callback && callback(ret);
    }, messages);
  },
// ===========================================
  makeOrder(component, item, related) {

  },
  buyGoods(component, items, callback) {
    items = items.map(item => ([{ _Key: '__c91', _Value: item.__c22 }, { _Key: '__c92', _Value: item.__c92 || 1 }]));

    this.emitReq(component, 'bulkCreate', { pageId: 222, jsonStr: items }, callback, {
      valid: '请至少选择一件商品',
      success: '商品被加入到了购物车中'
    });
  },
  importGoods(component, items, callback) {
    items = items.map(item => ([{ _Key: '__c176', _Value: item.__c22 }]));

    this.emitReq(component, 'bulkCreate', { pageId: 205, jsonStr: items }, callback, {
      valid: '请至少选择一件商品',
      success: '商品被成功引入到了你的商品列表中'
    });
  },
  buyGood(component, item, callback) {
    const jsonStr = [];
    jsonStr.push({
      _Key: '__c197',
      _Value: item.__c197 || 1
    });
    jsonStr.push({
      _Key: '__c196',
      _Value: item.server_identity
    });
    // jsonStr.push({
    //   _Key: '__c199',
    //   _Value: item.__c64
    // });
    jsonStr.push({
      _Key: '__c316',
      _Value: item.__c316
    });
    jsonStr.push({
      _Key: '__c317',
      _Value: item.__c317
    });

    this.emitReqRefresh(component, 'createUpdate', {
      jsonStr,
      pageId: 116
    }, callback, {
      success: '您将该商品加入了购物车'
    });
  },
  collectGood(component, item, callback) {
    const jsonStr = [];
    jsonStr.push({
      _Key: '__c204',
      _Value: item.server_identity
    });

    this.emitReq(component, 'createUpdate', {
      jsonStr,
      pageId: 123
    }, callback, {
      success: '您收藏了该商品'
    });
  },
  collectGoods(component, items, callback) {
    items = items.map(item => ([{ _Key: '__c99', _Value: item.__c22 }]));

    this.emitReq(component, 'bulkCreate', { pageId: 223, jsonStr: items }, callback, {
      valid: '请至少选择一件商品',
      success: '商品被您收藏了'
    });
  },
  deleteGoods(component, items, callback) {
    this.emitReqRefresh(component, 'fakeDel', { categoryId: 4, ids: items.map(item => item.__c22) }, callback, {
      valid: '请至少选择一件商品',
      prompt: '确认删除商品?',
      success: '商品被删除了'
    });
  },
  deleteCollect(component, items, callback) {
    this.emitReqRefresh(component, 'fakeDel', { categoryId: 17, ids: items.map(item => item.__c201) }, callback, {
      valid: '请至少选择一件商品',
      prompt: '确认删除收藏的商品?',
      success: '商品收藏被取消了'
    });
  },
  deleteImport(component, items, callback) {
    this.emitReqRefresh(component, 'fakeDel', { categoryId: 20, ids: items.map(item => item.__c175) }, callback, {
      valid: '请至少选择一件商品',
      prompt: '确认删除商品?',
      success: '引入的商品被删除了'
    });
  },
  deleteBuy(component, items, callback) {
    this.emitReqRefresh(component, 'fakeDel', { categoryId: 16, ids: items.map(item => item.__c194) }, callback, {
      valid: '请至少选择一件商品',
      prompt: '确认删除商品?',
      success: '商品被删除了'
    });
  },
// ===========================================
  obtainPay(component, item, callback) {
    const jsonStr = [];
    jsonStr.push({
      _Key: '__c172',
      _Value: 5
    });

    this.emitReq(component, 'createUpdate', {
      jsonStr,
      pageId: 217,
      itemId: item.__c161
    }, (ret) => {
      component.itemNav({
        pageId: 80003,
        redirect: true,
        params: {
          data: ret.data,
          pay: ret.message
        }
      });
      callback(ret);
    });
  },
  changeOrderStatus(component, item, status, callback, messages) {
    const jsonStr = [];
    jsonStr.push({
      _Key: '__c172',
      _Value: status
    });

    let statusName = '';
    switch(status) {
      case 5:
        statusName = '买家付款中';
        break;
      case 6:
      statusName = '已付款待发货';
        break;
      case 7:
      statusName = '已发货待确认';
        break;
      case 8:
      statusName = '已确认收货';
        break;
      case 9:
      statusName = '买家申请取消';
        break;
        case 10:
        statusName = '订单确认取消';
          break;
          case 11:
          statusName = '系统异常订单';
            break;
      default:
        break;
    }

    this.emitReqRefresh(component, 'createUpdate', {
      jsonStr,
      pageId: 100,
      itemId: item.__c161
    }, callback, messages, [{
      __c172: {
        ID: status,
        statusName
      },
      __c161: item.__c161
    }]);
  },
  confirmOrder(component, item, callback) {
    this.changeOrderStatus(component, item, 8, callback, {
      prompt: '是否确认收货?',
      success: '订单成功确认收货'
    });
  },
  applyCancelOrder(component, item, callback) {
    this.changeOrderStatus(component, item, 9, callback, {
      prompt: '是否确认申请取消该订单?',
      success: '您成功申请取消订单,请等待店家回复'
    });
  },
  sendOrder(component, item, callback) {
    this.changeOrderStatus(component, item, 7, callback, {
      prompt: '是否确认发货?',
      success: '订单已确认发货'
    });
  },
  cancelOrder(component, item, callback) {
    this.changeOrderStatus(component, item, 10, callback, {
      prompt: '是否确认取消该订单?',
      success: '订单成功被取消'
    });
  },
  deleteOrder(component, items, callback) {
    this.emitReqRefresh(component, 'fakeDel', { categoryId: 14, ids: items.map(item => item.__c161) }, callback, {
      valid: '请至少选择一张订单',
      prompt: '确认删除订单?',
      success: '订单被删除了'
    });
  },
// ===========================================
  deleteOften(component, items, callback) {
    this.emitReqRefresh(component, 'fakeDel', { categoryId: 23, ids: items.map(item => item.__c191) }, callback, {
      valid: '请至少选择一条数据',
      prompt: '确定要删除该历史信息吗?',
      success: '历史记录被删除了'
    });
  },
  topOften(component, item, callback) {
    const jsonStr = [];
    jsonStr.push({
      _Key: '__c299',
      _Value: 1
    });

    this.emitReqRefresh(component, 'createUpdate', {
      jsonStr,
      pageId: 171,
      itemId: item.__c191
    }, callback);
  },
  addOften(component, shopId, callback) {
    const jsonStr = [];
    jsonStr.push({
      _Key: '__c193',
      _Value: shopId
    });

    this.emitReqRefresh(component, 'createUpdate', {
      jsonStr,
      pageId: 170,
    }, callback);
  },
// ===========================================
  deleteFriend(component, items, callback) {
    this.emitReqRefresh(component, 'fakeDel', { categoryId: 25, ids: items.map(item => item.__c201) }, callback, {
      valid: '请至少选择一条数据',
      prompt: '确定要删除该好友吗?',
      success: '好友被删除了'
    });
  },
  deleteMessage(component, item, callback) {
    const jsonStr = [];
    jsonStr.push({
      _Key: '__c240',
      _Value: item.server_identity
    });
    jsonStr.push({
      _Key: '__c238',
      _Value: 563
    });

    this.emitReqRefresh(component, 'createUpdate', {
      jsonStr,
      pageId: 224,
      itemId: 0
    }, callback, {
      valid: '请至少选择一条数据',
      prompt: '确定要删除该消息吗?',
      success: '消息被删除了'
    });
  },
  markReaded(component, item, callback) {
    const jsonStr = [];
    jsonStr.push({
      _Key: '__c242',
      _Value: true
    });
    jsonStr.push({
      _Key: '__c240',
      _Value: item.server_identity
    });

    this.emitReqRefresh(component, 'createUpdate', {
      jsonStr,
      pageId: 224,
      itemId: 0
    }, callback);
  },
  agreeFriend(component, item, callback) {
    const jsonStr = [];
    jsonStr.push({
      _Key: '__c203',
      _Value: item.__c126
    });

    this.emitReqRefresh(component, 'createUpdate', {
      jsonStr,
      pageId: 193,
      itemId: 0
    }, callback);
  },
  ignoreFriend(component, item, callback) {
    const jsonStr = [];
    jsonStr.push({
      _Key: '__c124',
      _Value: 602
    });

    this.emitReqRefresh(component, 'createUpdate', {
      jsonStr,
      pageId: 85,
      itemId: item.__c118
    }, callback);
  },
// ===========================================
  deleteAddress(component, items, callback) {
    const ids = items.map(item => item.__c206);
    this.emitReqRefresh(component, 'fakeDel', { categoryId: 18, ids  }, callback, {
      valid: '请至少选择一条数据',
      prompt: '确定要删除该地址吗?',
      success: '地址被删除了'
    });
  },
  defaultAddress(component, item, callback) {
    const jsonStr = [];
    jsonStr.push({
      _Key: '__c215',
      _Value: 564
    });

    this.emitReqRefresh(component, 'createUpdate', {
      jsonStr,
      pageId: 131,
      itemId: item.__c206
    }, callback);
  },
  comment(component, item, callback) {
    const keys = Object.keys(item);
    const jsonStr = [];
    keys.forEach((key) => {
      jsonStr.push({
        _Key: key,
        _Value: item[key]
      })
    });
    this.emitReqRefresh(component, 'createUpdate', {
      jsonStr,
      pageId: 32
    }, callback);
  },
  like(component, item, callback) {
    const jsonStr = [
      {
        _Key: '__c46',
        _Value: 1
      }
    ];
    const keys = Object.keys(item);
    keys.forEach((key) => {
      jsonStr.push({
        _Key: key,
        _Value: item[key]
      })
    });
    this.emitReqRefresh(component, 'createUpdate', {
      jsonStr,
      pageId: 25,
      itemId: 0
    }, callback);
  },
  dislike(component, item, callback) {
    const jsonStr = [
      {
        _Key: '__c46',
        _Value: -1
      }
    ];
    const keys = Object.keys(item);
    keys.forEach((key) => {
      jsonStr.push({
        _Key: key,
        _Value: item[key]
      })
    });
    this.emitReqRefresh(component, 'createUpdate', {
      jsonStr,
      pageId: 25,
      itemId: 0
    }, callback);
  },
  attention(component, item, callback) {
    const jsonStr = [];
    const keys = Object.keys(item);
    keys.forEach((key) => {
      jsonStr.push({
        _Key: key,
        _Value: item[key]
      })
    });
    this.emitReq(component, 'createUpdate', {
      jsonStr,
      pageId: 210
    }, callback);
  },
  // 首页
  fetchMain(component, callback) {
    this.emitReq(component, 'bi', {
      pageId: 151,
      lscStr: []
    }, callback);
  },
  // 活动
  fetchActivity(component, callback) {
    this.emitReq(component, 'bi', {
      pageId: 152,
      lscStr: []
    }, callback);
  },
  // 主题 社区 个性秀
  fetchSubject(component, callback) {
    this.emitReq(component, 'bi', {
      pageId: 153,
      lscStr: []
    }, callback);
  },
  // 门店首页
  fetchDealer(component, server_identity, callback) {
    this.emitReq(component, 'common', {
      pageId: 163,
      lscStr: [{ _Key: '__c249', _Value: server_identity }]
    }, callback);
  },
// ===========================================
  fetchGoodsDetail(component, itemId, callback) {
    this.emitReq(component, 'common', {
      pageId: 208,
      lscStr: [{ _Key: Reg.GUID.test(itemId) ? '__c204' : '__c60', _Value: itemId }]
    }, callback);
  },
// ===========================================
  sendComment(component, item, callback) {
    const jsonStr = [];
    jsonStr.push({
      _Key: '__c53',
      _Value: item.content
    });
    jsonStr.push({
      _Key: '__c57',
      _Value: item.ID
    });

    this.emitReqRefresh(component, 'createUpdate', {
      jsonStr,
      pageId: 32,
      itemId: 0
    }, callback);
  }
};
