let signalRHubConnectionFunc;

if (!wx.bizsaas) {
  wx.bizsaas = {
    navigator: {},
    console: console
  };
}

if (!wx.bizsaas.addEventListener) {
  wx.bizsaas.addEventListener = wx.bizsaas.addEventListener = () => { };
}
wx.bizsaas.navigator.userAgent = 'weapp';
wx.bizsaas.jQuery = require('./signalr-jquery-polyfill.js').default;

export default {
  setLogger: (logger) => {
    if (wx.bizsaas.console && wx.bizsaas.console.debug) {
      wx.bizsaas.console.debug('OVERWRITING CONSOLE.DEBUG in react-native-signalr');
    } else if (!wx.bizsaas.console) {
      wx.bizsaas.console = {};
    }
    wx.bizsaas.console.debug = logger;
  },
  hubConnection: (serverUrl, options) => {
    wx.bizsaas.document = wx.bizsaas.document || { readyState: 'complete' };
    if (!signalRHubConnectionFunc) {
      require('./jquery.signalR');
      signalRHubConnectionFunc = wx.bizsaas.jQuery.hubConnection;
    }
    const [protocol, host] = serverUrl.split(/\/\/|\//);
    if (options && options.headers) {
      wx.bizsaas.jQuery.defaultAjaxHeaders = options.headers;
    }

    const hubConnectionFunc = signalRHubConnectionFunc(serverUrl, options);
    const originalStart = hubConnectionFunc.start;
    hubConnectionFunc.start = (...args) => {
      wx.bizsaas.document = wx.bizsaas.document || { readyState: 'complete' };
      wx.bizsaas.document.createElement = () => {
        return {
          protocol,
          host
        };
      };
      wx.bizsaas.location = {
        protocol,
        host
      };
      const returnValue = originalStart.apply(hubConnectionFunc, args);
      wx.bizsaas.document = undefined;
      return returnValue;
    };

    return hubConnectionFunc;
  }
};
