import config from '../config/config';
import log from '../utils/log';
import rater from '../polaris/rater/rater';
import { updateItemExt, getStatusMapChecked, getStatusMap } from '../utils/utils';
import xnumber from '../polaris/xnumber/xnumber';
import tab from '../polaris/tab/tab';
const regeneratorRuntime = require('../lib/regenerator-runtime/runtime');

export default {
    reduxState: [ 'cuser', 'department' ],
    getCurrentEditData(gindex, index) {
        const data = this.getData();
        if (typeof gindex !== 'undefined') {
            const group = (data.items && data.items[gindex]) || {};
            if (typeof index !== 'undefined') {
                const item = (group.items && group.items[index]) || {};
                return item;
            } else {
                return group;
            }
        } else {
            return data.item || {};
        }
    },
    updateCurrentEditData(gindex, index, column, data) {



        let com;
        if (typeof gindex !== 'undefined') {
            if (typeof index !== 'undefined') {
                this.setData(data, `items[${gindex}].items[${index}]`);
                if (column && column.component) {
                    com = this.coms[`coms.${gindex}.${index}.${column.eid}`];
                }
            } else {
                this.setData(data, `items[${gindex}]`);
                if (column && column.component) {
                    com = this.coms[`coms.${gindex}.${column.eid}`];
                }
            }
        } else {
            const items = this.getData().items;
            const gindex = items && items.length > 0 ? items.findIndex((i) => i.commonSubmit) : -1;
            if (gindex >= 0) {
                this.setData(data, `items[${gindex}]`);
            }
            this.setData(data, 'item');
            if (column) {
                const columns = this.columns;
                let cc = columns.find((c) => c.ID === column.ID);
                if (cc && cc.component) {
                    com = this.coms[`coms.${column.eid}`];
                }
            }
        }
        com && com.updateValues(data[column.eid], true);
    },
    methods: {
        handleDelete(gindex, index) {
            const data = this.getData();
            if (gindex || gindex === 0) {
                if (index || index === 0) {
                    this.setData({
                        items: data.items.map((gitem, gi) => {
                            if (gindex === gi) {
                                return gitem.merge({
                                    items: gitem.items.slice(0, index).concat(gitem.items.slice(index + 1))
                                });
                            } else {
                                return gitem;
                            }
                        })
                    });
                } else {
                    this.setData({
                        items: data.items.slice(0, gindex).concat(this.getData().items.slice(gindex + 1))
                    });
                }
            }
        },
        handlePreview(e) {
            const { gindex, index, column, findex } = e.currentTarget.dataset;
            const editData = this.getCurrentEditData(gindex, index);
            const files = editData[column.eid + '___Files'];
            wx.previewImage({
                current: files[findex].FilePath,
                urls: files.map((item) => item.FilePath)
            });
        },
        handlePreview2(e) {
            const { files, findex ,files2 } = e.currentTarget.dataset;
            console.log(files2,findex);
            if (files && files.length>0){
              wx.previewImage({
                  current: files[findex] && (files[findex].FilePath || files[findex].url || files[findex]),
                  urls: files.map((item) => item && (item.FilePath || item.url || item))
              });
            } else if (files2 && files2.length>0){

              if (files2[findex] && files2[findex].FilePath)

              wx.downloadFile({
                       url: files2[findex].FilePath,
                       success: function (res) {
                         console.log(res)
                         var Path = res.tempFilePath              //返回的文件临时地址，用于后面打开本地预览所用
                         wx.openDocument({
                           filePath: Path,
                           success: function (res) {
                             console.log('打开文档成功')
                           }
                         })
                       },
                       fail:function (res){
                         console.log(res)
                       }
                     })

            }

        },
        handleButtonClicked(e) {
            const { button, item, gindex, index } = e.currentTarget.dataset;
            this.emit('buttonClick', this.page, button, item, gindex, index);
        },
        showPicker(e) {
            const { gindex, index, column } = e.currentTarget.dataset;
            const editData = this.getCurrentEditData(gindex, index);

            if (column.linkChain) {
                this.emit('showChainPicker', this.page, {
                    gindex,
                    index,
                    column,
                    editData,
                    statusMap: this.getStatusMap(column)
                });
            } else {

               console.log(this);
               console.log(this.getStatusMap(column));



                const items = getStatusMapChecked(
                    getStatusMap(column, {
                        users: this.redux.cuser.data,
                        departments: this.redux.department.data,
                        statusMap: this.getStatusMap(column)
                    }),
                    editData[column.eid]
                );
                    console.log("zzzzzz22222");
                this.emit(
                    'showPanelPicker',
                    this.page,
                    {
                        gindex,
                        index,
                        column
                    },
                    column.multi ? 'check' : 'radio',
                    column.editType === 'user' || column.editType === 'users' || items.length > 10,
                    [
                        {
                            items
                        }
                    ]
                );
            }
        },
        pickerLink(e) {
            const { gindex, index, column } = e.currentTarget.dataset;
            const editData = this.getCurrentEditData(gindex, index);
            console.log('pickerLink');
            console.log(column.joinPage);
            console.log(column);
            if (column.joinPage) {
                const param = this.fixLinkLsc(column, editData);
                if (param.lsc.length > 0 && !param.lsc[0].val1 && param.cc) {
                    this.emit('showToptip', this.page, {
                        icon: 'warn',
                        text: '请先选择' + param.cc.primaryText
                    });
                    return;
                }

                const alpha = typeof column.alpha === 'undefined' ? true : column.alpha;
                this.emit(
                    'showLinkPanel',
                    this.page,
                    {
                        gindex,
                        index,
                        column
                    },
                  //  column.joinPage.ID,   20-06-17修改
                    column.property.modalPageId?column.property.modalPageId:column.joinPage.ID,
                    column.join.joinCategoryId,
                    '__c' + column.join.viewPatternId,
                    param,
                    column.multi ? 'check' : 'radio',
                    alpha
                );
            }
        },
        fixLinkLsc(column, item) {
            const lsc = [];
            const linkPatternId = this.fixLinkPattern(column);
            const itemPre = {};
            let cc = null;
            if (linkPatternId) {
                lsc.push({
                    patternId: linkPatternId[1],
                    val1: item[`__c${linkPatternId[0]}`],
                    pTypeId: 23,
                    operation: 1
                });
                cc = this.filter.display.find((i) => i.ID == linkPatternId[0]);
                const co = cc ? `__c${cc.join.viewPatternId}` : 'primaryText';
                itemPre[`__c${linkPatternId[1]}`] = {
                    server_identity: item[`__c${linkPatternId[0]}`],
                    [co]: item[`__c${linkPatternId[0]}___Display`]
                };
            }
            this.customFixLinkLsc && this.customFixLinkLsc(column, item, lsc);
            return {
                lsc,
                item: itemPre,
                cc
            };
        },
        fixLinkPattern(column) {
            const page = config.router[this.getOption('pageId')];
            return page && page.fixLinkPattern && page.fixLinkPattern[column.ID];
        },
        handleRemoveAttachment(e) {
            const { index, gindex, column, findex } = e.currentTarget.dataset;
            const editData = this.getCurrentEditData(gindex, index);
            const files = editData[column.eid + '___Files'].filter((f, i) => i !== findex);
            // editData[column.eid + '___Files'].splice(findex, 1);
            // this.updateCurrentEditData(gindex, index, column, {
            //   [`${column.eid}___Files`]: editData[column.eid + '___Files']
            // });
            this.setColumn(column, files, gindex, index);
        },
        handleRemoveUser(e) {
            const { index, gindex, column, sindex } = e.currentTarget.dataset;
            const editData = this.getCurrentEditData(gindex, index);
            editData[column.eid + '___Orgin'].splice(sindex, 1);

            this.setColumn(column, editData[column.eid + '___Orgin'], gindex, index);
        },
        handleStatus(e) {
            const { index, gindex, column, status } = e.currentTarget.dataset;
            const editData = this.getCurrentEditData(gindex, index);
            const orgData = editData[column.eid + '___Orgin'];
            if (column.multi) {
                if (status.checked) {
                    const index = orgData.findIndex((s) => s.ID == status.ID);
                    if (index >= 0) {
                        orgData.splice(index, 1);
                    }
                } else {
                    orgData.push(status);
                }
                this.setColumn(column, orgData, gindex, index);
            } else {
                if (status.checked) {
                    this.setColumn(column, [], gindex, index);
                } else {
                    this.setColumn(column, [ status ], gindex, index);
                }
            }
        },
        handleAttachment(e) {
            const { index, gindex, column } = e.currentTarget.dataset;
            const editData = this.getCurrentEditData(gindex, index);
            const files = editData[column.eid + '___Files'];
            wx.chooseImage({
                count: column.editType === 'attachment' ? 1 : 9,
                success: (data) => {
                    data.tempFilePaths.forEach((file) => {
                        files.push({
                            type: 'local',
                            FilePath: file
                        });
                    });
                    this.setColumn(column, files, gindex, index);
                    // this.updateCurrentEditData(gindex, index, column, {
                    //   [`${column.eid}___Files`]: files
                    // });
                }
            });
        },
        dataChange(e) {
            let { gindex, index, column, value } = e.currentTarget.dataset;
            if (this.customDataChanged && this.customDataChanged(e)) {
                return;
            }
            if (typeof value === 'undefined') {
                value = typeof e.detail.value === 'undefined' ? null : e.detail.value;
            }

            this.setColumn(column, value, gindex, index);
            this.setData({
                focusedTextArea: ''
            });
        },
        focusTextArea(e) {
            const { gindex, index, column } = e.currentTarget.dataset;
            this.setData({
                focusedTextArea: `${gindex}${index}${column.eid}`
            });
        }
    },
    fixLinkLsc(column, item) {
        const lsc = [];
        const linkPatternId = this.fixLinkPattern(column);
        if (linkPatternId) {
            const rx = /^__c\d+$/gi;
            const rguid = /^[a-zA-Z0-9-]+$/gi;
            for (let key in item) {
                if (rx.test(key) && item[key] && rguid.test(item[key])) {
                    lsc.push({
                        patternId: linkPatternId,
                        val1: item[key],
                        pTypeId: 23,
                        operation: 1
                    });
                }
            }
        }
        return lsc;
    },
    fixLinkPattern(column) {
        const page = config.router[this.getOption('pageId')];
        return page && page.fixLinkPattern && page.fixLinkPattern[column.ID];
    },
    onReady() {
        this.on('panelPickerReturn', this.panelPickerReturn);
        this.on('chainPickerReturn', this.chainPickerReturn);
    },
    async chainPickerReturn(scope, returnScope, data) {
        if (returnScope === this.scope) {
            // console.log(data);
            for (let ii = 0; ii < data.column.linkChain.length; ii++) {
                const ll = data.column.linkChain[ii];
                const tt = this.setColumn(ll, data.editData[ll.ID] || [], data.gindex, data.index);
                if (tt) {
                    await tt;
                }
            }
        }
    },
    panelPickerReturn(scope, returnScope, key, selected) {
        if (returnScope === this.scope) {
            const { gindex, index, column } = key;
            this.setColumn(column, selected, gindex, index);
        }
    },
    getStatusMap(column) {

        let sts = (this.filter && this.filter.statusMap) || [];

        if (!sts && this.allFilter){
          sts = this.allFilter[column.pageId].statusMap || [];
        }
        return sts;
        //2021-08-10


        if (column.pageId == this.getOption('pageId')) {
            return (this.filter && this.filter.statusMap) || [];
        } else if (this.allFilter && this.allFilter[column.pageId]) {
            return this.allFilter[column.pageId].statusMap || [];
        }
        return [];
    },
    setColumn(column, value, gindex, index) {
        console.log(column);
        const columns = (this.filter && this.filter.display) || [];

        console.log(columns);

        const key = column;
        if (typeof column === 'number') {
            column = columns[column];
        } else if (typeof column === 'string') {
            column = columns.find((item) => item.eid === column);
        }

       console.log(column);
        console.log(value);




        if (column) {
            const newItem = this.getCurrentEditData(gindex, index);
            const users = this.redux.cuser && this.redux.cuser.data;
            const departments = this.redux.department && this.redux.department.data;
            updateItemExt(
                columns,
                {
                    users,
                    departments,
                    statusMap: this.getStatusMap(column)
                },
                column,
                newItem,
                value,
                'ord'
            ).then(() => {
                this.customModifyColumn && this.customModifyColumn(column, newItem, gindex, index);
                this.updateCurrentEditData(gindex, index, column, newItem);
                this.notifyDataChange && this.notifyDataChange(columns, column, value, gindex, index);
            });
        } else {
            this.customSetColumn && this.customSetColumn(columns, key, value, gindex, index);
        }
    },
    mergeInComing(inComing) {
        Object.keys(inComing).forEach((key) => {
            this.setColumn(key, inComing[key]);
        });
    },
    createEmbedComponent(column, gindex, index, item) {
        if (column && column.component) {
            let com;
            if (column.component.component === 'xnumber') {
                com = xnumber;
            } else if (column.component.component === 'rater') {
                com = rater;
            }
            let id = `coms.${column.eid}`;
            if (gindex || gindex === 0) {
                if (index || index === 0) {
                    id = `coms.${gindex}.${index}.${column.eid}`;
                } else {
                    id = `coms.${gindex}.${column.eid}`;
                }
            }
            if (!this.coms[id]) {
                this.createComponent(com, id, column.component.options);
            }
            this.coms[id].callback = (value) => {
                this.setColumn(column, value, gindex, index);
            };
            if (item) {
                this.coms[id].updateValues(item[column.eid], true);
            }
        }
        // Tab等容器每个section只能一个，否则放多个section
        // console.log('createEmbedComponent', column, gindex, index ,item );
        if (!column && item.type && typeof index === 'undefined') {
            // console.log('createEmbedComponent', item);
            if (
                item.type.indexOf('tab') === 0 ||
                item.type.indexOf('scroll') === 0 ||
                item.type.indexOf('wrap') === 0
            ) {
                let id = `coms.${gindex}.tab`;
                const data = {
                    list: item.items || item.list
                };
                if (typeof item.selectedId !== 'undefined') {
                    data.selectedId = item.selectedId;
                }
                if (!this.coms[id]) {
                    this.createComponent(tab, id, {
                        data
                    });
                } else {
                    this.coms[id].setData(data);
                }
            }
        }
    }
};
