import * as request from '../utils/request';
import storage from '../utils/storage';
import config from '../config/config';
import log from '../utils/log';
import regeneratorRuntime from '../lib/regenerator-runtime/runtime';

export default {
    updateAction: '',
    delSTR: [],
    reduxState: [ 'user', 'department' ],
    mustLogin: true,
    refreshColumns: true,
    editType: 'singleMaster', // 是多主表还是多副表
    submited: false,
    forEdit: true,
    pushToValue(des, source) {
        const columnReg = /^__c\d+$/;
        for (let key in source) {
            if (columnReg.test(key)) {
                const item = des.find((i) => i._Key === key);
                if (item) {
                    item._Value = source[key];
                } else {
                    des.push({
                        _Key: key,
                        _Value: source[key]
                    });
                }
            }
        }
    },
    methods: {
        moreButtonClicked(button) {
            if (button.id === 'submit') {
                setTimeout(() => {
                    this.submit();
                }, 20);
            }
        }
    },
    clearForm() {
        Alert.alert('提示', '确认清空表单?', [
            { text: '取消', onPress: () => {} },
            {
                text: '确定',
                onPress: async () => {
                    const pageId = this.getOption('pageId');
                    if (/^\d+$/.test(pageId)) {
                        await storage.removeItem(`formCache_${pageId}`);
                    }
                    this.subInited = false;
                    this.fetchDetail();
                }
            }
        ]);
    },
    async onUnload() {
        const pageId = this.getOption('pageId');
        if (/^\d+$/.test(pageId) && !this.getOption('itemId')) {
            if (this.submited) {
                await storage.removeItem(`formCache_${pageId}`);
            } else if (this.editType === 'singleMaster') {
                // 保存草稿
                const items = (this.coms.list && this.coms.list.getData().items) || [];
                const commonSubmit = {};
                items.filter((gitem) => gitem.commonSubmit).forEach((gitem) => Object.assign(commonSubmit, gitem));
                const tempM = Object.assign({ related: [] }, this.getData().item, commonSubmit);

                for (let gindex = 0; gindex < items.length; gindex++) {
                    const gitem = items[gindex];
                    if (gitem.unsubmit || gitem.commonSubmit) {
                        continue;
                    }

                    const slave = {
                        pageId: gitem.ID,
                        list: []
                    };
                    for (let index = 0; index < gitem.items.length; index++) {
                        const item = gitem.items[index];
                        if (item.unsubmit) {
                            continue;
                        }

                        slave.list.push(item);
                    }

                    tempM.related.push(slave);
                }

                await storage.setItem(`formCache_${pageId}`, {
                    item: tempM
                });
            }
        }
    },
    getSingleData(columns, itemId, item) {
        const outPromises = [];
        const values = [];



        if (columns) {
            columns.forEach((column) => {
                let value = item[column.eid];
                if (column.editType === 'attachment' || column.editType === 'attachments') {
                    const files = item[column.eid + '___Files'];
                    const fileIds = [];
                    const promises = [];
                    for (let f in files) {
                        const file = files[f];
                        if (file.type === 'local') {
                            const promise = request
                                .upload(itemId, file.FilePath, this.redux.user.uploadKey)
                                .then((fileUpdata) => {
                                    fileIds.push(fileUpdata.ID);
                                });
                            promises.push(promise);
                        } else {
                            fileIds.push(file.ID);
                        }
                    }
                    const outPromise = Promise.all(promises).then(() => {
                        value = fileIds.join(',');
                        values.push({
                            _Key: column.eid,
                            _Value: value
                        });
                    });
                    outPromises.push(outPromise);
                } else {
                    values.push({
                        _Key: column.eid,
                        _Value: value
                    });
                }
            });
        } else {
            const keys = Object.keys(item).filter((key) => key.substr(0, 2) === '__' && key.indexOf('___') === -1);
            keys.forEach((key) => {
                values.push({
                    _Key: key,
                    _Value: item[key]
                });
            });
        }

        return Promise.all(outPromises).then(() => {
            return values;
        });
    },
    submit() {
        const links = this.getData().item.links || [];
        const master = [];



        if (this.coms.list && this.coms.list.getData().items && this.coms.list.getData().items.length > 0) {
            const items = this.coms.list.getData().items;


            console.log(items);





            const commonSubmit = {};
            items.filter((gitem) => gitem.commonSubmit).forEach((gitem) => Object.assign(commonSubmit, gitem));

            if (this.editType === 'singleMaster') {


                 console.log(commonSubmit);
                 console.log(this.getData().item);




                // 单主表多副表，现在的主要形式   //覆盖有问题 ssong 2020-05-29
                const tempM = Object.assign({ slave: [] },  this.getData().item , commonSubmit  ,{ID:"master"});

                console.log(tempM);




                if (!this.checkValid(null, tempM)) {
                    return;
                }

                for (let gindex = 0; gindex < items.length; gindex++) {
                    const gitem = items[gindex];
                    if (gitem.unsubmit || gitem.commonSubmit) {
                        continue;
                    }

                    const slave = [];

                    console.log(gitem);

                    //修改后逻辑
                    if (gitem.header && gitem.header.columns && !this.checkValid(gitem.header.columns, gitem)){
                      return ;
                    }
                      tempM.slave.push(gitem);
                      slave.push(gitem);

                    //逻辑已修改，主从表请核对
                    // for (let index = 0; index < gitem.items.length; index++) {
                    //     const item = gitem.items[index];
                    //     if (item.unsubmit) {
                    //         continue;
                    //     }
                    //
                    //     if (item.columns && !this.checkValid(item.columns, item)) {
                    //         return;
                    //     }
                    //
                    //     console.log(item);
                    //
                    //     tempM.slave.push(item);
                    //     slave.push(item);
                    // }

                    // console.log(slave);
                    //
                    // return false;

                    if (slave.length < 1) {
                        this.emit('showToptip', this.page, { text: `请录入至少一条完整记录` });
                        return;
                    }
                }

                master.push(tempM);

                console.log(master);


            } else if (this.editType === 'multiSlave') {
                // 每个分组是一次提交，原为订单分单，现无用
                for (let gindex = 0; gindex < items.length; gindex++) {
                    const gitem = items[gindex];
                    if (gitem.unsubmit || gitem.commonSubmit) {
                        continue;
                    }

                    const tempM = Object.assign({ slave: [] }, this.getData().item, commonSubmit, gitem);
                    if (!this.checkValid(gitem.columns, tempM)) {
                        return;
                    }

                    for (let index = 0; index < gitem.items.length; index++) {
                        const item = gitem.items[index];
                        if (item.unsubmit) {
                            continue;
                        }

                        if (item.columns && !this.checkValid(item.columns, item)) {
                            return;
                        }
                        tempM.slave.push(item);
                    }

                    if (tempM.slave.length < 1) {
                        this.emit('showToptip', this.page, { text: `请录入至少一条记录(${gindex})` });
                        return;
                    }
                    master.push(tempM);
                }
            } else {
                // 每行记录都是一次主表提交，多记录一起提交
                for (let gindex = 0; gindex < items.length; gindex++) {
                    const gitem = items[gindex];
                    if (gitem.unsubmit || gitem.commonSubmit) {
                        continue;
                    }

                    for (let index = 0; index < gitem.items.length; index++) {
                        const item = gitem.items[index];
                        if (item.unsubmit) {
                            continue;
                        }

                        const tempM = Object.assign({ slave: [] }, this.getData().item, commonSubmit, gitem, item);
                        if (!this.checkValid(gitem.columns, tempM)) {
                            return;
                        }

                        master.push(tempM);
                    }
                }
            }
        } else if (links && links.length > 0) {
            // 从小程序部分代码迁移
            for (let l = 0; l < links.length; l += 1) {
                if (links[l].unsubmit) {
                    continue;
                }

                const tempM = Object.assign({ slave: [] }, this.getData().item, links[l]);
                if (!this.checkValid(null, tempM)) {
                    return;
                }

                master.push(tempM);
            }
        } else {
            if (!this.checkValid()) {
                return;
            }
            master.push(Object.assign({ slave: [] }, this.getData().item));
        }

        if (master.length < 1) {
            this.emit('showToptip', this.page, { text: `请录入至少一条记录` });
            return;
        }

        // const tagS = this.getOption('smartTagSource');
        // const tagDes = this.getOption('smartTagDes');
        // if (tagS && tagDes) {
        //   this.emit('showLoading', this.page);
        //   const outPromises = [];
        //   for(let ii = 0; ii < master.length; ii ++) {
        //     const m = master[ii];
        //     if (m[tagS]) {
        //       outPromises.push(request.smartTag(this, m[tagS]).then((ret) => {
        //         if (ret.d && ret.d.length > 0) {
        //           m[tagDes] = ret.d.slice(0, 6).map(t => t.Name).join(',');
        //         }
        //       }));
        //     }
        //     Promise.all(outPromises).then(() => {
        //       this.emit('hideLoading', this.page);
        //       this._submit(master);
        //     }).catch((error) => {
        //       this.commonErrorMsg(error);
        //     });
        //   }
        // } else {
        this._submit(master);
        // }
    },
    _submit(master) {
        const relatedSTR = this.getData().item.relatedData || [];

        this.emit('showLoading', this.page);

        const outPromises = [];
        const itemId = this.getOption('itemId') ? this.getOption('itemId') : 0;
        const slaveKey = {};

        let updateAction = 'createUpdate';
        if (this.updateAction) {
            updateAction = this.updateAction;
        } else if (
            this.filter.pageConfig &&
            this.filter.pageConfig.page &&
            (this.filter.pageConfig.page.pageType === 99 || this.filter.pageConfig.page.pageType === 100)
        ) {
            updateAction = 'complexUpdate';
        }

        for (let ii = 0; ii < master.length; ii++) {
            const inPromises = [];
            inPromises.push(this.getSingleData(this.filter.display, itemId, master[ii]));
            for (let jj = 0; jj < master[ii].slave.length; jj++) {
                let slave = master[ii].slave[jj];
                if (!slave.key){
                    slave.key = slave.header.key;
                }

                let slaveItemId = 0;
                if (slave.keyCol) {
                    slaveItemId = slave[slave.keyCol];
                } else if (!slaveKey[slave.key]) {

                    console.log(this.redux);
                    console.log(slave.key);


                    const slavePage = this.redux.filter[slave.key];  //allFilter
                    if (slavePage) {
                        const slaveIndex = slavePage.display.find((c) => c.isIndex);
                        if (slaveIndex) {
                            slaveKey[slave.key] = slaveIndex.eid;
                            slaveItemId = slave[slaveKey[slave.key]];
                        }
                    }
                } else {
                    slaveItemId = slave[slaveKey[slave.key]];
                }
                inPromises.push(this.getSingleData(slave.submitColumns, slaveItemId || 0, slave));
            }
            outPromises.push(
                Promise.all(inPromises).then((lines) => {
                    const tempRelated = [ ...relatedSTR ];
                    for (let kk = 1; kk < lines.length; kk++) {
                        const slave = master[ii].slave[kk - 1];
                        tempRelated.push({
                            key: slave.key,
                            value: lines[kk]
                        });
                    }

                    const jsonStr =
                        updateAction === 'createUpdate'
                            ? lines[0]
                            : [
                                  {
                                      key: `__p${this.getOption('submitPageId') || this.getOption('pageId')}`,
                                      value: lines[0]
                                  }
                              ];
                    return request[updateAction]({
                        pageId: this.getOption('submitPageId') || this.getOption('pageId'),
                        itemId,
                        jsonStr,
                        relatedSTR: tempRelated,
                        delSTR: this.delSTR
                    });
                })
            );
        }

        Promise.all(outPromises)
            .then((ret) => {
                this.emit('hideLoading', this.page);
                this.emit('refresh_data', null, this.options.idColumn);
                this.submited = true;
                this.afterUpdate(ret);
            })
            .catch((error) => {
                this.commonErrorMsg(error);
            });
    },
    afterUpdate() {
        wx.navigateBack();
    },
    updateButtons() {
        return [
            {
                id: 'submit',
                label: '提交'
                // icon: 'fa fa-check'
            }
        ];
    },
    onFirstShow() {
        if (!this.mustLogin || this.isLogged()) {
            this.delSTR = [];
            this.fetchDetail(true);
        }
    },
    checkValid(columns, data) {
        if (this.customCheckValid && this.customCheckValid(columns) === false) {
            return false;
        }
        columns || (columns = this.columns || this.filter.display);
        data || (data = this.getData().item);
        let check = null;
        for (let ii = 0; ii < columns.length; ii += 1) {
            const item = columns[ii];
            if (item.isIndex) {
                continue;
            }
            const pageId = this.getOption('pageId');
            const uncheck = this.uncheck || (config.router[pageId] && config.router[pageId].uncheck);
            if (uncheck && uncheck.findIndex((u) => u === item.eid) >= 0) {
                continue;
            }
            if (item.required && (!data[item.eid] || data[item.eid] === '')) {
                check = { item, type: 'required' };
                break;
            }

            if (item.validator && !new RegExp(item.validator).test(data[item.eid]) && data[item.eid]) {
                check = { item, type: 'regex' };
                break;
            }

            if (item.equal && data[item.eid] != data[item.equal]) {
                check = { item, type: 'equal' };
                break;
            }
        }

        if (check) {
            if (check.type === 'required') {
                this.emit('showToptip', this.page, { icon: 'warn', text: '必须填写' + check.item.primaryText });
            } else if (check.type === 'regex') {
                this.emit('showToptip', this.page, { icon: 'warn', text: '请填写正确的' + check.item.primaryText });
            } else if (check.type === 'equal') {
                this.emit('showToptip', this.page, { icon: 'warn', text: `两次输入的${check.item.primaryText}不一致` });
            }
            return false;
        }
        return true;
    },
    updateRedux() {
        const inComing = this.getOption('item');
        if (
            this.filter &&
            this.detailData.data &&
            this.detailData.fetching === false &&
            !this.detailData.error &&
            inComing
        ) {
            this.mergeInComing(inComing);
        }
    }
};
