import { fetchDetail, fetchDetailSuccess } from '../redux/detail';

import log from '../utils/log';

export default {
    data: {
        item: {
            related: []
        }
    },
    fetching: false,
    detailData: {},
    reduxState: [ 'detailData' ],
    reduxDispatch: { fetchDetailAction: fetchDetail, fetchDetailSuccess },
    updateRedux({ detailData }) {
         if (this.getOption('useFetch') === false) {
            return;
        }
        const pageId = this.getOption('pageId');
        const itemId = this.getOption('itemId');
        const theData = detailData[pageId];


        if (theData && theData !== this.detailData && theData.itemId === itemId) {
            this.detailData = theData;
            if (theData.fetching) {
                this.emit('showLoading', this.page);
            } else if (theData.error) {
                this.emit('hideLoading', this.page, '加载数据失败,请稍后重试');
                wx.navigateBack();
            } else {
                log('当前数据信息', pageId, itemId, theData);
                this.emit('hideLoading', this.page);

                this.setData({
                    item: theData.data,
                    items: [
                        Object.assign(
                            {
                                commonSubmit: true,
                                items: [
                                    {
                                        unsubmit: true
                                    }
                                ]
                            },
                            theData.data
                        )
                    ]
                });
                this.fetched = true;
                this.afterDetailFetched && this.afterDetailFetched();
            }
            this.fetching = theData.fetching;
        }
    },
    detailUpdated() {
        return (
            this.redux.detailData &&
            this.detailData.data &&
            this.detailData !== this.redux.detailData[this.getOption('pageId')]
        );
    },
    fetchDetail(forEdit) {
        if (this.getOption('useFetch') === false) {
            return;
        }
        this.subInited = false;
        const pageId = this.getOption('pageId');
        const itemId = this.getOption('itemId');
        const server_identity = this.getOption('server_identity');
        if (pageId && this.fetching == false) {
            this.redux.fetchDetailAction({
                pageId,
                itemId,
                forEdit,
                server_identity,
                customModifyItem: this.customModifyItem && this.customModifyItem.bind(this)
            });
        }
    },
    onUnload() {
        const pageId = this.getOption('pageId');
        if (pageId && pageId > 0) {
            this.redux.fetchDetailSuccess({ pageId, itemId: -1 });
        }
    }
};
