import config from '../config/config';
import initFilter from '../module/initFilter';
// 包含一个list组件的组件，响应刷新、筛选条件等事件
import list from '../polaris/list/list';
import log from '../utils/log';
import { tryStrToJson } from '../utils/utils';
import { updateFilter } from '../redux/filter';
import { updateLsc } from '../redux/lsc';

export default {
    lsc: {},
    fetchListOnEnter: true,
    reduxState: [ 'lsc' ],
    reduxDispatch: { updateFilter, updateLsc },
    components: {
        list
    },
    handleRefreshEvent(scope, idColumn, updateData, deleteData) {
        // console.log(this);
        if (idColumn) {
            const pageId = this.coms.list.getOption('pageId');
            const router = config.router[pageId] || {};
            const viewPageId = this.coms.list.getOption('viewPageId');
            const viewRouter = config.router[viewPageId] || {};
            const myIdColumn = router.myIdColumn || router.idColumn || viewRouter.idColumn;

            if (myIdColumn === idColumn) {
                if (updateData || deleteData) {
                    const items = this.coms.list.getData().items;
                    if (updateData) {
                        if (items.length > 0) {
                            let gindex = -1,
                                index = -1;
                            if (items[0].relatedAsItems) {
                                gindex = items.findIndex((gitem) => {
                                    return gitem[idColumn] === updateData[0][idColumn];
                                });
                                if (gindex >= 0) {
                                    let newItem = Object.assign({}, items[gindex], updateData[0]);
                                    this.coms.list.customModifyItem && this.coms.list.customModifyItem(newItem);
                                    let groupItem = newItem.section;
                                    groupItem.items = newItem.items;
                                    this.coms.list.setData(groupItem, `items[${gindex}]`);
                                }
                            } else {
                                gindex = items.findIndex((gitem, gi) => {
                                    index = gitem.items.findIndex((item) => item[idColumn] === updateData[0][idColumn]);
                                    return index >= 0;
                                });
                                if (gindex >= 0) {
                                    let newItem = Object.assign({}, items[gindex].items[index], updateData[0]);
                                    this.coms.list.customModifyItem && this.coms.list.customModifyItem(newItem);
                                    this.coms.list.setData(newItem, `items[${gindex}].items[${index}]`);
                                }
                            }
                        } else {
                            if (this.isShowed) {
                                this.coms.list.refresh();
                            } else {
                                this.firstShow = true;
                            }
                        }
                    } else {
                        const newItems = {
                            items: []
                        };

                        let gindex = -1;
                        for (let ii = 0; ii < items.length; ii++) {
                            let groupInited = false,
                                index = -1;
                            const gitem = items[ii];

                            for (let jj = 0; jj < gitem.items.length; jj++) {
                                const item = gitem.items[jj];

                                if (deleteData.findIndex((i) => i == item[idColumn]) < 0) {
                                    if (groupInited === false) {
                                        groupInited = true;
                                        gindex++;
                                        newItems[`items[${gindex}]`] = Object.assign({}, gitem);
                                        newItems[`items[${gindex}]`].items = [];
                                    }
                                    index++;

                                    newItems[`items[${gindex}].items[${index}]`] = item;
                                }
                            }
                        }

                        this.coms.list.setData(newItems);
                    }
                } else {
                    // console.log(this);
                    if (this.isShowed) {
                        this.coms.list.refresh();
                    } else {
                        this.firstShow = true;
                    }
                }
            }
        } else {
            if (this.isShowed) {
                this.coms.list.refresh();
            } else {
                this.firstShow = true;
            }
        }
    },
    methods: {
        handleFetchMoreEvent() {
            this.coms.list.fetchMore();
        }
    },
    updateRedux({ lsc }) {
        const pageId = this.coms.list.getOption('pageId');
        const theLsc = lsc[pageId];
        if (
            theLsc &&
            theLsc !== this.lsc &&
            ((theLsc.lsc || null) !== (this.lsc.lsc || null) ||
                (theLsc.fixedLsc || null) !== (this.lsc.fixedLsc || null) ||
                (theLsc.error || null) !== (this.lsc.error || null))
        ) {
            log('当前查询条件', pageId, theLsc);
            this.lsc = theLsc;
            if (this.lsc.error) {
                this.emit('showToptip', this.page, { icon: 'cancel', text: '刷新搜索条件失败' });
            } else {
                this.coms.list.updateLsc(this.lsc.lsc);
                this.coms.list.setFixedLsc(this.lsc.fixedLsc);
                this.coms.list.refresh();
            }
        }
    },
    onLoad(options) {
        this.on('onReachBottom', this.handleFetchMoreEvent);
        this.on('refresh_data', this.handleRefreshEvent);
        if (options.lsc) {
            this.coms.list.setFixedLsc(tryStrToJson(options.lsc));
        }
    },
    onFirstShow() {
        if (this.fetchListOnEnter && (!this.mustLogin || this.isLogged())) {
            // this.options.searchInput 可能有问题，后面再看
            this.coms.list.refresh();
        }
    },
    onUnload() {
        this.redux.updateFilter({
            pageId: this.coms.list.getOption('pageId'),
            searchInput: '',
            sort: [],
            filter: {},
            orgFilter: {}
        });
        this.redux.updateLsc({ pageId: this.coms.list.getOption('pageId'), lsc: null });
    },
    updatePageInfo(item) {
        if (item.pageId) {
            this.coms.list.setPageId(item.pageId);
            this.coms.searchbar && this.coms.searchbar.setPageId(item.pageId);
            this.coms.filtab && this.coms.filtab.setPageId(item.pageId);
            this.coms.morefiltpanel && this.coms.morefiltpanel.setPageId(item.pageId);
            this.setData({
                pageId: item.pageId
            });
            initFilter(this.redux.updateFilter, item.pageId);
            this.pageId = item.pageId;
        }
        if (item.lsc) {
            this.coms.list.updateLsc(item.lsc);
        } else {
            this.coms.list.updateLsc([]);
        }
    }
};
