import { initFilter } from '../redux/filter';
import config from '../config/config';
import immutable from '../lib/seamless-immutable/src/seamless-immutable';
import { updateFilter } from '../redux/filter';

export default {
    refreshColumns: false,
    reduxState: [ 'filter' ],
    reduxDispatch: { initFilter, updateFilter },
    propsToStateCompose: [
        {
            props: [ 'filter' ],
            transform(nextProps, preProps, newState) {
                const nextFilter = nextProps.filter[this.getOption('pageId')];
                if (
                    nextFilter &&
                    nextFilter.filtable &&
                    nextFilter.filtable.length > 0 &&
                    config.router[nextFilter.pageId] &&
                    config.router[nextFilter.pageId].configFilter &&
                    !nextFilter.configFilter &&
                    config.router[nextFilter.pageId].configFilter.filtable
                ) {
                    const filterConfig = config.router[nextFilter.pageId].configFilter.filtable;
                    let newFiltable = immutable([]);
                    filterConfig.forEach((f) => {
                        const org = nextFilter.filtable.find((o) => o.ID == f.ID);
                        if (org) {
                            newFiltable = newFiltable.concat([ org.merge(f) ]);
                        }
                    });
                    newFiltable = newFiltable.concat(
                        nextFilter.filtable.filter((o) => !filterConfig.find((f) => f.ID == o.ID))
                    );

                    console.log('newFiltable', newFiltable);
                    this.redux.updateFilter({ pageId: nextFilter.pageId, filtable: newFiltable, configFilter: true });
                }
            }
        }
    ],
    handleRefreshColumns() {
        const pageId = this.getOption('pageId');
        if (pageId && this.getOption('refreshColumns')) {
            this.redux.initFilter({ pageId: this.getOption('pageId'), selected: this.getOption('selected') });
        }
    },
    onReady() {

        // 组件
        if (!this.isLogged) {
            this.on('refreshColumns', this.handleRefreshColumns);
            this.handleRefreshColumns();
        }
    },
    onFirstShow() {
        // 页面首次出现刷新
        if (this.isLogged && this.isLogged()) {
            this.handleRefreshColumns();
        }
    }
};
