import { confirmFilter, updateFilter, updateSingleFilter, updateSort } from '../redux/filter';
import { getStatusMapChecked, getStatusMap } from '../utils/utils';
import list from '../polaris/list/list';
import immutable from '../lib/seamless-immutable/src/seamless-immutable';
import config from '../config/config';
import storage from '../utils/storage';
import { search2 } from '../utils/request';



export default  {
  index: 0,
  data: {
    currentIndex: -1
  },
  filter: {},
  type: 'filter',
  reduxState: ['cuser', 'department'],
  reduxDispatch: { updateSingleFilter, confirmFilter, updateFilter, updateSort },
  isPanel: true,
  methods: {
    handleReset(e) {
      this.selected = {};
      this.redux.updateFilter({ pageId: this.getOption('pageId'), filter: {} });
    },
    showPicker(e) {
      const { key } = e.currentTarget.dataset;
      const filtable = this.filter.filtable[key];
      const checkType = filtable.multi ? 'check' : 'radio';
      const alpha = true;
      this.isPanel && this.hide();
      const  statusMap = getStatusMap(filtable, {
        users: this.redux.cuser.data, departments: this.redux.department.data, statusMap: this.filter.statusMap
      });
      const items = (filtable.filter ? statusMap.filter(filtable.filter) : statusMap) || [];

      console.log("zzzzzz1111");

      this.emit('showPanelPicker', this.page, key, checkType, alpha, [{ items }]);
    }
  },
  panelPickerReturn(scope, returnScope, key, selected) {
    if (scope === this.scope) {
      if (this.type === 'filter' || this.type === 'extra') {



        this.redux.updateSingleFilter({ pageId: this.getOption('pageId'), index: this.index, items: this.selected, columnID: this.filter.filtable[this.index].ID });
      } else if (this.type === 'sort') {
        this.redux.updateSort({ pageId: this.getOption('pageId'), items: this.selected });
      }
      this.redux.confirmFilter({ pageId: this.getOption('pageId') });
    } else if (returnScope === this.scope) {
      this.isPanel && this.show();
      key && this.redux.updateSingleFilter({ pageId: this.getOption('pageId'), index: key, items: selected, columnID: this.filter.filtable[key].ID });
    }
  },
  panelPickerCancel(scope, returnScope) {
    if (returnScope === this.scope) {
      this.isPanel && this.show();
    } else if (this.scope === scope) {
      this.redux.updateFilter({ pageId: this.getOption('pageId'), filter: this.filter.orgFilter });
    }
  },
  checkableTap(scope, items, indexs, item) {
    const childScope = this.getChildEventScope(scope);
    if (childScope === 'list' && this.type !== 'more2' && this.type !== 'sort' && this.type !== 'more') {
      this.selected = this.dealWithAll(items, indexs);
      if (this.coms.list.checkType === 'radio') {
        this.handleConfirm();
      } else {
        this.checkItem();
      }
    } if (childScope === 'list' && this.type === 'more'){
      const eid = item.eid;
      const column = this.filter.filtable.find(c => c.eid === eid);
      this.redux.updateSingleFilter({ pageId: this.getOption('pageId'), index: 0, items: this.dealWithAll(items, indexs), columnID: column.ID });
      this.isPanel === false && this.redux.confirmFilter({ pageId: this.getOption('pageId') });
    } else if (childScope === 'list2') {
      this.redux.updateSingleFilter({ pageId: this.getOption('pageId'), index: this.getData().currentIndex, items: this.dealWithAll(items, indexs), columnID: this.filter.filtable[this.getData().currentIndex].ID });
    }
  },
  listTap(scope, indexs, item) {



    const childScope = this.getChildEventScope(scope);

    if (childScope === 'list' && this.type === 'more2') {
      this.setData({
        currentIndex: indexs[1]
      });

      this.coms.list2.updateItems(this.setSingleList(indexs[1], false, true, true));
    } else if (childScope === 'list' && this.type === 'sort') {
      const sort = this.filter.sort && this.filter.sort.length > 0 ? this.filter.sort[0] : {};
      const items = [];
      if (item.ID === sort.ID) {
        if (sort.orderBy === 1) {
          items.push(Object.assign({}, item, { orderBy: 2, icon: 'fa fa-sort-desc' }));
        }
      } else {
        items.push(Object.assign({}, item, { orderBy: 1, icon: 'fa fa-sort-asc' }));
      }
      this.redux.updateSort({ pageId: this.getOption('pageId'), items });
      this.redux.confirmFilter({ pageId: this.getOption('pageId') });
      this.isPanel && this.hide();
    }
  },
  onLoad(options) {




    this.on('panelPickerCancel', this.panelPickerCancel);
    this.on('panelPickerReturn', this.panelPickerReturn);
  },
  updateRedux(props) {
    const { filter } = props;
    const theFilter = filter[this.getOption('pageId')];
    if (theFilter && theFilter !== this.orgFilter) {
      this.orgFilter = theFilter;
      this.filter = this.filtFilter && theFilter.filtable ? this.filtFilter(theFilter) : theFilter;
      setTimeout(()=>{
        this.checkItem();
      }, 20);
    }
  },
  dealWithAll(items, indexs) {
    // 当前点击区域的数据
    items = items.filter(i => i.indexes[0] === indexs[0]);
    if (items.length > 1) {
      // 包含全部项
      const all = items.find(i => typeof i.ID === 'undefined');
      if (all) {
        // 点击的就是全部项
        if (all.indexes[0] === indexs[0] && all.indexes[1] === indexs[1]) {
          items = [all];
        } else if (items.find(i => i.indexes[1] === indexs[1])) {
          items = items.filter(i => typeof i.ID !== 'undefined');
        }
      }
    }
    return items;
  },
  setSingleList(ii, isMore, checkPickLength, hasCheckAll) {
    if (ii >= this.filter.filtable.length) {
      return {
        items: []
      };
    }
    const filtable = this.filter.filtable[ii];
    const checkType = filtable.multi ? 'check' : 'radio';
    const filt = (this.filter.filter && this.filter.filter[filtable.ID]) || [];



    const first = filt && filt.length > 0 && filt[0];
    const min = first && first.min || '';
    const max = first && first.max || '';
    const eid = `__c${filtable.ID}`;
    const filtableID = filtable.ID;

    if (filtable.pTypeId === 24) {
      if (first || this.location) {
        return {
          checkType,
          items: [{ tag: filtable.primaryText,
            items: [first || this.location],
            pTypeId: filtable.pTypeId,
            key: ii,
            type: 'list-item'
          }]
        };
      } else {
        wx.getLocation({
          type: 'gcj02', //返回可以用于wx.openLocation的经纬度//
          success: (res) => {
            this.location = { primaryText: '我的位置', min: res.longitude, max: res.latitude, eid, filtableID };
            this.checkItem();
          },
          fail(error) {
            log(error);
          }
        });
        return {
          checkType: '',
          items: [{
            tag: filtable.primaryText,
            items: [{ primaryText: '正在定位...',
              type: 'list-item',
              noNav: true
            }]
          }]
        };
      }
    } else {
      const  statusMap = getStatusMap(filtable, {
        users: this.redux.cuser.data, departments: this.redux.department.data, statusMap: this.filter.statusMap
      });
      let items = (filtable.filter && statusMap ? statusMap.filter(filtable.filter) : statusMap) || [];


        // configList = yield call(storage.getItem, 'reduxPersist:configuration');
        //
        // console.log(configList);

        // storage.getItem('reduxPersist:configuration', (error, data)=>{
        //     storage.getItem('reduxPersist:page', (error, data2)=>{
        //
        //   //
        //
        //
        //    const configList = JSON.parse(data);
        //    const pageList = JSON.parse(data2);
        //
        //    // console.log(configList);
        //    // console.log(pageList );
        //
        //    const userListPage = configList.data.find(x=>x.configuration_key=='userListPageId');
        //    const userGroupPattern = configList.data.find(x=>x.configuration_key=='userGroupPatternId');
        //    const userNamePattern = configList.data.find(x=>x.configuration_key=='userNamePatternId');
        //
        //    if (userListPage && userGroupPattern && userNamePattern){
        //         const uPage =  pageList.data.find(x=>x.ID ==userListPage.configuration_value );
        //
        //         if (uPage){
        //                 search2(uPage.categoryId,userListPage.configuration_value ,[],1,100 ).then((ret)=>{
        //                    // items =[];
        //                    // ret.data.forEach(x=>{
        //                    //    item.push({
        //                    //       primaryText : x.__c55.XingMing,
        //                    //       XingMing :x.__c55.XingMing,
        //                    //       ID: x.__c55.UserId,
        //                    //       UserId: x.__c55.UserId
        //                    //     });
        //                    // });
        //
        //
        //
        //
        //
        //
        //                 });
        //         }
        //     }
        //
        //  });
        //
        // });






      let itemProp = {};
      if (isMore) {
        if (this.columnCount) {
          itemProp = { columnCount: this.columnCount };
        } else {
          itemProp = { noFixWidth: true };
        }
      }

      items = items.map(i => Object.assign({ eid, filtableID, useCheckIcon: true, checkIconClass: 'text-lg text-primary font-thin', uncheckIconClass: 'text-lg text-muted font-thin', checked: filt.find(f => f.ID === i.ID) }, i, itemProp));

    //  console.log(items);

      // if (hasCheckAll) {
      //   items = immutable([{
      //     type: 'list-check-Right',
      //     primaryText: '全部',
      //     eid,
      //     filtableID,
      //     checked: filt.find(f => typeof f.ID === 'undefined')
      //   }]).concat(items);
      // }  显示有问题

      if (filtable.pTypeId == 4) {
        items = immutable([{
          columns: [
            // {
            //   noLabel: true,
            //   editType: 'number-range',
            //   eid,
            //   filtableID,
            //   ID: filtable.ID,
            //   property: {}
            // }
          ],
          uncheckable: true,
          columnCount: 1,
          [`__c${filtable.ID}`]: { min, max }
        }]).concat(items);
      } else if (filtable.pTypeId == 6) {
        items = immutable([{
          columns: [
            // {
            //   noLabel: true,
            //   editType: 'date-range',
            //   eid,
            //   filtableID,
            //   ID: filtable.ID,
            //   property: {},
            // }
          ],
          uncheckable: true,
          columnCount: 1,
          [`__c${filtable.ID}`]: { min, max }
        }]).concat(items);
      } else if (filtable.pTypeId == 5 || filtable.pTypeId == 7) {
        items = immutable([{
          columns: [
            // {
            //   noLabel: true,
            //   editType: 'filttext',
            //   eid,
            //   filtableID,
            //   ID: filtable.ID,
            //   property: {},
            // }
          ],
          uncheckable: true,
          columnCount: 1,
          [`__c${filtable.ID}`]: { min }
        }]).concat(items);
      } else if (items.length > config.showPickerLength && checkPickLength) {
        items = items.slice(0, config.showPickerLength);
        if (isMore) {
          items = items.concat([Object.assign({
            uncheckable: true,
            type: 'tab-label',
            primaryText: '选择更多',
            showPicker: true,
            eid,
            filtableID
          }, itemProp)]);
        } else {
          items = immutable([{
            uncheckable: true,
            type: 'list-check-Right',
            primaryText: '选择更多',
            class:'',
            showPicker: true,
            eid,
            filtableID,
            columnCount: 1
          }]).concat(items);
        }
      }





      return {
        checkType,
        items: [{ tag: filtable.primaryText,
          items,
          pTypeId: filtable.pTypeId,
          key: ii
        }]
      };
    }
  },
  checkItem() {
    if (this.visible && this.filter.filtable && this.redux) {
      this.page.clearDataTimer();
      this.coms.list && (this.coms.list.alpha = false);
      if (this.type === 'filter' || this.type === 'extra') {
        this.coms.list.setCheckType(this.filter.filtable[this.index].multi ? 'check' : 'radio');
        const single = this.setSingleList(this.index);
        let items = single.items[0].items;


        if (this.initSelect) {
          this.initSelect = false;
          this.selected = items.filter((i) => i.checked);
      } else {
          items = items.map((item) => {
              const checked = this.selected.findIndex((aa) => aa.ID === item.ID) > -1;
              if (checked !== item.checked) {
                  return Object.assign({}, item, { checked });
              } else {
                  return item;
              }
          });
      }
        this.setData({
          checkType: this.coms.list.checkType
        });
        // const  statusMap = getStatusMap(this.filter.filtable[this.index], {
        //   users: this.redux.cuser.data, departments: this.redux.department.data, statusMap: this.filter.statusMap
        // });
        const editType = this.filter.filtable[this.index].editType;
        this.coms.list.alpha = (editType === 'user' || editType === 'users' || items.length > 10);
        // const items = this.filter.filtable[this.index].filter ? statusMap.filter(this.filter.filtable[this.index].filter) : statusMap;
        this.coms.list.updateItems([
          {
            header: 'header2',
            type: 'list-item',
            class: 'b-t',
            items
          }]);
      } else if (this.type === 'sort') {
        this.coms.list.setCheckType('radio');
        this.setData({
          checkType: this.coms.list.checkType
        });
        this.coms.list.updateItems([
          {
            header: 'header2',
            type: 'list-item',
            class: 'b-t',
            items: this.filter.sortable.filter(item => !item.tab)
          }]);
      } else if (this.type === 'more') {
        const items = [];


        for (let ii = 0; ii < this.filter.filtable.length; ii += 1) {
          const filtable = this.filter.filtable[ii];


          const single = this.setSingleList(ii, true, true, true);

          let item;
          if (filtable.pTypeId === 1) {
            item = Object.assign({}, filtable, single.items[0], { items: [{
              columns: [
                // {
                //   noLabel: true,
                //   editType: 'filter-switch',
                //   eid: `__c${filtable.ID}`,
                //   ID: filtable.ID,
                //   property: {},
                //   // items: single.items[0].items,
                //   primaryText: filtable.primaryText
                // }
              ],
              uncheckable: true,
              columnCount: 1,
              [`__c${filtable.ID}`]: single.items[0].items[0].checked
            }] });
          } else {
            const showMore = this.showMore && this.columnCount ? (this.pageConfig.showMoreFilterItem && typeof this.pageConfig.showMoreFilterItem[filtable.ID] !== 'undefined' ? this.pageConfig.showMoreFilterItem[filtable.ID] : true) : undefined;

            const items = typeof showMore === 'undefined' || showMore ? single.items[0].items : single.items[0].items.slice(0, this.columnCount);

            item = Object.assign({ checkType: single.checkType, header: {
              type: 'header-filter',
              showMore,
              button: 'showMoreFilterItem',
              filtable
            }}, filtable, single.items[0], { items });
          }
          if (!item.type) {
            item.type = 'tag-label';
          }



          if (filtable.pTypeId===2
          || filtable.pTypeId===13
          || filtable.pTypeId===6
          || filtable.pTypeId===20
          || filtable.pTypeId===26
          )
          items.push(item);
        }



        this.coms.list.updateItems(items);
      } else if (this.type === 'more2') {
        this.coms.list.setCheckType('radio');
        const currentIndex = this.getData().currentIndex;
        this.coms.list.updateItems([{ items: this.filter.filtable.map((item, index) => Object.assign({}, item, { checked: index === currentIndex })) }]);
        if (currentIndex >= 0) {
          this.coms.list2.updateItems(this.setSingleList(currentIndex, false, true, true));
        }
      }
      this.customCheckItem && this.customCheckItem();
      this.page.setDataTimer();
    }
  },
  customDataChanged(gindex, index, column, value) {
    const pageId = this.getOption('pageId');
    const filtable = this.filter.filtable.find(c => c.eid === column.eid);
    if (filtable.pTypeId === 1) {

      this.redux.updateSingleFilter({ pageId,
        index: 0,
        items: [value ? {
          ID: true,
          primaryText: '是',
        } : {
          ID: false,
          primaryText: '否',
        }],
        columnID: column.ID
      });
    } else {
      this.redux.updateSingleFilter({ pageId,
        index: 0,
        items: [{
          displayText: `${value.min}-${value.max}`,
          min: value.min,
          max: value.max,
          ID: 0
        }],
        columnID: column.ID
      });
    }
  }
}
