export default {
  extendModeButtons(component, button) {
    const buttons = [];
    if (button.id === 'enterSelect') {
      if (component.selectMode === 'check') {
        if (component.selectAll) {
          buttons.push({
            id: 'selectAll',
            label: '全选',
            icon: 'fa fa-check-square-o'
          });
        } else {
          buttons.push({
            id: 'unCheckAll',
            label: '全不选',
            icon: 'fa fa-square-o'
          });
        }
      }
    }
    return buttons;
  },
  updateButtons(component) {
    const buttons = [];

    if (component.getOption('createPageId') && !component.getOption('noCreatePage')) {
      buttons.push({
        id: 'new',
        label: '新增',
        icon: 'icon-plus'
      });
    }

    if (component.hasGrid) {
      if (component.redux.setting.viewType === 'list') {
        buttons.push({
          id: 'grid',
          label: '网格视图',
          icon: 'icon-grid'
        });
      } else {
        buttons.push({
          id: 'list',
          label: '列表视图',
          icon: 'icon-list'
        });
      }
    }

    if (component.selectMode) {
      buttons.push({
        id: 'enterSelect',
        label: '进入选择',
        icon: 'icon-login',
        extend: true
      });
    }

    return buttons;
  }
}
