import log, { mark } from '../utils/log';

import config from '../config/config';
import { fixedEncodeURIComponent } from '../utils/utils';
import { getPerformanceTiming } from '../utils/log';

export default function getPage(Root, pageOptions) {
    return {
        pageData: {},
        setHalfData(data) {
            let keys = Object.keys(data);
            if (keys.length === 1) {
                const value = data[keys[0]];
                if (value.slice && Array.isArray(value.slice())) {
                    data = {};
                    value.forEach((v, idx) => {
                        if (typeof v !== 'undefined') {
                            data[`${keys[0]}[${idx}]`] = v;
                        }
                    });
                    keys = Object.keys(data);
                } else if (typeof value === 'object') {
                    data = {};
                    const vks = Object.keys(value);
                    vks.forEach((vk) => {
                        if (typeof value[vk] !== 'undefined') {
                            data[`${keys[0]}.${vk}`] = value[vk];
                        }
                    });
                    keys = Object.keys(data);
                } else if (typeof value === 'undefined') {
                    return;
                }
            }
            // console.log('setHalfData', data);
            let half1;
            let half2;
            let halfCount = Math.floor(keys.length / 2);
            halfCount < keys.length - 1 || (halfCount = keys.length - 2);
            // console.log(halfCount, keys.length);
            keys.forEach((key, index) => {
                if (index <= halfCount) {
                    if (!half1) {
                        half1 = {};
                    }
                    half1[key] = data[key];
                } else {
                    if (!half2) {
                        half2 = {};
                    }
                    half2[key] = data[key];
                }
            });
            if (half1) {
                if (JSON.stringify(half1).length > 1048576) {
                    this.setHalfData(half1);
                } else {
                    mark(`${this.route}#setData`);
                    this.setData(half1, () => {
                        mark(`${this.route}#setData`, `${this.route}#setDataEnd`);
                    });
                }
            }
            if (half2) {
                if (JSON.stringify(half2).length > 1048576) {
                    this.setHalfData(half2);
                } else {
                    mark(`${this.route}#setData`);
                    this.setData(half2, () => {
                        mark(`${this.route}#setData`, `${this.route}#setDataEnd`);
                    });
                }
            }
        },
        setPageData(data) {
            Object.assign(this.pageData, data);
            this.pageData.changed = true;
        },
        setDataFix(data) {
            if (JSON.stringify(data).length > 1048576) {
                this.setHalfData(data);
            } else {
                mark(`${this.route}#setData2`);
                this.setData(data, () => {
                    mark(`${this.route}#setData2`, `${this.route}#setDataEnd2`);
                });
            }
        },
        onLoad(options) {
            mark(`${this.route}#onLoad`);
              console.log(this);
            if (options.json) {
                options.json = decodeURIComponent(options.json).replace(/~/gi, '"');
                const json = JSON.parse(options.json);
                options = json;
            }
            this.options = Object.assign({}, pageOptions, options);
            log('page options', this.options);

            this.clearDataTimer();
            this.setPageData({
                options: this.options
            });
            this.root = new Root();
            // mark(`${this.route}#onLoad`, `${this.route}#createRoot`);
            this.emit('onLoad', this, this.options);
            mark(`${this.route}#onLoad`, `${this.route}#onLoadEnd`);

            wx.showShareMenu({
                withShareTicket: true
            });
        },
        onUnload() {
            this.emit('onUnload', this);
            getApp().event.offctx(this);

            // 这个好像不起作用，还要考虑一下
            const newData = {};
            for (let key in this.data) {
                newData[key] = null;
            }
            this.setData(newData);
            this.root = null;
        },
        on(event, fn, fire) {
            getApp().event.on(event, fn, fire, this);
        },
        off(event) {
            getApp().event.off(event, this);
        },
        clearDataTimer() {
            this.pageData.batch = true;
            if (this.dataTimer) {
                clearTimeout(this.dataTimer);
                this.dataTimer = null;
            }
        },
        setDataTimer() {
            if (this.pageData.changed) {
                this.dataTimer = setTimeout(() => {
                    this.dataTimer = null;
                    if (this.pageData.changed) {
                        this.setDataFix(this.pageData);
                    }
                    this.pageData = {};
                }, 20);
            } else {
                this.pageData = {};
            }
        },
        emit(event, ctx, ...params) {
            this.clearDataTimer();
            getApp().event.emit(event, ctx, ...params);
            this.setDataTimer();
        },
        onReady() {
            // console.log('........onReady');
            mark(`${this.route}#onLoadEnd`, `${this.route}#onReady`);
            this.emit('onReady', this);
            this.emit('onShow', this);
            this.isReady = true; // 强制将onShow放入onReady后面，保持和react-native端一致
            mark(`${this.route}#onReady`, `${this.route}#onReadyEnd`);
        },
        onShow() {
            if (this.isReady) {
                // console.log('........onShow');
                this.emit('onShow', this);
            }
        },
        onHide() {
            this.emit('onHide', this);
        },
        tapMenu(e) {
            const { url } = e.currentTarget.dataset;
            this.navigateTo(url);
        },
        navigateTo(url, params) {
            if (getCurrentPages().length === 5) {
                this.emit('showToptip', this.page, { icon: 'warn', text: '您打开了太多的页面' });
            } else {
                params && (url = `${url}?json=${fixedEncodeURIComponent(JSON.stringify(params))}`);
                wx.navigateTo({
                    url
                });
            }
        },
        onPullDownRefresh() {
            this.emit('onPullDownRefresh', this);
        },
        onReachBottom() {
            this.emit('onReachBottom', this);
        },
        shareByJump() {
            const page = config.router[this.options.pageId];
            const json = {
                jump: `/${this.route}`,
                params: Object.assign({ fromShare: true }, this.options)
            };
            if (page && page.tab) {
                json.tab = true;
            }

            return `/${config.router.init.router}?json=${fixedEncodeURIComponent(JSON.stringify(json))}`;
        },
        shareDirectly() {
            const page = config.router[this.options.pageId];
            return `/${this.route}?json=${fixedEncodeURIComponent(
                JSON.stringify(Object.assign({ fromShare: true }, this.options))
            )}`;
        },
        onShareAppMessage(res) {
            const path = this.ShareByJump ? this.shareByJump() : this.shareDirectly();
            log('onShareAppMessage', res, this.route, this.options, path);

            return {
                path,
                success(result) {
                    log(result);
                    if (result.errMsg === 'shareAppMessage:ok') {
                        wx.getShareInfo({
                            shareTicket: result.shareTickets[0],
                            success(info) {
                                log(info);
                            }
                        });
                    }
                }
            };
        }
    };
}
